<?php

namespace App\Http\Controllers\Admin\Traits;

use App\Models\InvoiceReturn;
use Illuminate\Http\Request;
use App\Models\Invoices;
use App\Models\GeneralSettings;
use App\General\GeneralSettingsClass;

use DB;

trait ReturnInvoiceTrait
{
    public function ReturnReviewInvoice($id, $invoice_return)
    {
        $GST = config('app.PERCENTAGE') ?? 0;
        $settings = GeneralSettings::get();
        $pos_invoice_note = GeneralSettingsClass::getOptionValue('_pos_invoice_note', $settings);

        # Company Details
        $company_logo = url('/') . '/' . GeneralSettingsClass::getRequiredValue('_header_logo');
        $company = GeneralSettingsClass::getRequiredValue('_b_name');
        $company_address = GeneralSettingsClass::getRequiredValue('_b_street_address');
        $company_state_country = GeneralSettingsClass::getRequiredValue('_b_area_address');
        $company_email = GeneralSettingsClass::getRequiredValue('_b_email');
        $company_phone = GeneralSettingsClass::getRequiredValue('_b_number');
        
        // Invoice and Return
        $invoice = Invoices::find((int) $id);
        $customer_details = "";
        
        if ($invoice) {
            $amount_to_return = 0;
        
            if (isset($invoice_return) && $invoice_return) {
                $invoice_return_meta = $invoice_return->invoice_return_meta->toArray();
            }
        
            if ($invoice->customer_type === "existing") {
                $user = User::find($invoice->customer);
                $UserMeta = UserMeta::where('user_id', $invoice->customer)->get()->keyBy('option');
        
                $b_name = $UserMeta['_b_name']->value ?? $user->name ?? 'N/A';
                $street_address = $UserMeta['_b_street_address']->value ?? 'N/A';
                $area_address = $UserMeta['_b_area_address']->value ?? 'N/A';
                $email = $UserMeta['_b_email']->value ?? $user->email ?? 'N/A';
                $phone = $UserMeta['_b_number']->value ?? $user->phone ?? 'N/A';
        
                $customer_details = '<strong>' . $b_name . '</strong><br>' .
                                    $street_address . '<br>' .
                                    $area_address . '<br>' .
                                    '<abbr title="Email">E:</abbr> ' . $email . '<br>' .
                                    '<abbr title="Phone">P:</abbr> ' . $phone;
            } elseif ($invoice->customer_type === "random") {
                $customer_details = "<strong>" . $invoice->customer . "</strong>";
            }
        }
        

            $invoice_items = "";
            $i = 1;
            $sub_total = 0;
            foreach ($invoice->invoiceMeta as $invoice_item) {
                if ($invoice_return) {
                    $return_key = array_search($invoice_item->product_id, array_column($invoice_return_meta, 'product_id'));
                    $return_units = $invoice_return_meta[$return_key]['return_units'];
                } else {
                    $return_units = 0;
                }

                $total_sale_price = $invoice_item->unit_price * $return_units;
                $invoice_items = $invoice_items . '<tr>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $i . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $invoice_item->product_name . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: center;">' . $invoice_item->units . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: center;">' . $return_units . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $invoice_item->unit_price . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $total_sale_price . '</td>
                                </tr>';
                $i++;

                $sub_total += $total_sale_price;
            }
            $return_sub_total = $invoice->discounted_amount - $invoice_return->grand_total;
            $invoice_template = <<<INVOICE
                <div style="max-width: 800px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333; background-color: #fff;">
                    <div style="text-align: center; margin-bottom: 20px;">
                        <img src="$company_logo" style="max-width: 180px; height: auto;" alt="logo">
                    </div>
                    
                    <div style="border-bottom: 2px solid #ed1c24; padding-bottom: 10px; margin-bottom: 20px;">
                        <h2 style="color: #ed1c24; margin: 0;">RETURN INVOICE <span style="float: right; font-size: 16px;">#$invoice->invoice_number</span></h2>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
                        <div style="width: 48%;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">From:</h4>
                            <div style="line-height: 1.5;">
                                <strong>$company</strong><br>
                                $company_address<br>
                                $company_state_country<br>
                                <span style="display: inline-block; margin-right: 10px;"><strong>E:</strong> $company_email</span><br>
                                <span><strong>P:</strong> $company_phone</span>
                            </div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">To:</h4>
                            <div style="line-height: 1.5;">
                                $customer_details
                            </div>
                        </div>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px; background-color: #f9f9f9; padding: 15px; border-radius: 5px;">
                        <div style="width: 48%;">
                            <div><strong>Payment Method:</strong> $invoice->payment_method</div>
                            <div><strong>Payment Status:</strong> $invoice->payment_status</div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <div><strong>Return Date:</strong> $invoice_return->return_date</div>
                        </div>
                    </div>
                    
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                        <thead>
                            <tr style="background-color: #ed1c24; color: white;">
                                <th style="padding: 10px; text-align: left;">#</th>
                                <th style="padding: 10px; text-align: left;">Description</th>
                                <th style="padding: 10px; text-align: center;">Quantity</th>
                                <th style="padding: 10px; text-align: center;">Return Items</th>
                                <th style="padding: 10px; text-align: right;">Unit Cost</th>
                                <th style="padding: 10px; text-align: right;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            $invoice_items
                        </tbody>
                    </table>
                    
                    <div style="display: flex; justify-content: space-between;">
                        <div style="width: 48%; padding-right: 20px;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">Notes</h4>
                            <div style="background-color: #f9f9f9; padding: 10px; border-radius: 5px; min-height: 100px;">
                                <p style="margin: 0 0 5px;">$invoice->payment_id</p>
                                <p style="margin: 0;">$pos_invoice_note</p>
                            </div>
                        </div>
                        <div style="width: 48%; border-left: 1px solid #eee; padding-left: 20px;">
                            <table style="width: 100%; border-collapse: collapse;">
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Sub - Total amount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$return_sub_total</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->discount%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Discounted Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice_return->general_discounted_amount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->membership_discount%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discounted Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice_return->membership_discount_amount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left; color: #777; font-size: 12px;">GST ($GST%):</td>
                                    <td style="padding: 5px 0; text-align: right; color: #777; font-size: 12px;">$$invoice_return->gst</td>
                                </tr>
                            </table>
                            <div style="margin-top: 15px; padding-top: 15px; border-top: 2px solid #ed1c24;">
                                <div style="display: flex; justify-content: space-between; align-items: center;">
                                    <strong style="font-size: 16px;">Amount Return:</strong>
                                    <span style="font-size: 22px; color: #ed1c24; font-weight: bold;">$$invoice_return->grand_total</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; text-align: center; font-size: 12px; color: #777;">
                        <p style="margin: 0;">Thank you for your business!</p>
                    </div>
                </div>
INVOICE;
            return $invoice_template;
        }
   

    public function IndividualReturnReviewInvoice($id, $invoice_return, $return_sub_total, $discounted_amount, $membership_discounted_amount, $gst, $grand_total)
    {
        $GST = config('app.PERCENTAGE') ?? 0;
        $settings = GeneralSettings::get();
        $pos_invoice_note = GeneralSettingsClass::getOptionValue('_pos_invoice_note', $settings);

        # Company Details

        
        // Company Info
        $company_logo = url('/') . '/' . GeneralSettingsClass::getRequiredValue('_header_logo');
        $company = GeneralSettingsClass::getRequiredValue('_b_name');
        $company_address = GeneralSettingsClass::getRequiredValue('_b_street_address');
        $company_state_country = GeneralSettingsClass::getRequiredValue('_b_area_address');
        $company_email = GeneralSettingsClass::getRequiredValue('_b_email');
        $company_phone = GeneralSettingsClass::getRequiredValue('_b_number');
        $abn = GeneralSettingsClass::getRequiredValue('_abn');
        $bankDetails = GeneralSettingsClass::getRequiredValue('_bank_details');
        $bsb = GeneralSettingsClass::getRequiredValue('_bsb');
        $acc = GeneralSettingsClass::getRequiredValue('_acc');
        $bankName = GeneralSettingsClass::getRequiredValue('_bank_name');
        
        // Invoice & Customer Info
        $invoice = Invoices::find((int) $id);
        $customer_details = "";
        
        if ($invoice) {
            $amount_to_return = 0;
        
            if (isset($invoice_return) && $invoice_return) {
                $invoice_return_meta = $invoice_return->invoice_return_meta->toArray();
            }
        
            if ($invoice->customer_type === "existing") {
                // Load customer data from User & UserMeta
                $user = User::find($invoice->customer);
                $UserMeta = UserMeta::where('user_id', $invoice->customer)->get()->keyBy('option');
        
                $b_name = $UserMeta['_b_name']->value ?? $user->name ?? 'N/A';
                $street_address = $UserMeta['_b_street_address']->value ?? 'N/A';
                $area_address = $UserMeta['_b_area_address']->value ?? 'N/A';
                $email = $UserMeta['_b_email']->value ?? $user->email ?? 'N/A';
                $phone = $UserMeta['_b_number']->value ?? $user->phone ?? 'N/A';
        
                $customer_details = '<strong>' . $b_name . '</strong><br>' .
                                    $street_address . '<br>' .
                                    $area_address . '<br>' .
                                    '<abbr title="Email">E:</abbr> ' . $email . '<br>' .
                                    '<abbr title="Phone">P:</abbr> ' . $phone;
            }
            elseif ($invoice->customer_type === "random") {
                $customer_details = "<strong>" . $invoice->customer . "</strong>";
            }
        }
        

            $invoice_items = "";
            $i = 1;
            $sub_total = 0;
            foreach ($invoice->invoiceMeta as $invoice_item) {
                if ($invoice_return) {
                    $return_key = array_search($invoice_item->product_id, array_column($invoice_return_meta, 'product_id'));
                    $return_units = $invoice_return_meta[$return_key]['return_units'];
                } else {
                    $return_units = 0;
                }

                $total_sale_price = $invoice_item->unit_price * $return_units;
                $invoice_items = $invoice_items . '<tr>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $i . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $invoice_item->product_name . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: center;">' . $invoice_item->units . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: center;">' . $return_units . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $invoice_item->unit_price . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $total_sale_price . '</td>
                                </tr>';
                $i++;

                $sub_total += $total_sale_price;
            }
            $invoice_template = <<<INVOICE
                <div style="max-width: 800px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333; background-color: #fff;">
                    <div style="text-align: center; margin-bottom: 20px;">
                        <img src="$company_logo" style="max-width: 180px; height: auto; filter: invert(1);" alt="logo">
                    </div>
                    
                    <div style="border-bottom: 2px solid #ed1c24; padding-bottom: 10px; margin-bottom: 20px;">
                        <h2 style="color: #ed1c24; margin: 0;">RETURN INVOICE <span style="float: right; font-size: 16px;">#$invoice->invoice_number</span></h2>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
                        <div style="width: 48%;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">From:</h4>
                            <div style="line-height: 1.5;">
                                <strong>$company</strong><br>
                                $company_address<br>
                                $company_state_country<br>
                                <span style="display: inline-block; margin-right: 10px;"><strong>E:</strong> $company_email</span><br>
                                <span><strong>P:</strong> $company_phone</span>
                            </div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">To:</h4>
                            <div style="line-height: 1.5;">
                                $customer_details
                            </div>
                        </div>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px; background-color: #f9f9f9; padding: 15px; border-radius: 5px;">
                        <div style="width: 48%;">
                            <div><strong>Payment Method:</strong> $invoice->payment_method</div>
                            <div><strong>Payment Status:</strong> $invoice->payment_status</div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <div><strong>Return Date:</strong> $invoice_return->return_date</div>
                        </div>
                    </div>
                    
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                        <thead>
                            <tr style="background-color: #ed1c24; color: white;">
                                <th style="padding: 10px; text-align: left;">#</th>
                                <th style="padding: 10px; text-align: left;">Description</th>
                                <th style="padding: 10px; text-align: center;">Quantity</th>
                                <th style="padding: 10px; text-align: center;">Return Items</th>
                                <th style="padding: 10px; text-align: right;">Unit Cost</th>
                                <th style="padding: 10px; text-align: right;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            $invoice_items
                        </tbody>
                    </table>
                    
                    <div style="display: flex; justify-content: space-between;">
                        <div style="width: 48%; padding-right: 20px;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">Notes</h4>
                            <div style="background-color: #f9f9f9; padding: 10px; border-radius: 5px; min-height: 100px;">
                                <p style="margin: 0 0 5px;">$invoice->payment_id</p>
                                <p style="margin: 0;">$pos_invoice_note</p>
                            </div>
                        </div>
                        <div style="width: 48%; border-left: 1px solid #eee; padding-left: 20px;">
                            <table style="width: 100%; border-collapse: collapse;">
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Sub - Total amount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$return_sub_total</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->discount%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Discounted Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$discounted_amount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->membership_discount%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discount Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$membership_discounted_amount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left; color: #777; font-size: 12px;">GST ($GST%):</td>
                                    <td style="padding: 5px 0; text-align: right; color: #777; font-size: 12px;">$$gst</td>
                                </tr>
                            </table>
                            <div style="margin-top: 15px; padding-top: 15px; border-top: 2px solid #ed1c24;">
                                <div style="display: flex; justify-content: space-between; align-items: center;">
                                    <strong style="font-size: 16px;">Amount Return:</strong>
                                    <span style="font-size: 22px; color: #ed1c24; font-weight: bold;">$$grand_total</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; text-align: center; font-size: 12px; color: #777;">
                        <p style="margin: 0;">Thank you for your business!</p>
                    </div>
                </div>
INVOICE;
            return $invoice_template;
        }
     }

    
    
