<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChildCategory extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'main_parent_category',
        'title',
        'volumn',
        'description',
        'image',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'main_parent_category' => 'integer',
        'is_active' => 'boolean',
        'sort_order' => 'integer',
        'volumn' => 'float',
    ];

    public function childCategoryMeta()
    {
        return $this->hasMany(ChildCategoryMeta::class);
    }

    public function mainParentCategory()
    {
        return $this->belongsTo(Category::class, 'main_parent_category', 'id');
    }

    public function bookingItems()
    {
        return $this->morphMany(BookingItem::class, 'entity');
    }


    // Scope for active child categories
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Scope for ordering
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    // Get next sort order for new child categories
    public static function getNextSortOrder()
    {
        $lastChildCategory = self::orderBy('sort_order', 'desc')->first();
        return $lastChildCategory ? $lastChildCategory->sort_order + 1 : 1;
    }
}
