<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quote extends Model
{
    use HasFactory;

    protected $fillable = [
        'uuid',
        'booking_id',
        'truck_id',
        'user_id',
        'distance_km',
        'total_time_minutes',
        'total_cubic_meters',
        'total_package_time_minutes',
        'fixed_price',
        'per_km_price',
        'per_meter_cube_price',
        'number_of_movers',
        'mover_per_hour_price',
        'distance_cost',
        'volume_cost',
        'movers_cost',
        'total_cost',
        'calculation_type',
        'raw_data',
        'status',
        'quote_type',
        'quote_number',
        'order_number',
        'quote_payment_proof',
        'stripe_customer_id',
        'stripe_payment_intent_deposit_id',
        'stripe_payment_intent_remaining_id',
        'deposit_amount',
        'remaining_amount',
        'deposit_payment_status',
        'remaining_payment_status',
        'remaining_payment_url',
        'payment_type',
        'payment_method',
    ];

    protected $casts = [
        'distance_km' => 'decimal:2',
        'total_time_minutes' => 'integer',
        'total_cubic_meters' => 'decimal:2',
        'total_package_time_minutes' => 'decimal:2',
        'fixed_price' => 'decimal:2',
        'per_km_price' => 'decimal:2',
        'per_meter_cube_price' => 'decimal:2',
        'number_of_movers' => 'integer',
        'mover_per_hour_price' => 'decimal:2',
        'distance_cost' => 'decimal:2',
        'volume_cost' => 'decimal:2',
        'movers_cost' => 'decimal:2',
        'total_cost' => 'decimal:2',
        'raw_data' => 'array',
        'quote_number' => 'string',
        'order_number' => 'string',
        'quote_payment_proof' => 'string',
        'deposit_amount' => 'decimal:2',
        'remaining_amount' => 'decimal:2',
        'payment_method' => 'string',
    ];

    // Relationships
    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function truck()
    {
        return $this->belongsTo(Truck::class)->select('id', 'truck_name',  'cubic_capacity', 'number_of_movers');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function generateQuoteNumber()
    {
        do {
            $number = 'QT' . str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT);
        } while (self::where('quote_number', $number)->exists());

        return $number;
    }

    public static function generateOrderNumber()
    {
        do {
            $number = 'ORD' . str_pad(rand(100000, 999999), 6, '0', STR_PAD_LEFT);
        } while (self::where('order_number', $number)->exists());

        return $number;
    }
}
