<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StorageItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'permalink',
        'price',
        'sort_order',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    public static function getNextSortOrder(): int
    {
        $lastItem = self::orderByDesc('sort_order')->first();
        return $lastItem ? (int) $lastItem->sort_order + 1 : 1;
    }

    public function bookingItems()
    {
        return $this->morphMany(BookingItem::class, 'entity');
    }
}

