<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('permalink')->unique();
            $table->text('description')->nullable();
            $table->string('cover_image')->nullable();
            $table->text('featured_images')->nullable(); 
            $table->string('fimage_alt_text')->nullable();
            
            // Image section fields
            $table->text('image_tagline')->nullable();
            $table->text('image_description')->nullable();
            $table->string('image')->nullable();
            $table->string('image_alt_text')->nullable();
            
            // Video section fields
            $table->text('video_url')->nullable();

            $table->longText('video_content')->nullable();
            
            // Main content
            $table->longText('content')->nullable();
            
            // SEO fields
            $table->string('_seo_title')->nullable();
            $table->string('_seo_tags')->nullable();
            $table->longText('_seo_description')->nullable();
            $table->string('_canonical_url')->nullable();
            $table->text('_schema_markup')->nullable();
            $table->tinyInteger('_page_index')->nullable();
            
            // Status and user tracking
            $table->tinyInteger('active')->default(0); // 0=draft, 1=public, 2=private, 3=trash
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->text('blog_categories_id')->nullable(); // Store array of category IDs as JSON
            $table->boolean('is_featured')->default(false); // Featured blog flag
            
            $table->timestamps();
            $table->softDeletes(); // for trash functionality
        });

        // Blog categories table
        Schema::create('blog_categories', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('permalink')->nullable()->unique();
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);

            $table->timestamps();
            
        });

     
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_categories');
        Schema::dropIfExists('blogs');
    }
};