<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('user_type')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->foreignId('pick_up_property_id')->nullable()->constrained('properties')->nullOnDelete();
            $table->foreignId('drop_off_property_id')->nullable()->constrained('properties')->nullOnDelete();
            $table->string('status')->nullable();
            $table->date('move_date')->nullable();
            $table->enum('time_preference', ['morning', 'afternoon', 'custom'])->nullable();
            $table->string('custom_time')->nullable();
            $table->text('reason_to_move')->nullable();
            $table->json('booking_item_ids')->nullable(); // Array of booking_item IDs
            $table->text('difficult_items_notes')->nullable();
            $table->foreignId('truck_id')->nullable()->constrained('trucks')->nullOnDelete();
            $table->decimal('truck_booking_hours', 8, 2)->nullable();
            $table->boolean('is_completed')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('uuid');
            $table->index(['user_id', 'status']);
            $table->index(['pick_up_property_id', 'drop_off_property_id']);
            $table->index('truck_id');
            $table->index('move_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};