{{-- Reusable Delete Confirmation Modal Component --}}
{{-- Usage: @include('Admin.Components.delete-modal', ['id' => $item->id, 'name' => $item->name, 'route' => 'route.name', 'routeParam' => $item->id]) --}}

<div class="modal fade zoomIn" id="deleteConfirmModal{{ $id }}" tabindex="-1"
    aria-labelledby="deleteConfirmModalLabel{{ $id }}" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body p-md-5">
                <div class="text-center">
                    <div class="text-danger">
                        <i class="bi bi-trash display-4"></i>
                    </div>
                    <div class="mt-4 fs-15">
                        <p class="text-muted mx-3 fs-16 mb-0">
                            Are you sure you want to delete
                            <strong>{{ $name }}</strong>?<br>
                            This action cannot be undone.
                        </p>
                        <p class="text-muted mt-2 mb-0">
                            <small>Suggestion: mark it as <em>Inactive</em> instead.</small>
                        </p>
                    </div>
                </div>

                <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                    <button type="button" class="btn w-sm btn-light btn-hover" data-bs-dismiss="modal">Cancel</button>

                    <form action="{{ route($route, $routeParam) }}" method="POST">
                        @csrf
                        @if($route === 'category.delete' || $route === 'child.category.delete')
                            {{-- Routes are POST, not DELETE --}}
                        @else
                            @method('DELETE')
                        @endif
                        @if($route === 'category.delete')
                            <input type="hidden" name="id" value="{{ $routeParam }}">
                        @elseif($route === 'child.category.delete')
                            <input type="hidden" name="child_category" value="{{ $routeParam }}">
                        @endif
                        <button type="submit" class="btn w-sm btn-danger btn-hover">Yes, Delete It!</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
