@php
    $setting = \App\Models\GeneralSettings::all();
    use App\General\GeneralSettingsClass;

@endphp
<div class="app-menu navbar-menu position-fixed">
    <!-- LOGO -->
    <div class="navbar-brand-box">
        <a href="{{ route('Admin.Dashboard') }}" class="logo logo-dark">
            <span class="logo-sm">
                <img src="{{ url('/') . '/' . GeneralSettingsClass::getRequiredValue('_fav_icon') }}" alt=""
                    height="22">
            </span>
            <span class="logo-lg">
                <img class="w-100 h-100"
                    src="{{ url('/') . '/' . GeneralSettingsClass::getRequiredValue('_header_logo') }}" alt="">
            </span>
        </a>

        <a href="{{ route('Admin.Dashboard') }}" class="logo logo-light">
            <span class="logo-sm">
                <!-- Use the same favicon for dark mode -->
                <img src="{{ url('/') . '/' . GeneralSettingsClass::getRequiredValue('_fav_icon') }}" alt=""
                    height="22">
            </span>
            <span class="logo-lg">
                <img class="w-100 h-100"
                    src="{{ url('/') . '/' . GeneralSettingsClass::getRequiredValue('_header_logo_dark') }}"
                    alt="">
            </span>
        </a>
        <button type="button" class="btn btn-sm p-0 fs-20 header-item float-end btn-vertical-sm-hover"
            id="vertical-hover">
            <i class="ri-record-circle-line"></i>
        </button>
    </div>

    <div id="scrollbar" data-simplebar style="height: 100vh !important;min-height: calc(100vh - 185px);">
        <div class="container-fluid">

            <div id="two-column-menu">
            </div>

            <ul class="navbar-nav" id="navbar-nav">
                <li class="menu-title"><span data-key="t-menu">Menu</span></li>

                <!-- Dashboard -->
                <li class="nav-item @php if(request()->is('admin')){echo 'open active';} @endphp">
                    <a href="{{ url('/') }}/admin" class="nav-link menu-link">
                        <i class="fa fa-tachometer-alt"></i>
                        <span data-key="t-dashboard">Dashboard</span>
                    </a>
                </li>

                <!-- Customers -->
                @php
                    $isUserMenuActive =
                        request()->is('admin/users') ||
                        request()->is('admin/users/create') ||
                        request()->is('admin/users/list/customer');
                    @endphp
                    <li class="nav-item">
                    <a class="nav-link menu-link {{ $isUserMenuActive ? '' : 'collapsed' }}" href="#sidebarUsers"
                        data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isUserMenuActive ? 'true' : 'false' }}" aria-controls="sidebarUsers">
                        <i class="fa fa-user-shield"></i>
                        <span data-key="t-customers">Customers</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isUserMenuActive ? 'show' : '' }}" id="sidebarUsers"
                            data-bs-parent="#navbar-nav">
                            <ul class="nav nav-sm flex-column">
                                    <li class="nav-item">
                                <a href="{{ url('/admin/users/create') }}"
                                    class="nav-link {{ request()->is('admin/users/create') ? 'active' : '' }}"
                                    data-key="t-create-user">
                                    Create Customer
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                <a href="{{ url('/admin/users') }}"
                                    class="nav-link {{ request()->is('admin/users') || request()->is('admin/users/list/customer') ? 'active' : '' }}"
                                    data-key="t-customer-list">
                                    Customer List
                                        </a>
                                    </li>
                            </ul>
                        </div>
                    </li>

                <!-- Blogs -->
                            @php
                                $isBlogActive = 
                                    request()->is('admin/blogs') || 
                                    request()->is('admin/blogs/create') || 
                                    request()->is('admin/blogs/*/edit') || 
                                    request()->is('admin/blogs/*') ||
                                    request()->is('admin/blog-categories') ||
                                    request()->is('admin/blog-categories/*');             
                            @endphp

                            <li class="nav-item">
                                <a class="nav-link menu-link" href="#sidebarBlogs" data-bs-toggle="collapse" role="button"
                                aria-expanded="{{ $isBlogActive ? 'true' : 'false' }}" aria-controls="sidebarBlogs">
                        <i class="fa-solid fa-blog"></i>
                                    <span data-key="t-blogs">Blogs</span>
                                </a>

                    <div class="collapse menu-dropdown {{ $isBlogActive ? 'show' : '' }}" id="sidebarBlogs"
                        data-bs-parent="#navbar-nav">
                                    <ul class="nav nav-sm flex-column">
                                            <li class="nav-item">
                                                <a href="{{ route('blogs.create') }}" 
                                                class="nav-link {{ request()->is('admin/blogs/create') ? 'active' : '' }}" 
                                                data-key="t-create-blog">
                                    Create Blog
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="{{ route('blogs.index') }}" 
                                                class="nav-link {{ (request()->is('admin/blogs') && !request()->is('admin/blogs/create') && !request()->is('admin/blogs/list/trash')) || request()->is('admin/blogs/*/edit') || (request()->is('admin/blogs/*') && !request()->is('admin/blogs/create') && !request()->is('admin/blogs/list/trash')) ? 'active' : '' }}" 
                                                data-key="t-blog-list">
                                                    Blog List
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a href="{{ route('admin.blog-categories.index') }}" 
                                                class="nav-link {{ request()->is('admin/blog-categories') || request()->is('admin/blog-categories/*') ? 'active' : '' }}" 
                                                data-key="t-blog-categories">
                                                    Blog Categories
                                                </a>
                                            </li>
                                           
                                    </ul>
                                </div>
                            </li>

                <!-- Services -->
                {{-- @php
                    $isServiceActive = 
                        request()->is('admin/services') || 
                        request()->is('admin/services/create') || 
                        request()->is('admin/services/*/edit') || 
                        request()->is('admin/services/*');             
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link {{ $isServiceActive ? '' : 'collapsed' }}" href="#sidebarServices" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isServiceActive ? 'true' : 'false' }}" aria-controls="sidebarServices">
                        <i class="fa-solid fa-gear"></i>
                        <span data-key="t-services">Services</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isServiceActive ? 'show' : '' }}" id="sidebarServices"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ route('services.create') }}" 
                                    class="nav-link {{ request()->is('admin/services/create') ? 'active' : '' }}" 
                                    data-key="t-create-service">
                                    Create Service
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('services.index') }}" 
                                    class="nav-link {{ (request()->is('admin/services') && !request()->is('admin/services/create') && !request()->is('admin/services/list/trash')) || request()->is('admin/services/*/edit') || (request()->is('admin/services/*') && !request()->is('admin/services/create') && !request()->is('admin/services/list/trash')) ? 'active' : '' }}" 
                                    data-key="t-service-list">
                                    Service List
                                </a>
                            </li>
                            
                        </ul>
                    </div>
                </li> --}}

                <!-- FAQs -->
                @php
                    $isFAQActive = 
                        request()->is('admin/faqs') || 
                        request()->is('admin/faqs/create') || 
                        request()->is('admin/faqs/*/edit') || 
                        request()->is('admin/faqs/*');             
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link {{ $isFAQActive ? '' : 'collapsed' }}" href="#sidebarFAQs" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isFAQActive ? 'true' : 'false' }}" aria-controls="sidebarFAQs">
                        <i class="fa-solid fa-question-circle"></i>
                        <span data-key="t-faqs">FAQs</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isFAQActive ? 'show' : '' }}" id="sidebarFAQs"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ route('faqs.create') }}" 
                                    class="nav-link {{ request()->is('admin/faqs/create') ? 'active' : '' }}" 
                                    data-key="t-create-faq">
                                    Create FAQ
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('faqs.index') }}" 
                                    class="nav-link {{ (request()->is('admin/faqs') && !request()->is('admin/faqs/create')) || request()->is('admin/faqs/*/edit') || (request()->is('admin/faqs/*') && !request()->is('admin/faqs/create')) ? 'active' : '' }}" 
                                    data-key="t-faq-list">
                                    FAQ List
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                @php
                    $isCategoryActive =
                        request()->is('admin/category') ||
                        request()->is('admin/get_child_category') ||
                        request()->is('admin/get_grandchild_category') ||
                        request()->is('admin/assemble-disassemble-categories') ||
                        request()->is('admin/assemble-disassemble-categories/*') ||
                        request()->is('admin/storage-items') ||
                        request()->is('admin/storage-items/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarCategories" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isCategoryActive ? 'true' : 'false' }}" aria-controls="sidebarCategories">
                        <i class="fa fa-tags"></i>
                        <span data-key="t-categories">Categories</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isCategoryActive ? 'show' : '' }}" id="sidebarCategories"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ url('/admin/category') }}"
                                    class="nav-link {{ request()->is('admin/category') ? 'active' : '' }}"
                                    data-key="t-main-category">
                                    Main Category
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ url('/admin/get_child_category') }}"
                                    class="nav-link {{ request()->is('admin/get_child_category') ? 'active' : '' }}"
                                    data-key="t-child-category">
                                    Child Category
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('admin.assemble-disassemble-categories.index') }}"
                                    class="nav-link {{ request()->is('admin/assemble-disassemble-categories') || request()->is('admin/assemble-disassemble-categories/*') ? 'active' : '' }}"
                                    data-key="t-assemble-disassemble">
                                    Assembly Settings
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('admin.storage-items.index') }}"
                                   class="nav-link {{ request()->is('admin/storage-items') || request()->is('admin/storage-items/*') ? 'active' : '' }}"
                                   data-key="t-storage-items">
                                    Storage Items
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Job Management -->
                {{-- @php
                    $isJobActive =
                        request()->is('admin/jobs') ||
                        request()->is('admin/jobs/*') ||
                        request()->is('admin/job-applications') ||
                        request()->is('admin/job-applications/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarJobs" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isJobActive ? 'true' : 'false' }}" aria-controls="sidebarJobs">
                        <i class="ri-briefcase-line"></i>
                        <span data-key="t-jobs">Job </span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isJobActive ? 'show' : '' }}" id="sidebarJobs"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ url('/admin/jobs/create') }}"
                                    class="nav-link {{ request()->is('admin/jobs/create') ? 'active' : '' }}"
                                    data-key="t-create-job">
                                    Create Job
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ url('/admin/jobs') }}"
                                    class="nav-link {{ request()->is('admin/jobs') && !request()->is('admin/jobs/create') && !request()->is('admin/jobs/*/edit') && !request()->is('admin/jobs/*/applications') ? 'active' : '' }}"
                                    data-key="t-job-list">
                                    Job List
                        
                               </a>
                    
                               </li>
                            <li class="nav-item">
                                <a href="{{ url('/admin/job-applications') }}"
                                    class="nav-link {{ request()->is('admin/job-applications') || request()->is('admin/job-applications/*') ? 'active' : '' }}"
                                    data-key="t-job-applications">
                                    Job Applications
                                </a>
                            </li>
                        </ul>
                    </div>
                </li> --}}

                <!-- Truck Management -->
                @php
                    $isTruckActive = request()->is('admin/trucks') || request()->is('admin/trucks/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarTrucks" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isTruckActive ? 'true' : 'false' }}" aria-controls="sidebarTrucks">
                        <i class="fas fa-truck"></i>
                        <span data-key="t-trucks">Truck </span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isTruckActive ? 'show' : '' }}" id="sidebarTrucks"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ url('/admin/trucks/create') }}"
                                    class="nav-link {{ request()->is('admin/trucks/create') ? 'active' : '' }}"
                                    data-key="t-create-truck">
                                    Create Truck
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ url('/admin/trucks') }}"
                                    class="nav-link {{ request()->is('admin/trucks') && !request()->is('admin/trucks/create') && !request()->is('admin/trucks/*/edit') ? 'active' : '' }}"
                                    data-key="t-truck-list">
                                    Truck List
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Quotes & Orders Management -->
                @php
                    $isQuoteActive = request()->is('admin/quotes') || request()->is('admin/quotes/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarQuotes" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isQuoteActive ? 'true' : 'false' }}" aria-controls="sidebarQuotes">
                        <i class="fa-solid fa-file-invoice"></i>
                        <span data-key="t-quotes">Quotes/Orders</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isQuoteActive ? 'show' : '' }}" id="sidebarQuotes"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ route('admin.quotes.index') }}"
                                    class="nav-link {{ request()->is('admin/quotes') && !request()->is('admin/quotes/*/edit') ? 'active' : '' }}"
                                    data-key="t-quotes-list">
                                    All Quotes/Orders
                                </a>
                            </li>
                           
                        </ul>
                    </div>
                </li>

             

                <!-- Contact Us Management -->
                @php
                    $isContactUsActive = request()->is('admin/contact-us') || request()->is('admin/contact-us/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarContactUs" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isContactUsActive ? 'true' : 'false' }}" aria-controls="sidebarContactUs">
                        <i class="fa-solid fa-envelope"></i>
                        <span data-key="t-contact-us">Contact Us</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isContactUsActive ? 'show' : '' }}" id="sidebarContactUs"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ route('admin.contact-us.index') }}"
                                    class="nav-link {{ request()->is('admin/contact-us') ? 'active' : '' }}"
                                    data-key="t-contact-us-list">
                                    Contact Messages
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Testimonials Management -->
                @php
                    $isTestimonialActive = request()->is('admin/testimonials') || request()->is('admin/testimonials/*');
                @endphp

                <li class="nav-item">
                    <a class="nav-link menu-link" href="#sidebarTestimonials" data-bs-toggle="collapse" role="button"
                        aria-expanded="{{ $isTestimonialActive ? 'true' : 'false' }}" aria-controls="sidebarTestimonials">
                        <i class="fa-solid fa-star"></i>
                        <span data-key="t-testimonials">Testimonials</span>
                    </a>

                    <div class="collapse menu-dropdown {{ $isTestimonialActive ? 'show' : '' }}" id="sidebarTestimonials"
                        data-bs-parent="#navbar-nav">
                        <ul class="nav nav-sm flex-column">
                            <li class="nav-item">
                                <a href="{{ route('admin.testimonials.index') }}"
                                    class="nav-link {{ request()->is('admin/testimonials') && !request()->is('admin/testimonials/*') ? 'active' : '' }}"
                                    data-key="t-testimonials-list">
                                    All Testimonials
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('admin.testimonials.create') }}"
                                    class="nav-link {{ request()->is('admin/testimonials/create') ? 'active' : '' }}"
                                    data-key="t-create-testimonial">
                                    Create Testimonial
                                </a>
                            </li>
                        </ul>
                    </div>
                </li>

                <!-- Settings -->
                <li class="nav-item">
                    <a href="{{ url('/admin/general-settings') }}"
                        class="nav-link menu-link {{ request()->is('admin/general-settings*') ? 'active' : '' }}">
                        <i class="fa fa-gear"></i>
                        <span data-key="t-settings">Settings</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <div class="sidebar-background"></div>
</div>
