@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Job Applications') }} - {{ $job->title }}</h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin/jobs') }}" class="link-primary text-decoration-none">
                                Jobs
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Applications
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ url('/admin/jobs') }}'"
                    class="btn btn-primary">
                    <i class="fa-solid fa-briefcase me-1"></i>Back to Jobs</button>
                <button type="button" onclick="window.location = '{{ url('/admin/job-applications') }}'"
                    class="btn btn-secondary">
                    <i class="fa-solid fa-list me-1"></i> All Applications
                </button>
            </div>
        </div>
    </div>

    <!-- Job Info Card -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Job Information</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <h6 class="fw-semibold">{{ $job->title }}</h6>
                    <p class="text-muted mb-2">{{ $job->description }}</p>
                    <div class="d-flex gap-3">
                        <span class="badge bg-info-subtle text-info px-2 py-1">{{ ucfirst($job->user_type) }}</span>
                        <span class="badge bg-secondary-subtle text-secondary px-2 py-1">{{ ucfirst(str_replace('_', ' ', $job->employment_type)) }}</span>
                        <span class="text-muted"><i class="fa-solid fa-map-marker-alt me-1"></i>{{ $job->location }}</span>
                    </div>
                </div>
                <div class="col-md-4 text-end">
                    <div class="text-muted">
                        <div>Valid: {{ $job->valid_from->format('M d, Y') }} - {{ $job->valid_until->format('M d, Y') }}</div>
                        <div>Applications: <span class="fw-semibold">{{ $applications->count() }}</span></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="card-title mb-0">Filter Applications</h5>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.jobs.applications', $job->id) }}" id="filterForm">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Keyword</label>
                        <input type="text" class="form-control" name="keyword" value="{{ request('keyword') }}" placeholder="Search name, email...">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status">
                            <option value="">All Status</option>
                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="reviewed" {{ request('status') == 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                            <option value="shortlisted" {{ request('status') == 'shortlisted' ? 'selected' : '' }}>Shortlisted</option>
                            <option value="interviewed" {{ request('status') == 'interviewed' ? 'selected' : '' }}>Interviewed</option>
                            <option value="accepted" {{ request('status') == 'accepted' ? 'selected' : '' }}>Accepted</option>
                            <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Date Filter</label>
                        <select class="form-select" name="date_filter">
                            <option value="">All Time</option>
                            <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today</option>
                            <option value="yesterday" {{ request('date_filter') == 'yesterday' ? 'selected' : '' }}>Yesterday</option>
                            <option value="7days" {{ request('date_filter') == '7days' ? 'selected' : '' }}>Last 7 Days</option>
                            <option value="30days" {{ request('date_filter') == '30days' ? 'selected' : '' }}>Last 30 Days</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-flex gap-1">
                            <button type="submit" class="btn btn-primary">
                                <i class="fa-solid fa-search"></i>
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="clearFilters()">
                                <i class="fa-solid fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h5 class="card-title mb-0">Applications Table</h5>
            <div class="text-muted">
                Total Applications: {{ $applications->count() }}
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless">
                    <thead>
                        <tr>
                            <th>Applicant</th>
                            <th>Contact Info</th>
                            <th>Status</th>
                            <th>Applied Date</th>
                            <th>CV File</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($applications as $application)
                            <tr class="align-middle">
                                <td>
                                    <div class="fw-semibold">{{ $application->full_name }}</div>
                                    <small class="text-muted">{{ Str::limit($application->cover_letter, 50) }}</small>
                                </td>
                                <td>
                                    <div><i class="fa-solid fa-envelope me-1"></i>{{ $application->email }}</div>
                                    @if($application->phone)
                                        <div><i class="fa-solid fa-phone me-1"></i>{{ $application->phone }}</div>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $statusColors = [
                                            'pending' => 'warning',
                                            'reviewed' => 'info',
                                            'shortlisted' => 'primary',
                                            'interviewed' => 'secondary',
                                            'accepted' => 'success',
                                            'rejected' => 'danger'
                                        ];
                                        $color = $statusColors[$application->status] ?? 'secondary';
                                    @endphp
                                    <span class="badge bg-{{ $color }}-subtle text-{{ $color }} px-3 py-2">
                                        {{ ucfirst($application->status) }}
                                    </span>
                                </td>
                                <td>{{ $application->created_at->format('M d, Y H:i') }}</td>
                                <td>
                                    @if($application->cv_file)
                                        <a href="{{ asset('job_applications/' . $application->cv_file) }}" 
                                           download="{{ $application->cv_file }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fa-solid fa-download me-1"></i>Download
                                        </a>
                                    @else
                                        <span class="text-muted">No CV</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm"
                                            type="button" data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <button class="dropdown-item" onclick="viewApplication({{ $application->id }})">
                                                    <i class="bi bi-eye me-2"></i> View Details
                                                </button>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'pending', this)">
                                                    <i class="bi bi-clock me-2"></i> Mark as Pending
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'reviewed', this)">
                                                    <i class="bi bi-check-circle me-2"></i> Mark as Reviewed
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'shortlisted', this)">
                                                    <i class="bi bi-star me-2"></i> Shortlist
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'interviewed', this)">
                                                    <i class="bi bi-person-check me-2"></i> Mark as Interviewed
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-success" onclick="updateApplicationStatus({{ $application->id }}, 'accepted', this)">
                                                    <i class="bi bi-check-circle-fill me-2"></i> Accept
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-danger" onclick="updateApplicationStatus({{ $application->id }}, 'rejected', this)">
                                                    <i class="bi bi-x-circle me-2"></i> Reject
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Applicant</th>
                            <th>Contact Info</th>
                            <th>Status</th>
                            <th>Applied Date</th>
                            <th>CV File</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Application View Modal -->
<div class="modal fade" id="applicationViewModal" tabindex="-1" aria-labelledby="applicationViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="applicationViewModalLabel">Application Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="applicationViewContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Status Update Modal -->
<div class="modal fade" id="statusUpdateModal" tabindex="-1" aria-labelledby="statusUpdateModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="statusUpdateModalLabel">Update Application Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="statusUpdateForm">
                    <input type="hidden" id="applicationId" name="application_id">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status" id="statusSelect" required>
                            <option value="pending">Pending</option>
                            <option value="reviewed">Reviewed</option>
                            <option value="shortlisted">Shortlisted</option>
                            <option value="interviewed">Interviewed</option>
                            <option value="accepted">Accepted</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notes (Optional)</label>
                        <textarea class="form-control" name="notes" rows="3" placeholder="Add any notes about this application..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="submitStatusUpdate()">Update Status</button>
            </div>
        </div>
    </div>
</div>

<script>
    // Clear filters function
    function clearFilters() {
        document.getElementById('filterForm').reset();
        window.location.href = "{{ route('admin.jobs.applications', $job->id) }}";
    }

    // View application function
    function viewApplication(applicationId) {
        $.ajax({
            url: "{{ route('admin.job_applications.show') }}",
            type: "GET",
            data: { id: applicationId },
            success: function(response) {
                $('#applicationViewContent').html(response);
                $('#applicationViewModal').modal('show');
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to load application details'
                });
            }
        });
    }

    // Update application status function
    function updateApplicationStatus(applicationId, status, element) {
        $('#applicationId').val(applicationId);
        $('#statusSelect').val(status);
        $('#statusUpdateModal').modal('show');
    }

    // Submit status update
    function submitStatusUpdate() {
        const formData = $('#statusUpdateForm').serialize();
        
        Swal.fire({
            title: 'Please wait...',
            text: 'Updating application status',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: "{{ url('/admin/job-applications') }}/" + $('#applicationId').val() + "/update-status",
            type: "POST",
            data: formData,
            success: function(response) {
                Swal.close();
                
                if (response.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Status Updated',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to update status'
                    });
                }
            },
            error: function(xhr) {
                Swal.close();
                
                let errorMessage = 'Something went wrong';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage
                });
            }
        });
    }
</script>

