@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
    $isEdit = isset($job) && $job->exists;
    $pageTitle = $isEdit ? 'Edit Job' : 'Create Job';
    $formAction = $isEdit ? route('admin.jobs.update', $job->id) : route('admin.jobs.store');
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __($pageTitle) }}</h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin/jobs') }}" class="link-primary text-decoration-none">
                                Jobs
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ $isEdit ? 'Edit' : 'Create' }}
                        </li>
                    </ol>
                </nav>
            </div>
            
            <div class="d-flex align-items-center job-list-btn">
                <button type="button" onclick="window.location = '{{ url('/admin/jobs') }}'"
                    class="btn btn-primary global-list-btn">
                    <i class="fa-solid fa-list-ul me-1"></i>Job List
                </button>
            </div>
        </div>
    </div>

    <div class="col-md-12 col-lg-12">
        <div class="fullfilled-request my-2"></div>
        <div class="card mg-b-30">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-header-title tx-13 mb-0">{{ $pageTitle }}</h6>
                    </div>
                    <div class="text-right">
                        <div class="d-flex">
                            <a href="" class=""><i class="ti-reload"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <form id="job_form">
                    @csrf
                    @if($isEdit)
                        @method('PUT')
                        <input type="hidden" name="job_id" value="{{ $job->id }}">
                    @endif
                    
                    <div class="form-layout form-layout-1">
                        <h4>Job Information</h4>
                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Job Title: <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="title" id="title"
                                        placeholder="Enter job title" required autocomplete="off" 
                                        value="{{ $isEdit ? $job->title : old('title') }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Permalink: <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="permalink" id="permalink"
                                        placeholder="Auto-generated from title" required autocomplete="off" 
                                        value="{{ $isEdit ? $job->permalink : old('permalink') }}">
                                    <div class="permalink_error mt-1"></div>
                                    <input type="hidden" name="permalink_status" class="permalink_status" value="">
                                </div>
                            </div>
                        </div>

                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Location: <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="location"
                                        placeholder="Enter job location" required
                                        value="{{ $isEdit ? $job->location : old('location') }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <!-- Empty column for layout balance -->
                            </div>
                        </div>

                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">User Type: <span class="tx-danger">*</span></label>
                                    <select class="form-control" name="user_type" required>
                                        <option value="">Select User Type</option>
                                        <option value="driver" {{ ($isEdit && $job->user_type == 'driver') || old('user_type') == 'driver' ? 'selected' : '' }}>Driver</option>
                                        <option value="mover" {{ ($isEdit && $job->user_type == 'mover') || old('user_type') == 'mover' ? 'selected' : '' }}>Mover</option>
                                        <option value="supervisor" {{ ($isEdit && $job->user_type == 'supervisor') || old('user_type') == 'supervisor' ? 'selected' : '' }}>Supervisor</option>
                                        <option value="manager" {{ ($isEdit && $job->user_type == 'manager') || old('user_type') == 'manager' ? 'selected' : '' }}>Manager</option>
                                        <option value="admin" {{ ($isEdit && $job->user_type == 'admin') || old('user_type') == 'admin' ? 'selected' : '' }}>Admin</option>
                                        <option value="other" {{ ($isEdit && $job->user_type == 'other') || old('user_type') == 'other' ? 'selected' : '' }}>Other</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Employment Type: <span class="tx-danger">*</span></label>
                                    <select class="form-control" name="employment_type" required>
                                        <option value="">Select Employment Type</option>
                                        <option value="full_time" {{ ($isEdit && $job->employment_type == 'full_time') || old('employment_type') == 'full_time' ? 'selected' : '' }}>Full Time</option>
                                        <option value="part_time" {{ ($isEdit && $job->employment_type == 'part_time') || old('employment_type') == 'part_time' ? 'selected' : '' }}>Part Time</option>
                                        <option value="contract" {{ ($isEdit && $job->employment_type == 'contract') || old('employment_type') == 'contract' ? 'selected' : '' }}>Contract</option>
                                        <option value="temporary" {{ ($isEdit && $job->employment_type == 'temporary') || old('employment_type') == 'temporary' ? 'selected' : '' }}>Temporary</option>
                                        <option value="internship" {{ ($isEdit && $job->employment_type == 'internship') || old('employment_type') == 'internship' ? 'selected' : '' }}>Internship</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label">Minimum Salary:</label>
                                    <input class="form-control" type="number" name="salary_min"
                                        placeholder="Enter minimum salary" min="0" step="0.01"
                                        value="{{ $isEdit ? $job->salary_min : old('salary_min') }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label">Maximum Salary:</label>
                                    <input class="form-control" type="number" name="salary_max"
                                        placeholder="Enter maximum salary" min="0" step="0.01"
                                        value="{{ $isEdit ? $job->salary_max : old('salary_max') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row mg-b-25">
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Job Description: <span class="tx-danger">*</span></label>
                                    <textarea class="form-control" name="description" rows="6" required
                                        placeholder="Enter detailed job description">{{ $isEdit ? $job->description : old('description') }}</textarea>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h4>Job Validity & Settings</h4>
                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Valid From: <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="date" name="valid_from" required
                                        value="{{ $isEdit ? $job->valid_from->format('Y-m-d') : old('valid_from', date('Y-m-d')) }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label active">Valid Until: <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="date" name="valid_until" required
                                        value="{{ $isEdit ? $job->valid_until->format('Y-m-d') : old('valid_until') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row mg-b-25">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label class="form-control-label">Sort Order:</label>
                                    <input class="form-control" type="number" name="sort_order" id="sort_order"
                                        placeholder="Auto-generated" min="0"
                                        value="{{ $isEdit ? $job->sort_order : old('sort_order', 0) }}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <div class="custom-control custom-checkbox mt-4">
                                        <input type="checkbox" class="custom-control-input" name="is_active" id="is_active" value="1"
                                            {{ ($isEdit && $job->is_active) || old('is_active', true) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">
                                            Job is Active
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-layout-footer">
                            <hr>
                            <button class="btn btn-success" type="submit">
                                <i class="fa-solid fa-save me-1"></i>{{ $isEdit ? 'Update Job' : 'Create Job' }}
                            </button>
                            <button class="btn btn-secondary" onclick="window.location = '{{ url('/admin/jobs') }}'" type="button">
                                <i class="fa-solid fa-times me-1"></i>Cancel
                            </button>
                            <div class="response_section"></div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@include('Admin.Includes.footer')

<script>
    $(document).ready(function() {
        // Set minimum date for valid_from to today
        const today = new Date().toISOString().split('T')[0];
        $('input[name="valid_from"]').attr('min', today);
        
        // Set minimum date for valid_until to valid_from + 1 day
        $('input[name="valid_from"]').on('change', function() {
            const validFrom = new Date($(this).val());
            validFrom.setDate(validFrom.getDate() + 1);
            $('input[name="valid_until"]').attr('min', validFrom.toISOString().split('T')[0]);
        });

        // Trigger change event if valid_from already has a value
        if ($('input[name="valid_from"]').val()) {
            $('input[name="valid_from"]').trigger('change');
        }

        // Load next sort order for new jobs
        @if(!$isEdit)
            loadNextSortOrder();
        @endif

        // Auto-generate permalink from title
        $('#title').on('input', function() {
            generatePermalink();
        });

        // Check permalink on input
        $('#permalink').on('input', function() {
            clearTimeout(this.checkTimeout);
            this.checkTimeout = setTimeout(checkPermalink, 500);
        });

        // Check permalink on page load if editing
        @if($isEdit)
            checkPermalink();
        @endif
    });

    function loadNextSortOrder() {
        $.ajax({
            url: "{{ route('admin.jobs.nextSortOrder') }}",
            type: "GET",
            success: function(response) {
                // Always set the next sort order as default value
                $('#sort_order').val(response.next_sort_order);
            },
            error: function() {
                $('#sort_order').val('1');
            }
        });
    }

    function generatePermalinkFromTitle(title) {
        // Remove special characters and convert to lowercase
        let permalink = title.toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '') // Remove special characters except spaces and hyphens
            .replace(/\s+/g, '-') // Replace spaces with hyphens
            .replace(/-+/g, '-') // Replace multiple hyphens with single hyphen
            .replace(/^-|-$/g, ''); // Remove leading/trailing hyphens
        
        return permalink;
    }

    function generatePermalink() {
        const title = $('#title').val();
        if (!title) {
            $('#permalink').val('');
            return;
        }

        const permalink = generatePermalinkFromTitle(title);
        $('#permalink').val(permalink);
        
        // Check permalink availability after generation
        setTimeout(checkPermalink, 100);
    }

    function checkPermalink() {
        const permalink = $('#permalink').val();

        if (!permalink) {
            $('.permalink_status').val('');
            $('.permalink_error').html('<small class="text-danger">Permalink is required.</small>');
            return;
        }

        $.ajax({
            url: '{{ route('admin.jobs.check.permalink') }}',
            method: 'POST',
            data: {
                permalink: permalink,
                @if($isEdit)
                exclude_id: {{ $job->id }},
                @endif
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            dataType: 'json',
            success: function(response) {
                if (response.available) {
                    $('.permalink_status').val('1');
                    $('.permalink_error').html('<small class="text-success">✓ ' + response.message + '</small>');
                } else {
                    $('.permalink_status').val('');
                    $('.permalink_error').html('<small class="text-danger">✗ ' + response.message + '</small>');
                }
            },
            error: function(xhr, status, error) {
                $('.permalink_status').val('');
                $('.permalink_error').html('<small class="text-danger">✗ Error checking permalink. Please try again.</small>');
            }
        });
    }

    $('#job_form').on('submit', function(e) {
        e.preventDefault();
        
        Swal.fire({
            title: 'Please wait...',
            text: 'Processing your request',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Handle checkbox value properly
        var formData = $(this).serialize();
        
        // Add is_active value based on checkbox state
        if ($('#is_active').is(':checked')) {
            formData += '&is_active=1';
        } else {
            formData += '&is_active=0';
        }
        
        var url = "{{ $formAction }}";
        var method = "{{ $isEdit ? 'PUT' : 'POST' }}";

        $.ajax({
            url: url,
            type: method,
            data: formData,
            success: function(response) {
                Swal.close();

                if (response.status === 'success' || response.message) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message || 'Job {{ $isEdit ? "updated" : "created" }} successfully.',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = "{{ url('/admin/jobs') }}";
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Something went wrong'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();

                if (xhr.status == 422) {
                    let errors = xhr.responseJSON.errors;
                    let errorList = '<ul>';
                    for (let field in errors) {
                        errorList += '<li>' + errors[field][0] + '</li>';
                    }
                    errorList += '</ul>';
                    Swal.fire({
                        icon: 'error',
                        title: 'Validation Error',
                        html: errorList
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Server Error',
                        text: 'Something went wrong. Please try again later.'
                    });
                }
            }
        });
    });
</script>
