@include('Admin.Includes.header')

<div class="page-content">
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0 small">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Header Card -->
    <div class="card shadow-sm mb-2">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">
                        <i class="fa-solid fa-file-invoice me-2"></i>
                        Quote/Order Details
                    </h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quotes.index') }}" class="link-primary text-decoration-none">
                                Quotes/Orders
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex align-items-center gap-2 mt-md-0 mt-2">
                <a href="{{ route('admin.quotes.index') }}" class="btn btn-primary">
                    <i class="bi bi-list me-1"></i>Back to List
                </a>
                @php
                    $isEditable = !($quote->deposit_payment_status === 'succeeded' || $quote->quote_type === 'order');
                @endphp
                @if($isEditable)
                    <a href="{{ route('admin.quotes.edit', $quote->id) }}" class="btn btn-primary">
                        <i class="fa-solid fa-pen me-1"></i>Edit Quote
                    </a>
                @endif
            </div>
        </div>
    </div>

    <div class="row g-2">
        <!-- Left Column (8 columns) -->
        <div class="col-md-8 col-12">
            <!-- Quote/Order Information -->
            <div class="card shadow-sm mb-2">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fa-solid fa-file-invoice me-2"></i>Quote/Order Information
                    </h6>
                </div>
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 120px;">Quote Number:</td>
                                    <td data-summary-field="quote.quote_number">{{ $quote->quote_number ?? 'N/A' }}
                                    </td>
                                </tr>
                                <tr data-summary-row="quote.order_number"
                                    class="{{ $quote->order_number ? '' : 'd-none' }}">
                                    <td class="fw-bold">Order Number:</td>
                                    <td>
                                        <span class="badge bg-success"
                                            data-summary-field="quote.order_number">{{ $quote->order_number ?? 'N/A' }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Quote Type:</td>
                                    <td>
                                        @php
                                            $typeColors = [
                                                'quote' => 'primary',
                                                'estimate' => 'info',
                                                'order' => 'success',
                                            ];
                                            $typeColor = $typeColors[$quote->quote_type] ?? 'secondary';
                                        @endphp
                                        <span class="badge bg-{{ $typeColor }}"
                                            data-summary-badge="quote.quote_type">{{ ucfirst($quote->quote_type) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Status:</td>
                                    <td>
                                        @php
                                            $statusColors = [
                                                'pending' => 'warning',
                                                'approved' => 'success',
                                                'rejected' => 'danger',
                                            ];
                                            $statusColor = $statusColors[$quote->status] ?? 'secondary';
                                        @endphp
                                        <span class="badge bg-{{ $statusColor }}"
                                            data-summary-badge="quote.status">{{ ucfirst($quote->status) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Created At:</td>
                                    <td>{{ $quote->created_at->format('j F Y H:i:s') }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6 col-12">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 120px;">Total Cost:</td>
                                    <td class="fw-bold text-primary" data-summary-field="quote.total_cost"
                                        data-format="currency">
                                        @php
                                            // If total_cost is 0, show original_total_cost from raw_data
                                            $displayTotalCost = $quote->total_cost;
                                            if ($displayTotalCost == 0 || $displayTotalCost == null) {
                                                $displayTotalCost = $quote->raw_data['original_total_cost'] ?? ($quote->raw_data['original_total_cost_before_adjustment'] ?? 0);
                                            }
                                        @endphp
                                        ${{ number_format($displayTotalCost, 2) }}
                                    </td>
                                </tr>
                                @php
                                    $jobType = $quote->job_type ?? ($quote->raw_data['job_type'] ?? null);
                                    $jobTypeColors = [
                                        'local_job' => 'primary',
                                        'interstate_job' => 'info',
                                    ];
                                    $jobTypeColor = $jobTypeColors[$jobType] ?? 'secondary';
                                @endphp
                                @if($jobType)
                                <tr>
                                    <td class="fw-bold">Job Type:</td>
                                    <td>
                                        <span class="badge bg-{{ $jobTypeColor }}" data-summary-badge="quote.job_type">
                                            {{ ucfirst(str_replace('_', ' ', $jobType)) }}
                                        </span>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <td class="fw-bold">Movers Cost:</td>
                                    <td data-summary-field="quote.movers_cost" data-format="currency">
                                        ${{ number_format($quote->movers_cost, 2) }}</td>
                                </tr>
                                @php
                                    $calloutFee = $quote->callout_fee ?? ($quote->raw_data['callout_fee'] ?? 0);
                                    $extraMovers = $quote->extra_movers ?? ($quote->raw_data['extra_movers'] ?? 0);
                                    $extraMoversCost = $quote->extra_movers_cost ?? ($quote->raw_data['extra_movers_cost'] ?? 0);
                                    $assembleDisassembleCost =
                                        $quote->raw_data['breakdown']['assemble_disassemble_cost'] ??
                                        ($quote->raw_data['assemble_disassemble_cost'] ?? 0);
                                    $storageItemsCost =
                                        $quote->raw_data['breakdown']['storage_items_cost'] ??
                                        ($quote->raw_data['storage_items_cost'] ?? 0);
                                @endphp
                                @if(($jobType === 'local_job' || $jobType === 'interstate_job') && $calloutFee > 0)
                                <tr>
                                    <td class="fw-bold">Callout Fee:</td>
                                    <td data-summary-field="quote.callout_fee" data-format="currency">
                                        ${{ number_format($calloutFee, 2) }}</td>
                                </tr>
                                @endif
                                @if($extraMovers > 0)
                                <tr>
                                    <td class="fw-bold">Extra Movers:</td>
                                    <td>
                                        {{ $extraMovers }} movers
                                        <small class="text-muted">(included in Movers Cost)</small>
                                    </td>
                                </tr>
                                @endif
                                <tr data-summary-row="quote.assemble_disassemble_cost"
                                    class="{{ $assembleDisassembleCost > 0 ? '' : 'd-none' }}">
                                    <td class="fw-bold">Assemble/Disassemble:</td>
                                    <td data-summary-field="quote.assemble_disassemble_cost" data-format="currency">
                                        ${{ number_format($assembleDisassembleCost, 2) }}</td>
                                </tr>
                                <tr data-summary-row="quote.storage_items_cost"
                                    class="{{ $storageItemsCost > 0 ? '' : 'd-none' }}">
                                    <td class="fw-bold">Storage Items:</td>
                                    <td data-summary-field="quote.storage_items_cost" data-format="currency">
                                        ${{ number_format($storageItemsCost, 2) }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @php
                        $paymentMethod = $quote->payment_method ?? ($quote->raw_data['payment_method'] ?? null);
                    @endphp
                    @if ($quote->deposit_amount || $quote->remaining_amount || $paymentMethod)
                        <hr class="my-2">
                        <h6 class="mb-2"><i class="fa-solid fa-credit-card me-2"></i>Payment Information</h6>
                        <div class="row">
                            <div class="col-6">
                                <table class="table table-sm table-borderless mb-0">
                                    @if($paymentMethod)
                                        <tr>
                                            <td class="fw-bold" style="width: 150px;">Payment Method:</td>
                                            <td>
                                                @if($paymentMethod === 'stripe')
                                                    <span class="badge bg-primary">Stripe</span>
                                                @elseif($paymentMethod === 'bank_transfer')
                                                    <span class="badge bg-info">Bank Transfer</span>
                                                @else
                                                    <span class="badge bg-secondary">{{ ucfirst(str_replace('_', ' ', $paymentMethod)) }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td class="fw-bold" style="width: 150px;">Deposit Amount:</td>
                                        <td>
                                            <span class="fw-bold text-success"
                                                data-summary-field="quote.deposit_amount"
                                                data-format="currency">${{ number_format($quote->deposit_amount ?? 0, 2) }}</span>
                                            <span
                                                class="badge ms-2 {{ $quote->deposit_payment_status === 'succeeded' ? 'bg-success' : ($quote->deposit_payment_status === 'pending' ? 'bg-warning' : ($quote->deposit_payment_status === 'failed' ? 'bg-danger' : 'bg-secondary d-none')) }}"
                                                data-summary-badge="quote.deposit_payment_status">
                                                {{ $quote->deposit_payment_status ? ucfirst($quote->deposit_payment_status) : 'Pending' }}
                                            </span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless mb-0">
                                    @if($quote->remaining_payment_status === 'succeeded' || (!$quote->remaining_amount || $quote->remaining_amount <= 0))
                                        <tr data-summary-row="quote.remaining_amount">
                                            <td class="fw-bold" style="width: 150px;">Remaining Amount:</td>
                                            <td>
                                                <span class="text-success fw-bold">Fully Paid</span>
                                            </td>
                                        </tr>
                                    @else
                                        <tr data-summary-row="quote.remaining_amount">
                                            <td class="fw-bold" style="width: 150px;">Remaining Amount:</td>
                                            <td>
                                                <span class="fw-bold text-warning"
                                                    data-summary-field="quote.remaining_amount"
                                                    data-format="currency">${{ number_format($quote->remaining_amount ?? 0, 2) }}</span>
                                                <span
                                                    class="badge ms-2 {{ $quote->remaining_payment_status === 'pending' ? 'bg-warning' : ($quote->remaining_payment_status === 'failed' ? 'bg-danger' : 'bg-secondary d-none') }}"
                                                    data-summary-badge="quote.remaining_payment_status">
                                                    {{ $quote->remaining_payment_status ? ucfirst($quote->remaining_payment_status) : 'Pending' }}
                                                </span>
                                            </td>
                                        </tr>
                                    @endif
                                    @if($paymentMethod === 'bank_transfer' && $quote->quote_payment_proof)
                                        <tr>
                                            <td class="fw-bold">Deposit Payment Proof:</td>
                                            <td>
                                                <a href="{{ asset($quote->quote_payment_proof) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-file-earmark-image me-1"></i>View Proof
                                                </a>
                                            </td>
                                        </tr>
                                    @endif
                                    @php
                                        $remainingProof = $quote->raw_data['remaining_payment_proof'] ?? null;
                                    @endphp
                                    @if($paymentMethod === 'bank_transfer' && $remainingProof)
                                        <tr>
                                            <td class="fw-bold">Remaining Payment Proof:</td>
                                            <td>
                                                <a href="{{ asset($remainingProof) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i class="bi bi-file-earmark-image me-1"></i>View Proof
                                                </a>
                                            </td>
                                        </tr>
                                    @endif
                                </table>
                            </div>
                        </div>
                    @endif

                    <hr class="my-2">
                    <h6 class="mb-2"><i class="fa-solid fa-tag me-2"></i>Apply Discount</h6>
                    @php
                        $willApplyOnRemaining = ($quote->deposit_payment_status === 'succeeded' 
                            && $quote->remaining_amount > 0);
                    @endphp
                    @if($willApplyOnRemaining)
                        <div class="alert alert-info mb-2 py-2">
                            <small>
                                <i class="fa-solid fa-info-circle me-1"></i>
                                <strong>Note:</strong> Discount will be applied on the <strong>Remaining Amount</strong> (after deposit payment), not the total cost.
                            </small>
                        </div>
                    @endif
                    <div class="card bg-light border">
                        <div class="card-body p-3">
                            <form id="discountForm">
                                @csrf
                                <div class="row g-3 align-items-end">
                                    <div class="col-md-3">
                                        <label for="discount_type" class="form-label small fw-bold mb-1">Discount Type</label>
                                        <select class="form-select form-select-sm" id="discount_type" required>
                                            <option value="percentage" {{ (isset($quote->raw_data['discount_type']) && $quote->raw_data['discount_type'] === 'percentage') ? 'selected' : '' }}>Percentage (%)</option>
                                            <option value="fixed" {{ (isset($quote->raw_data['discount_type']) && $quote->raw_data['discount_type'] === 'fixed') ? 'selected' : '' }}>Fixed Amount ($)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="discount_value" class="form-label small fw-bold mb-1">Discount Value</label>
                                        @php
                                            $discountAppliesOnRemaining = ($quote->deposit_payment_status === 'succeeded' && $quote->remaining_amount > 0);
                                            // Use original remaining amount if available, otherwise use current remaining amount
                                            $originalRemaining = $quote->raw_data['original_remaining_amount'] ?? null;
                                            $originalTotal = $quote->raw_data['original_total_cost'] ?? null;
                                            
                                            if ($discountAppliesOnRemaining) {
                                                // For remaining: use original remaining if available, otherwise calculate from original total or use current
                                                if ($originalRemaining !== null) {
                                                    $maxFixedAmount = $originalRemaining;
                                                } elseif ($originalTotal !== null) {
                                                    $maxFixedAmount = $originalTotal - ($quote->deposit_amount ?? 0);
                                                } else {
                                                    $maxFixedAmount = $quote->remaining_amount;
                                                }
                                            } else {
                                                // For total: use original total if available, otherwise use current total
                                                $maxFixedAmount = $originalTotal ?? $quote->total_cost;
                                            }
                                        @endphp
                                        <input type="number" class="form-control form-control-sm" id="discount_value" 
                                            value="{{ $quote->raw_data['discount'] ?? '' }}" 
                                            min="0" step="0.01" 
                                            @if(!isset($quote->raw_data['discount_type']) || $quote->raw_data['discount_type'] === 'percentage')
                                                max="100"
                                            @else
                                                max="{{ $maxFixedAmount }}"
                                            @endif
                                            data-max-percentage="100"
                                            data-max-fixed="{{ $maxFixedAmount }}"
                                            data-original-total="{{ $originalTotal ?? $quote->total_cost }}"
                                            data-original-remaining="{{ $originalRemaining ?? ($discountAppliesOnRemaining ? ($quote->remaining_amount ?? 0) : 0) }}"
                                            data-deposit-amount="{{ $quote->deposit_amount ?? 0 }}"
                                            required>
                                        {{-- <small class="text-muted d-block mt-1" id="discount_hint" style="font-size: 0.75rem;">
                                            @if(isset($quote->raw_data['discount_type']) && $quote->raw_data['discount_type'] === 'fixed')
                                                Enter discount amount in dollars
                                            @else
                                                Enter discount percentage (0-100)
                                            @endif
                                        </small> --}}
                                    </div>
                                    <div class="col-md-3">
                                        <button type="submit" class="btn btn-primary btn-sm w-100" id="applyDiscountBtn">
                                            <i class="fa-solid fa-check me-1"></i>Apply Discount
                                        </button>
                                    </div>
                                    <div class="col-md-2">
                                        @php
                                            $discountOnRemaining = ($quote->deposit_payment_status === 'succeeded' 
                                                && $quote->remaining_amount > 0);
                                            
                                            if ($discountOnRemaining) {
                                                // Show original remaining amount
                                                $originalAmount = $quote->raw_data['original_remaining_amount'] ?? $quote->remaining_amount;
                                                $label = 'Original Remaining:';
                                            } else {
                                                // Show original total cost
                                                $originalAmount = $quote->raw_data['original_total_cost'] ?? $quote->total_cost;
                                                $label = 'Original Total:';
                                            }
                                        @endphp
                                        <div class="text-end">
                                            <small class="text-muted d-block" style="font-size: 0.7rem;">{{ $label }}</small>
                                            <strong class="text-muted" style="font-size: 0.85rem;"><del>${{ number_format($originalAmount, 2) }}</del></strong>
                                        </div>
                                    </div>
                                </div>
                                @if(isset($quote->raw_data['discount']) || (isset($quote->raw_data['breakdown']['discount_amount']) && $quote->raw_data['breakdown']['discount_amount'] > 0))
                                    <div class="row mt-3">
                                        <div class="col-12">
                                            @php
                                                $currentDiscount = $quote->raw_data['discount'] ?? 0;
                                                $discountType = $quote->raw_data['discount_type'] ?? 'percentage';
                                                $discountAmount = $quote->raw_data['breakdown']['discount_amount'] ?? 0;
                                                $discountOnRemaining = isset($quote->raw_data['breakdown']['discount_on_remaining']) && $quote->raw_data['breakdown']['discount_on_remaining'];
                                                
                                                if($discountAmount == 0 && $currentDiscount > 0) {
                                                    // Calculate discount amount if not in breakdown
                                                    if($discountOnRemaining) {
                                                        $originalAmount = $quote->raw_data['original_remaining_amount'] ?? $quote->remaining_amount;
                                                    } else {
                                                        $originalAmount = $quote->raw_data['original_total_cost'] ?? $quote->total_cost;
                                                    }
                                                    if($discountType === 'percentage') {
                                                        $discountAmount = ($originalAmount * $currentDiscount) / 100;
                                                    } else {
                                                        $discountAmount = $currentDiscount;
                                                    }
                                                }
                                            @endphp
                                            <div class="alert alert-info mb-0 py-2">
                                                <small class="d-flex align-items-center">
                                                    <i class="fa-solid fa-info-circle me-2"></i>
                                                    <span>
                                                        <strong>Current Discount:</strong> 
                                                        @if($discountType === 'percentage')
                                                            {{ number_format($currentDiscount, 2) }}% 
                                                        @else
                                                            ${{ number_format($currentDiscount, 2) }}
                                                        @endif
                                                        @if($discountOnRemaining)
                                                            <span class="badge bg-info ms-1">On Remaining</span>
                                                        @else
                                                            <span class="badge bg-warning ms-1">On Total</span>
                                                        @endif
                                                        @if($discountAmount > 0)
                                                            (Amount: <strong class="text-danger">-${{ number_format($discountAmount, 2) }}</strong>)
                                                        @endif
                                                    </span>
                                                </small>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer & Booking Combined -->
            <div class="card shadow-sm mb-2">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fa-solid fa-user me-2"></i>Customer & Booking Information
                    </h6>
                </div>
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <strong class="small d-block mb-2">Customer Information</strong>
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 100px;">Name:</td>
                                    <td data-summary-field="booking.name">
                                        {{ $quote->booking->name ?? ($quote->user->name ?? 'N/A') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Email:</td>
                                    <td data-summary-field="booking.email">
                                        {{ $quote->booking->email ?? ($quote->user->email ?? 'N/A') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Phone:</td>
                                    <td data-summary-field="booking.phone">
                                        {{ $quote->booking->phone ?? ($quote->user->phone ?? 'N/A') }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6 col-12">
                            <strong class="small d-block mb-2 mt-md-0 mt-2">Booking Details</strong>
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 100px;">Booking ID:</td>
                                    <td>{{ $quote->booking->id ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Move Date:</td>
                                    <td data-summary-field="booking.move_date" data-format="date-display">
                                        {{ $quote->booking && $quote->booking->move_date ? $quote->booking->move_date->format('j F Y') : 'N/A' }}
                                    </td>
                                </tr>
                                {{-- <tr>
                                    <td class="fw-bold">Time:</td>
                                    <td data-summary-field="booking.time_preference">
                                        {{ ucfirst($quote->booking->time_preference ?? 'N/A') }}</td>
                                </tr> --}}
                                <tr>
                                    <td class="fw-bold">Status:</td>
                                    <td>
                                        <span
                                            class="badge {{ $quote->booking && $quote->booking->is_completed ? 'bg-success' : 'bg-warning' }}"
                                            data-summary-badge="booking.status">
                                            {{ $quote->booking && $quote->booking->is_completed ? 'Completed' : ucfirst($quote->booking->status ?? 'Pending') }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Booking Items -->
            <div class="card shadow-sm mb-2">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fa-solid fa-box me-2"></i>Booking Items
                    </h6>
                </div>
                <div class="card-body p-3 ">
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Item Name</th>
                                <th>Type</th>
                                <th>Quantity</th>
                                <th>Price</th>
                            </tr>
                        </thead>
                        <tbody data-summary-booking-items>
                            @if ($quote->booking && $quote->booking->bookingItems && $quote->booking->bookingItems->count() > 0)
                                @foreach ($quote->booking->bookingItems as $item)
                                    @php
                                        $entity = $item->entity;
                                        $isStorageItem = $item->entity_type === \App\Models\StorageItem::class;
                                        
                                        // Determine type label based on assemble/disassemble type
                                        if ($item->is_assemble_disassemble) {
                                            switch ($item->assemble_disassemble_type) {
                                                case 'assemble':
                                                    $typeLabel = 'Assemble';
                                                    break;
                                                case 'disassemble':
                                                    $typeLabel = 'Disassemble';
                                                    break;
                                                case 'both':
                                                    $typeLabel = 'Both';
                                                    break;
                                                default:
                                                    $typeLabel = 'Assemble/Disassemble';
                                            }
                                        } else {
                                            $typeLabel = $isStorageItem ? 'Storage' : 'Regular';
                                        }
                                        
                                        $typeClass = $item->is_assemble_disassemble
                                            ? 'bg-info'
                                            : ($isStorageItem ? 'bg-secondary' : 'bg-primary');
                                        $priceDisplay = null;
                                        if ($isStorageItem && $entity) {
                                            $unitPrice = (float) ($entity->price ?? 0);
                                            $totalPrice = $unitPrice * $item->quantity;
                                            $priceDisplay = $totalPrice;
                                        } elseif ($item->is_assemble_disassemble && $entity) {
                                            $unitPrice = 0;
                                            switch ($item->assemble_disassemble_type) {
                                                case 'assemble':
                                                    $unitPrice = (float) ($entity->assemble_price ?? 0);
                                                    break;
                                                case 'disassemble':
                                                    $unitPrice = (float) ($entity->disassemble_price ?? 0);
                                                    break;
                                                case 'both':
                                                    $unitPrice = (float) ($entity->both_price ?? 0);
                                                    break;
                                            }
                                            $totalPrice = $unitPrice * $item->quantity;
                                            $priceDisplay = $totalPrice;
                                        }
                                    @endphp
                                    <tr>
                                        <td>{{ $entity->name ?? ($entity->title ?? 'N/A') }}</td>
                                        <td>
                                            <span class="badge {{ $typeClass }}">{{ $typeLabel }}</span>
                                        </td>
                                        <td>{{ $item->quantity }}</td>
                                        <td>
                                            @if (!is_null($priceDisplay))
                                                ${{ number_format($priceDisplay, 2) }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr class="text-center text-muted">
                                    <td colspan="4">No booking items available.</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Property Information -->
            @if ($quote->booking)
                <div class="card shadow-sm mb-2">
                    <div class="card-header">
                        <h6 class="mb-0">
                            <i class="fa-solid fa-map-marker-alt me-2"></i>Property Information
                        </h6>
                    </div>
                    <div class="card-body p-3">
                        <div class="row">
                            <!-- Pickup Property -->
                            @if ($quote->booking->pickUpProperty)
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-2"><i class="fa-solid fa-arrow-up me-2"></i> Pickup Location</h6>
                                    <table class="table table-sm table-borderless mb-2">
                                        <tr>
                                            <td class="fw-bold" style="width: 80px;">Location:</td>
                                            <td class="small" data-summary-field="pickup.location">
                                                {{ $quote->booking->pickUpProperty->location ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-bold">Type:</td>
                                            <td class="small" data-summary-field="pickup.property_category">
                                                {{ ucfirst(str_replace('_', ' ', optional($quote->booking->pickUpProperty->propertyDetails)->property_category ?? 'N/A')) }}
                                            </td>
                                        </tr>
                                    </table>

                                    @if ($quote->booking->pickUpProperty->propertyDetails)
                                        @php
                                            $pickupDetails = $quote->booking->pickUpProperty->propertyDetails;
                                        @endphp
                                        <div class="accordion" id="pickupAccordion">
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#pickupAccess">
                                                        Access & Stairs
                                                    </button>
                                                </h2>
                                                <div id="pickupAccess" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Flights:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.flights_of_stairs">
                                                                    {{ str_replace('_', ' ', $pickupDetails->flights_of_stairs ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Access:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.access_required">
                                                                    {{ str_replace('_', ' ', $pickupDetails->access_required ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#pickupLevels">
                                                        House Levels
                                                    </button>
                                                </h2>
                                                <div id="pickupLevels" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Internal:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.internal_levels">
                                                                    {{ str_replace('_', ' ', $pickupDetails->internal_levels ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Levels:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.levels_in_house">
                                                                    {{ str_replace('_', ' ', $pickupDetails->levels_in_house ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#pickupParking">
                                                        Parking
                                                    </button>
                                                </h2>
                                                <div id="pickupParking" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Truck:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.truck_parking">
                                                                    {{ str_replace('_', ' ', $pickupDetails->truck_parking ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Walk Distance:</td>
                                                                <td class="small"
                                                                    data-summary-field="pickup.walk_distance">
                                                                    {{ str_replace('_', ' ', $pickupDetails->walk_distance ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            @if ($pickupDetails->storage_name || $pickupDetails->storage_units)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header">
                                                        <button class="accordion-button py-1" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#pickupStorage">
                                                            Storage Information
                                                        </button>
                                                    </h2>
                                                    <div id="pickupStorage" class="accordion-collapse collapse show">
                                                        <div class="accordion-body p-2">
                                                            <table class="table table-sm table-borderless mb-0">
                                                                <tr>
                                                                    <td class="fw-bold small">Name:</td>
                                                                    <td class="small"
                                                                        data-summary-field="pickup.storage_name">
                                                                        {{ $pickupDetails->storage_name ?? 'N/A' }}
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="fw-bold small">Units:</td>
                                                                    <td class="small"
                                                                        data-summary-field="pickup.storage_units">
                                                                        {{ $pickupDetails->storage_units ?? 'N/A' }}
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @if ($pickupDetails->comments)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header">
                                                        <button class="accordion-button py-1" type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#pickupComments">
                                                            Comments
                                                        </button>
                                                    </h2>
                                                    <div id="pickupComments" class="accordion-collapse collapse show">
                                                        <div class="accordion-body p-2">
                                                            <p class="text-muted mb-0 small"
                                                                data-summary-field="pickup.comments">
                                                                {{ $pickupDetails->comments ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            @endif

                            <!-- Dropoff Property -->
                            @if ($quote->booking->dropOffProperty)
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-2 mt-md-0 mt-4"><i class="fa-solid fa-arrow-down me-2"></i> Dropoff Location</h6>
                                    <table class="table table-sm table-borderless mb-2">
                                        <tr>
                                            <td class="fw-bold" style="width: 80px;">Location:</td>
                                            <td class="small" data-summary-field="dropoff.location">
                                                {{ $quote->booking->dropOffProperty->location ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <td class="fw-bold">Type:</td>
                                            <td class="small" data-summary-field="dropoff.property_category">
                                                {{ ucfirst(str_replace('_', ' ', optional($quote->booking->dropOffProperty->propertyDetails)->property_category ?? 'N/A')) }}
                                            </td>
                                        </tr>
                                    </table>

                                    @if ($quote->booking->dropOffProperty->propertyDetails)
                                        @php
                                            $dropoffDetails = $quote->booking->dropOffProperty->propertyDetails;
                                        @endphp
                                        <div class="accordion" id="dropoffAccordion">
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#dropoffAccess">
                                                        Access & Stairs
                                                    </button>
                                                </h2>
                                                <div id="dropoffAccess" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Flights:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.flights_of_stairs">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->flights_of_stairs ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Access:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.access_required">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->access_required ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#dropoffLevels">
                                                        House Levels
                                                    </button>
                                                </h2>
                                                <div id="dropoffLevels" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Internal:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.internal_levels">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->internal_levels ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Levels:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.levels_in_house">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->levels_in_house ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="accordion-item">
                                                <h2 class="accordion-header">
                                                    <button class="accordion-button py-1" type="button"
                                                        data-bs-toggle="collapse" data-bs-target="#dropoffParking">
                                                        Parking
                                                    </button>
                                                </h2>
                                                <div id="dropoffParking" class="accordion-collapse collapse show">
                                                    <div class="accordion-body p-2">
                                                        <table class="table table-sm table-borderless mb-0">
                                                            <tr>
                                                                <td class="fw-bold small">Truck:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.truck_parking">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->truck_parking ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td class="fw-bold small">Walk Distance:</td>
                                                                <td class="small"
                                                                    data-summary-field="dropoff.walk_distance">
                                                                    {{ str_replace('_', ' ', $dropoffDetails->walk_distance ?? 'N/A') }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            @if ($dropoffDetails->storage_name || $dropoffDetails->storage_units)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header">
                                                        <button class="accordion-button py-1" type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#dropoffStorage">
                                                            Storage Information
                                                        </button>
                                                    </h2>
                                                    <div id="dropoffStorage" class="accordion-collapse collapse show">
                                                        <div class="accordion-body p-2">
                                                            <table class="table table-sm table-borderless mb-0">
                                                                <tr>
                                                                    <td class="fw-bold small">Name:</td>
                                                                    <td class="small"
                                                                        data-summary-field="dropoff.storage_name">
                                                                        {{ $dropoffDetails->storage_name ?? 'N/A' }}
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td class="fw-bold small">Units:</td>
                                                                    <td class="small"
                                                                        data-summary-field="dropoff.storage_units">
                                                                        {{ $dropoffDetails->storage_units ?? 'N/A' }}
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @if ($dropoffDetails->comments)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header">
                                                        <button class="accordion-button py-1" type="button"
                                                            data-bs-toggle="collapse"
                                                            data-bs-target="#dropoffComments">
                                                            Comments
                                                        </button>
                                                    </h2>
                                                    <div id="dropoffComments"
                                                        class="accordion-collapse collapse show">
                                                        <div class="accordion-body p-2">
                                                            <p class="text-muted mb-0 small"
                                                                data-summary-field="dropoff.comments">
                                                                {{ $dropoffDetails->comments ?? 'N/A' }}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Right Column (4 columns) -->
        <div class="col-md-4 col-12">
            <!-- Truck Information -->
            <div class="card shadow-sm mb-2">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fa-solid fa-truck me-2"></i>Truck Information
                    </h6>
                </div>
                <div class="card-body p-3">
                    <table class="table table-sm table-borderless mb-2">
                        <tr>
                            <td class="fw-bold" style="width: 100px;">Truck Name:</td>
                            <td class="small" data-summary-field="truck.truck_name">
                                {{ $quote->truck->truck_name ?? 'N/A' }}</td>
                        </tr>
                       
                        @php
                            $truckCubicCapacity =
                                $quote->raw_data['truck_cubic_capacity'] ?? ($quote->truck->cubic_capacity ?? 0);
                        @endphp
                        <tr>
                            <td class="fw-bold">Cubic Capacity:</td>
                            <td class="small" data-summary-field="quote.raw_data.truck_cubic_capacity"
                                data-format="volume">{{ number_format($truckCubicCapacity, 2) }} m³</td>
                        </tr>
                        @php
                            $generalSettings = \App\General\GeneralSettingsClass::getAllSettings();
                            $jobType = $quote->job_type ?? ($quote->raw_data['job_type'] ?? 'local_job');
                            
                            // Get movers and price based on job type
                            if ($jobType === 'interstate_job') {
                                $numberOfMovers = (int)($generalSettings['_interstate_job_number_of_movers'] ?? 2);
                                $moverPrice = (float)($generalSettings['_interstate_job_mover_per_hour_price'] ?? 110);
                                $jobTypeLabel = 'Interstate Job';
                            } else {
                                $numberOfMovers = (int)($generalSettings['_local_job_number_of_movers'] ?? 2);
                                $moverPrice = (float)($generalSettings['_local_job_mover_per_hour_price'] ?? 85);
                                $jobTypeLabel = 'Local Job';
                            }
                        @endphp
                        <tr>
                            <td class="fw-bold">Number of Movers:</td>
                            <td class="small" data-summary-field="quote.number_of_movers" data-format="number">
                                {{ $numberOfMovers }}
                                <small class="text-muted">({{ $jobTypeLabel }})</small>
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Mover Price/Hour:</td>
                            <td class="small" data-summary-field="quote.mover_per_hour_price"
                                data-format="currency">
                                ${{ number_format($moverPrice, 2) }}
                                <small class="text-muted">({{ $jobTypeLabel }})</small>
                            </td>
                        </tr>
                    </table>
                    @if (optional($quote->truck)->truck_image)
                        <img src="{{ asset($quote->truck->truck_image) }}" alt="Truck"
                            class="img-thumbnail w-100" style="max-height: 120px; object-fit: cover;">
                    @endif
                </div>
            </div>

            <!-- Calculation Details -->
            <div class="card shadow-sm mb-2">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fa-solid fa-calculator me-2"></i>Calculation Details
                    </h6>
                </div>
                <div class="card-body p-3">
                    @php
                        $jobType = $quote->job_type ?? ($quote->raw_data['job_type'] ?? null);
                        $jobTypeColors = [
                            'local_job' => 'primary',
                            'interstate_job' => 'info',
                        ];
                        $jobTypeColor = $jobTypeColors[$jobType] ?? 'secondary';
                        $timeFromCubicMeters = $quote->time_from_cubic_meters_minutes ?? ($quote->raw_data['time_from_cubic_meters_minutes'] ?? 0);
                        $timeFromCubicMetersHours = $quote->time_from_cubic_meters_hours ?? ($quote->raw_data['time_from_cubic_meters_hours'] ?? 0);
                        $timeFromCubicMetersRemainingMinutes = $quote->time_from_cubic_meters_remaining_minutes ?? ($quote->raw_data['time_from_cubic_meters_remaining_minutes'] ?? 0);
                        $calloutFeeTime = $quote->raw_data['callout_fee_time'] ?? 0;
                        $calloutFeeHours = $quote->raw_data['callout_fee_hours'] ?? 0;
                        $calloutFeeRemainingMinutes = $quote->raw_data['callout_fee_remaining_minutes'] ?? 0;
                        $calloutFeeTimeOriginal = $quote->raw_data['callout_fee_time_original'] ?? 0;
                        $calloutFeeMultiplier = $quote->raw_data['callout_fee_multiplier'] ?? 1 + ($generalSettings['_buffer_multiplier_time_percentage'] ?? 10) / 100;
                        $totalVolume = $quote->total_cubic_meters ?? 0;
                        $moverPerHourPrice = $quote->mover_per_hour_price ?? 0;
                        $numberOfMovers = $quote->number_of_movers ?? 2;
                        $extraMovers = $quote->extra_movers ?? ($quote->raw_data['extra_movers'] ?? 0);
                        
                        // Get settings for minimum rate display
                        $generalSettings = \App\General\GeneralSettingsClass::getAllSettings();
                        $localJobMovers = (int)($generalSettings['_local_job_number_of_movers'] ?? 2);
                        $localJobPrice = (float)($generalSettings['_local_job_mover_per_hour_price'] ?? 85);
                        $interstateJobMovers = (int)($generalSettings['_interstate_job_number_of_movers'] ?? 2);
                        $interstateJobPrice = (float)($generalSettings['_interstate_job_mover_per_hour_price'] ?? 110);
                        $localJobMinRate = $localJobMovers * $localJobPrice;
                        $interstateJobMinRate = $interstateJobMovers * $interstateJobPrice;
                        
                        // Calculate base mover rate (with minimum for local/interstate)
                        $baseMoverRate = $numberOfMovers * $moverPerHourPrice;
                        // Apply minimum rates from settings
                        $effectiveBaseRate = $jobType === 'interstate_job' ? max($interstateJobMinRate, $baseMoverRate) : max($localJobMinRate, $baseMoverRate);
                        // Include extra movers ($50/hour each)
                        $moverPerHourPriceTotal = $effectiveBaseRate + ($extraMovers * 50);
                    @endphp
                    
                    <div class="mb-3">
                        <div class="d-flex align-items-center mb-2">
                            <span class="badge bg-{{ $jobTypeColor }} me-2" data-summary-badge="quote.job_type">
                                {{ $jobType ? ucfirst(str_replace('_', ' ', $jobType)) : 'N/A' }}
                            </span>
                            <span class="badge bg-info" data-summary-field="quote.calculation_type">
                                {{ ucfirst(str_replace('_', ' ', $quote->calculation_type ?? 'N/A')) }}
                            </span>
                        </div>
                    </div>

                    <div class="mb-3 p-2 bg-light rounded">
                        <h6 class="small fw-bold mb-2">Volume Calculation</h6>
                        <table class="table table-sm table-borderless mb-0 small">
                            <tr>
                                <td style="width: 60%;">Total Volume:</td>
                                <td class="fw-bold" data-summary-field="quote.total_cubic_meters" data-format="volume">
                                    {{ number_format($totalVolume, 2) }} m³
                                </td>
                            </tr>
                            @if($timeFromCubicMeters > 0)
                            <tr>
                                <td>Time per m³ (load + unload):</td>
                                <td>14 minutes</td>
                            </tr>
                            <tr>
                                <td>Total Time Required:</td>
                                <td class="fw-bold">
                                    {{ $timeFromCubicMetersHours }}h {{ $timeFromCubicMetersRemainingMinutes }}m
                                    <small class="text-muted">({{ number_format($timeFromCubicMeters, 2) }} min)</small>
                                </td>
                            </tr>
                            <tr>
                                <td>Calculation:</td>
                                <td class="text-muted small">
                                    {{ number_format($totalVolume, 2) }} m³ — 14 min = {{ number_format($timeFromCubicMeters, 2) }} min
                                </td>
                            </tr>
                            @endif
                        </table>
                    </div>

                    @if(($jobType === 'local_job' || $jobType === 'interstate_job') && $calloutFeeTime > 0)
                    <div class="mb-3 p-2 bg-light rounded">
                        <h6 class="small fw-bold mb-2">Callout Fee Calculation</h6>
                        <table class="table table-sm table-borderless mb-0 small">
                            @if($calloutFeeTimeOriginal > 0 )
                            @if($jobType === 'local_job')
                            <tr>
                                <td style="width: 60%;">Base to Pickup + Dropoff to Base:</td>
                                <td class="fw-bold">{{ number_format($calloutFeeTimeOriginal, 2) }} minutes</td>
                            </tr>
                            @endif
                            @if($jobType === 'interstate_job')
                            <tr>
                                <td style="width: 60%;">Base to Pickup + Dropoff to Base + Pickup to Dropoff:</td>
                                <td class="fw-bold">{{ number_format($calloutFeeTimeOriginal, 2) }} minutes</td>
                            </tr>
                            @endif
                            <tr>
                                <td>Multiplier ({{ $generalSettings['_buffer_multiplier_time_percentage'] ?? 10 }}% buffer):</td>
                                <td>{{ number_format(($calloutFeeMultiplier - 1) * 100, 0) }}%</td>
                            </tr>
                            <tr>
                            @endif
                                <td>Total Callout Time:</td>
                                <td class="fw-bold">
                                    {{ $calloutFeeHours }}h {{ $calloutFeeRemainingMinutes }}m
                                    <small class="text-muted">({{ number_format($calloutFeeTime, 2) }} min)</small>
                                </td>
                            </tr>
                            @if($calloutFeeTimeOriginal > 0)
                            <tr>
                                <td>Calculation:</td>
                                <td class="text-muted small">
                                    {{ number_format($calloutFeeTimeOriginal, 2) }} min — {{ number_format($calloutFeeMultiplier, 2) }} = {{ number_format($calloutFeeTime, 2) }} min
                                </td>
                            </tr>
                            @endif
                        </table>
                    </div>
                    @endif

                    <div class="mb-3 p-2 bg-light rounded">
                        <h6 class="small fw-bold mb-2">Movers & Pricing</h6>
                        <table class="table table-sm table-borderless mb-0 small">
                            @php
                                $totalMovers = $numberOfMovers + $extraMovers;
                                $extraMoverRate = $extraMovers * 50;
                            @endphp
                            <tr>
                                <td style="width: 60%;">Base Movers:</td>
                                <td class="fw-bold" data-summary-field="quote.number_of_movers" data-format="number">
                                    {{ $numberOfMovers }} movers
                                </td>
                            </tr>
                            @if($extraMovers > 0)
                            <tr>
                                <td>Extra Movers:</td>
                                <td class="fw-bold">
                                    {{ $extraMovers }} movers
                                    <small class="text-muted">(@ $50/hour each)</small>
                                </td>
                            </tr>
                            <tr>
                                <td>Total Movers:</td>
                                <td class="fw-bold">
                                    {{ $totalMovers }} movers
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td>Base Mover Rate/Hour:</td>
                                <td data-summary-field="quote.mover_per_hour_price" data-format="currency">
                                    ${{ number_format($effectiveBaseRate, 2) }}
                                    <small class="text-muted">
                                        @if($effectiveBaseRate > $baseMoverRate)
                                            (min: ${{ number_format($jobType === 'interstate_job' ? $interstateJobMinRate : $localJobMinRate, 2) }}/hour)
                                        @else
                                            ({{ $numberOfMovers }} — ${{ number_format($moverPerHourPrice, 2) }})
                                        @endif
                                    </small>
                                </td>
                            </tr>
                            @if($extraMovers > 0)
                            <tr>
                                <td>Extra Mover Rate/Hour:</td>
                                <td>
                                    ${{ number_format($extraMoverRate, 2) }}
                                    <small class="text-muted">({{ $extraMovers }} — $50.00)</small>
                                </td>
                            </tr>
                            @endif
                            <tr>
                                <td>Total Mover Rate/Hour:</td>
                                <td class="fw-bold">
                                    ${{ number_format($moverPerHourPriceTotal, 2) }}
                                    @if($extraMovers > 0)
                                        <small class="text-muted">(${{ number_format($effectiveBaseRate, 2) }} + ${{ number_format($extraMoverRate, 2) }} = ${{ number_format($moverPerHourPriceTotal, 2) }})</small>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>

                    <hr class="my-3">
                    <h6 class="mb-2"><i class="fa-solid fa-list me-2"></i>Cost Breakdown</h6>
                    <table class="table table-sm table-bordered mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="small" style="width: 60%;">Item</th>
                                <th class="small">Amount</th>
                            </tr>
                        </thead>
                        <tbody data-summary-breakdown>
                            @if ($quote->raw_data && isset($quote->raw_data['breakdown']))
                                @php
                                    $moversCost = $quote->raw_data['breakdown']['movers_cost'] ?? 0;
                                    $calloutFee = $quote->raw_data['breakdown']['callout_fee'] ?? 0;
                                    $timeFromCubicMetersInHours = $timeFromCubicMeters > 0 ? ($timeFromCubicMetersHours + ($timeFromCubicMetersRemainingMinutes / 60)) : 0;
                                    $calloutFeeInHours = $calloutFeeTime > 0 ? ($calloutFeeHours + ($calloutFeeRemainingMinutes / 60)) : 0;
                                @endphp
                                
                                @if($moversCost > 0 && $timeFromCubicMeters > 0)
                                <tr data-breakdown-row="movers_cost">
                                    <td class="small">
                                        <strong>Movers Cost:</strong><br>
                                        <small class="text-muted">
                                            {{ $timeFromCubicMetersHours }}h {{ $timeFromCubicMetersRemainingMinutes }}m — ${{ number_format($moverPerHourPriceTotal, 2) }}/hour
                                        </small>
                                    </td>
                                    <td class="small fw-bold">${{ number_format($moversCost, 2) }}</td>
                                </tr>
                                @endif
                                
                                @if($calloutFee > 0 && $calloutFeeTime > 0)
                                <tr data-breakdown-row="callout_fee">
                                    <td class="small">
                                        <strong>Callout Fee:</strong><br>
                                        <small class="text-muted">
                                            {{ $calloutFeeHours }}h {{ $calloutFeeRemainingMinutes }}m — ${{ number_format($moverPerHourPriceTotal, 2) }}/hour
                                        </small>
                                    </td>
                                    <td class="small fw-bold">${{ number_format($calloutFee, 2) }}</td>
                                </tr>
                                @endif
                                
                                @foreach ($quote->raw_data['breakdown'] as $key => $value)
                                    @if($key !== 'movers_cost' && $key !== 'callout_fee' && $key !== 'extra_movers' && $key !== 'extra_movers_cost' && $key !== 'minimum_order' && $key !== 'minimum_order_cost' && $key !== 'discount_percent' && $key !== 'discount_on_remaining')
                                        @if($key === 'discount_amount')
                                            @php
                                                $discountType = $quote->raw_data['discount_type'] ?? 'percentage';
                                                $discountValue = $quote->raw_data['discount'] ?? 0;
                                                $discountOnRemaining = isset($quote->raw_data['breakdown']['discount_on_remaining']) && $quote->raw_data['breakdown']['discount_on_remaining'];
                                            @endphp
                                            <tr data-breakdown-row="discount">
                                                <td class="small">
                                                    <strong>Discount 
                                                        @if($discountType === 'percentage')
                                                            ({{ number_format($discountValue, 2) }}%)
                                                        @else
                                                            (Fixed: ${{ number_format($discountValue, 2) }})
                                                        @endif
                                                        @if($discountOnRemaining)
                                                            <span class="badge bg-info ms-1">On Remaining</span>
                                                        @else
                                                            <span class="badge bg-warning ms-1">On Total</span>
                                                        @endif
                                                    :</strong>
                                                    @if($discountOnRemaining)
                                                        <br><small class="text-muted">
                                                            Applied on Remaining Amount (after deposit)
                                                        </small>
                                                    @else
                                                        <br><small class="text-muted">
                                                            Applied on Total Cost
                                                        </small>
                                                    @endif
                                                </td>
                                                <td class="small fw-bold text-danger">-${{ number_format($value, 2) }}</td>
                                            </tr>
                                        @else
                                            <tr data-breakdown-row="{{ $key }}">
                                                <td class="small">
                                                    <strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong>
                                                </td>
                                                <td class="small fw-bold">${{ number_format($value, 2) }}</td>
                                            </tr>
                                        @endif
                                    @endif
                                @endforeach
                            @else
                                <tr class="text-center text-muted">
                                    <td colspan="2">No breakdown data available.</td>
                                </tr>
                            @endif
                            @php
                                $originalTotalCost = $quote->raw_data['original_total_cost'] ?? $quote->total_cost;
                                $hasDiscount = isset($quote->raw_data['breakdown']['discount_amount']) && $quote->raw_data['breakdown']['discount_amount'] > 0;
                                $discountOnRemaining = isset($quote->raw_data['breakdown']['discount_on_remaining']) && $quote->raw_data['breakdown']['discount_on_remaining'];
                                $originalRemaining = $quote->raw_data['original_remaining_amount'] ?? null;
                            @endphp
                            
                            @if($hasDiscount)
                                @if($discountOnRemaining)
                                    {{-- Discount applied on remaining amount --}}
                                    @if($originalRemaining && $originalRemaining != $quote->remaining_amount)
                                        <tr>
                                            <td class="small"><strong>Original Remaining Amount:</strong></td>
                                            <td class="small fw-bold text-muted"><del>${{ number_format($originalRemaining, 2) }}</del></td>
                                        </tr>
                                    @endif
                                @else
                                    {{-- Discount applied on total cost --}}
                                    @if($originalTotalCost != $quote->total_cost)
                                        <tr>
                                            <td class="small"><strong>Original Total Cost:</strong></td>
                                            <td class="small fw-bold text-muted"><del>${{ number_format($originalTotalCost, 2) }}</del></td>
                                        </tr>
                                    @endif
                                @endif
                            @endif
                            
                            <tr data-summary-breakdown-total>
                                <td class="small"><strong>Total Cost:</strong></td>
                                <td class="small"><strong data-summary-field="quote.total_cost">
                                    @php
                                        // If total_cost is 0, show original_total_cost from raw_data
                                        $displayTotalCost = $quote->total_cost;
                                        if ($displayTotalCost == 0 || $displayTotalCost == null) {
                                            $displayTotalCost = $quote->raw_data['original_total_cost'] ?? ($quote->raw_data['original_total_cost_before_adjustment'] ?? 0);
                                        }
                                    @endphp
                                    ${{ number_format($displayTotalCost, 2) }}
                                </strong></td>
                            </tr>
                            
                            @if($quote->deposit_amount > 0)
                                <tr>
                                    <td class="small"><strong>Deposit Amount:</strong></td>
                                    <td class="small fw-bold text-success">-${{ number_format($quote->deposit_amount, 2) }}</td>
                                </tr>
                            @endif
                            
                            @if($hasDiscount && $discountOnRemaining)
                                {{-- Show calculation when discount is on remaining --}}
                                <tr>
                                    <td class="small"><strong>Remaining Amount (After Discount):</strong></td>
                                    <td class="small fw-bold text-warning">${{ number_format($quote->remaining_amount, 2) }}</td>
                                </tr>
                            @elseif($quote->remaining_amount > 0)
                                <tr>
                                    <td class="small"><strong>Remaining Amount:</strong></td>
                                    <td class="small fw-bold text-warning">${{ number_format($quote->remaining_amount, 2) }}</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const discountForm = document.getElementById('discountForm');
    const discountType = document.getElementById('discount_type');
    const discountValue = document.getElementById('discount_value');
    const applyDiscountBtn = document.getElementById('applyDiscountBtn');
    
    // Get max values from data attributes
    const maxPercentage = parseFloat(discountValue.getAttribute('data-max-percentage')) || 100;
    const discountAppliesOnRemaining = {{ ($quote->deposit_payment_status === 'succeeded' && $quote->remaining_amount > 0) ? 'true' : 'false' }};
    const originalTotal = parseFloat(discountValue.getAttribute('data-original-total')) || {{ $quote->total_cost }};
    const originalRemaining = parseFloat(discountValue.getAttribute('data-original-remaining')) || 0;
    const depositAmount = parseFloat(discountValue.getAttribute('data-deposit-amount')) || 0;
    const totalCost = {{ $quote->total_cost }};
    const remainingAmount = {{ $quote->remaining_amount ?? 0 }};
    
    // Calculate max fixed amount based on context
    function getMaxFixedAmount() {
        if (discountAppliesOnRemaining) {
            // Use original remaining if available, otherwise calculate from original total, otherwise use current
            if (originalRemaining && originalRemaining > 0) {
                return originalRemaining;
            } else if (originalTotal && originalTotal > 0) {
                return Math.max(0, originalTotal - depositAmount);
            } else {
                return remainingAmount;
            }
        } else {
            // Use original total if available, otherwise use current total
            return (originalTotal && originalTotal > 0) ? originalTotal : totalCost;
        }
    }

    // Update max attribute when discount type changes
    discountType.addEventListener('change', function() {
        if (this.value === 'fixed') {
            const maxAmount = getMaxFixedAmount();
            discountValue.setAttribute('max', maxAmount);
            discountValue.setAttribute('data-max-fixed', maxAmount);
        } else {
            // For percentage, set max to 100
            discountValue.setAttribute('max', maxPercentage);
        }
        // Clear any validation errors
        discountValue.setCustomValidity('');
    });

    // Validate on input
    discountValue.addEventListener('input', function() {
        const value = parseFloat(this.value);
        if (isNaN(value) || value < 0) {
            this.setCustomValidity('Please enter a valid discount value.');
            return;
        }
        
        if (discountType.value === 'percentage') {
            if (value > maxPercentage) {
                this.setCustomValidity(`Discount percentage cannot exceed ${maxPercentage}%.`);
            } else {
                this.setCustomValidity('');
            }
        } else {
            const maxAmount = getMaxFixedAmount();
            if (value > maxAmount) {
                const amountType = discountAppliesOnRemaining ? 'remaining amount' : 'total cost';
                this.setCustomValidity(`Discount amount cannot exceed the ${amountType} of $${maxAmount.toFixed(2)}.`);
            } else {
                this.setCustomValidity('');
            }
        }
    });

    // Handle form submission
    discountForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const originalText = applyDiscountBtn.innerHTML;
        applyDiscountBtn.disabled = true;
        applyDiscountBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span>Applying...';

        const discountTypeValue = discountType.value;
        const discountValueAmount = parseFloat(discountValue.value);

        // Validation
        if (isNaN(discountValueAmount) || discountValueAmount < 0) {
            alert('Please enter a valid discount value.');
            applyDiscountBtn.disabled = false;
            applyDiscountBtn.innerHTML = originalText;
            return;
        }

        if (discountTypeValue === 'percentage' && discountValueAmount > maxPercentage) {
            alert(`Discount percentage cannot exceed ${maxPercentage}%.`);
            applyDiscountBtn.disabled = false;
            applyDiscountBtn.innerHTML = originalText;
            return;
        }

        if (discountTypeValue === 'fixed') {
            const maxAmount = getMaxFixedAmount();
            if (discountValueAmount > maxAmount) {
                const amountType = discountAppliesOnRemaining ? 'remaining amount' : 'total cost';
                alert(`Discount amount cannot exceed the ${amountType} of $${maxAmount.toFixed(2)}.`);
                applyDiscountBtn.disabled = false;
                applyDiscountBtn.innerHTML = originalText;
                return;
            }
        }

        try {
            const response = await fetch('{{ route("admin.quotes.applyDiscount", $quote->id) }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                },
                body: JSON.stringify({
                    discount_type: discountTypeValue,
                    discount: discountValueAmount
                })
            });

            const data = await response.json();

            if (response.ok && (data.status === 'success' || data.message)) {
                // Show success message
                const alertDiv = document.createElement('div');
                alertDiv.className = 'alert alert-success alert-dismissible fade show';
                alertDiv.innerHTML = `
                    <strong>Success!</strong> ${data.message || 'Discount applied successfully.'}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                `;
                document.querySelector('.page-content')?.insertBefore(alertDiv, document.querySelector('.page-content').firstChild);

                // Reload page after 1.5 seconds to show updated values
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
            } else {
                throw new Error(data.message || 'Failed to apply discount.');
            }
        } catch (error) {
            console.error('Error applying discount:', error);
            
            // Show error message
            const alertDiv = document.createElement('div');
            alertDiv.className = 'alert alert-danger alert-dismissible fade show';
            alertDiv.innerHTML = `
                <strong>Error!</strong> ${error.message || 'Failed to apply discount. Please try again.'}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.querySelector('.page-content')?.insertBefore(alertDiv, document.querySelector('.page-content').firstChild);
            
            applyDiscountBtn.disabled = false;
            applyDiscountBtn.innerHTML = originalText;
        }
    });
});
</script>

@include('Admin.Includes.footer')
