@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3 services-body-card">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Services List') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Services List
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('services.create') }}" class="btn btn-success global-create-btn">
                            <i class="bi bi-plus-circle me-1"></i> Create Service
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alerts -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-xl-3 col-md-6">
                <div class="card card-height-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-sm flex-shrink-0">
                                <span class="avatar-title bg-primary-subtle text-primary rounded fs-3">
                                    <i class="bi bi-list-ul"></i>
                                </span>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <p class="text-uppercase fw-medium text-muted fs-12 mb-1">TOTAL SERVICES</p>
                                <h4 class="mb-0">{{ $services->count() }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6 pt-md-0 pt-4">
                <div class="card card-height-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-sm flex-shrink-0">
                                <span class="avatar-title bg-success-subtle text-success rounded fs-3">
                                    <i class="bi bi-check-circle"></i>
                                </span>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <p class="text-uppercase fw-medium text-muted fs-12 mb-1">PUBLISHED</p>
                                <h4 class="mb-0">{{ $services->where('active', 1)->count() }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6 blog-cards">
                <div class="card card-height-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-sm flex-shrink-0">
                                <span class="avatar-title bg-warning-subtle text-warning rounded fs-3">
                                    <i class="bi bi-pencil"></i>
                                </span>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <p class="text-uppercase fw-medium text-muted fs-12 mb-1">DRAFT</p>
                                <h4 class="mb-0">{{ $services->where('active', 0)->count() }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6 blog-cards">
                <div class="card card-height-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-sm flex-shrink-0">
                                <span class="avatar-title bg-secondary-subtle text-secondary rounded fs-3">
                                    <i class="bi bi-lock"></i>
                                </span>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <p class="text-uppercase fw-medium text-muted fs-12 mb-1">PRIVATE</p>
                                <h4 class="mb-0">{{ $services->where('active', 2)->count() }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Advanced Filters Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <i class="bi bi-funnel me-2"></i>Advanced Filters
                    </h6>
                    <button class="btn btn-sm btn-outline-primary" type="button" data-bs-toggle="collapse"
                        data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse">
                        <i class="bi bi-chevron-down"></i>
                    </button>
                </div>
            </div>
            <div class="collapse {{ request()->hasAny(['status', 'date_range', 'search']) ? 'show' : '' }}"
                id="filterCollapse">
                <div class="card-body advance-filter-body">
                    <form method="GET" action="{{ route('services.index') }}" class="row g-3">
                        <div class="col-xl-3 col-lg-4 col-md-4">
                            <label for="status_filter" class="form-label">Status</label>
                            <select class="form-select" id="status_filter" name="status">
                                <option value="">All Status</option>
                                <option value="0" {{ request('status') == '0' ? 'selected' : '' }}>Draft</option>
                                <option value="1" {{ request('status') == '1' ? 'selected' : '' }}>Published</option>
                                <option value="2" {{ request('status') == '2' ? 'selected' : '' }}>Private</option>
                            </select>
                        </div>

                        <div class="col-xl-3 col-lg-4 col-md-4">
                            <label for="date_range_filter" class="form-label">Date Range</label>
                            <select class="form-select" id="date_range_filter" name="date_range">
                                <option value="">All Time</option>
                                <option value="today" {{ request('date_range') == 'today' ? 'selected' : '' }}>Today</option>
                                <option value="week" {{ request('date_range') == 'week' ? 'selected' : '' }}>This Week</option>
                                <option value="month" {{ request('date_range') == 'month' ? 'selected' : '' }}>This Month</option>
                                <option value="year" {{ request('date_range') == 'year' ? 'selected' : '' }}>This Year</option>
                            </select>
                        </div>

                        <div class="col-xl-3 col-lg-4 col-md-4">
                            <label for="search_filter" class="form-label">Search</label>
                            <input type="text" class="form-control" id="search_filter" name="search"
                                placeholder="Search by title, description..." value="{{ request('search') }}">
                        </div>

                        <div class="col-xl-3 col-lg-4 col-md-12">
                            <div class="d-flex flex-wrap gap-2 mt-xl-4 pt-xl-1">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-search me-1"></i>Filter
                                </button>
                                <a href="{{ route('services.index') }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle me-1"></i>Clear
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Services Table -->
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <h6 class="mb-lg-0 mb-3">
                        <i class="bi bi-list-ul me-2"></i>Services Table
                    </h6>
                    <div class="d-flex gap-2 align-items-center flex-wrap">
                        <div class="d-flex align-items-center">
                            <label class="form-label me-2 mb-0">Show:</label>
                            <select class="form-select form-select-sm" style="width: 80px;">
                                <option value="10" selected>10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                            <span class="ms-2 text-muted">entries</span>
                        </div>
                        <div class="d-flex align-items-center">
                            <label class="form-label me-2 mb-0">Search:</label>
                            <input type="text" class="form-control form-control-sm" 
                                   placeholder="Search services..." 
                                   style="width: 200px;"
                                   onkeyup="searchServices(this.value)">
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                @if($services->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="5%" class="sort">#</th>
                                    <th width="15%">Cover Image</th>
                                    <th width="25%" class="sort">Title <i class="bi bi-arrow-up-down ms-1"></i></th>
                                    <th width="20%">Description</th>
                                    <th width="10%" class="sort">Status <i class="bi bi-arrow-up-down ms-1"></i></th>
                                    <th width="15%" class="sort">Created <i class="bi bi-arrow-up-down ms-1"></i></th>
                                    <th width="10%">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($services as $index => $service)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            @if($service->cover_image)
                                                <img src="{{ asset($service->cover_image) }}" 
                                                     alt="{{ $service->title }}" 
                                                     class="img-thumbnail" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-light d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="bi bi-image text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <div>
                                                <h6 class="mb-1">{{ $service->title }}</h6>
                                                <small class="text-muted">{{ $service->permalink }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="text-truncate" style="max-width: 200px;">
                                                {{ Str::limit($service->description, 100) }}
                                            </div>
                                        </td>
                                        <td class="active-status">
                                            @php
                                                $statusClass = [
                                                    0 => 'bg-warning-subtle text-warning',
                                                    1 => 'bg-success-subtle text-success',
                                                    2 => 'bg-secondary-subtle text-secondary',
                                                ];
                                                $statusText = [
                                                    0 => 'Draft',
                                                    1 => 'Published',
                                                    2 => 'Private',
                                                ];
                                            @endphp
                                            <span class="badge {{ $statusClass[$service->active] ?? 'bg-light text-muted' }}">
                                                {{ $statusText[$service->active] ?? 'Unknown' }}
                                            </span>
                                        </td>
                                        <td>
                                            <div>
                                                <small class="text-muted">{{ $service->created_at->format('M d, Y') }}</small>
                                                <br>
                                                <small class="text-muted">{{ $service->created_at->format('h:i A') }}</small>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-sm text-dark rounded shadow-sm" type="button"
                                                    data-bs-toggle="dropdown" aria-expanded="false"
                                                    style="background-color: #c2d6e7;">
                                                    &#8942;
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <li><a class="dropdown-item"
                                                            href="{{ route('services.edit', ['service' => $service->id]) }}">
                                                            <i class="bi bi-pencil-square me-2"></i>Edit</a>
                                                    </li>

                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('services.show', $service) }}">
                                                            <i class="bi bi-eye me-2"></i>View
                                                        </a>
                                                    </li>

                                                    <li><button class="dropdown-item text-danger"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#deleteConfirmModal{{ $service->id }}">
                                                            <i class="bi bi-trash me-2"></i>Delete</button>
                                                    </li>

                                                    <li>
                                                        <hr class="dropdown-divider">
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item {{ $service->active == 0 ? 'active' : '' }} cursor-pointer"
                                                            onclick="ServiceUpdateStatus({{ $service->id }}, 0, this)">
                                                            <i class="bi bi-pencil me-2"></i> Draft
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item {{ $service->active == 1 ? 'active' : '' }} cursor-pointer"
                                                            onclick="ServiceUpdateStatus({{ $service->id }}, 1, this)">
                                                            <i class="bi bi-globe me-2"></i> Published
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item {{ $service->active == 2 ? 'active' : '' }} cursor-pointer"
                                                            onclick="ServiceUpdateStatus({{ $service->id }}, 2, this)">
                                                            <i class="bi bi-lock me-2"></i> Private
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Delete Confirmation Modal -->
                                    <div class="modal fade zoomIn" id="deleteConfirmModal{{ $service->id }}"
                                        tabindex="-1" aria-labelledby="deleteConfirmModalLabel{{ $service->id }}"
                                        aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body p-md-5">
                                                    <div class="text-center">
                                                        <div class="text-danger">
                                                            <i class="bi bi-trash display-4"></i>
                                                        </div>
                                                        <div class="mt-4 fs-15">
                                                            <h4 class="mb-1">Are you sure?</h4>
                                                            <p class="text-muted mx-3 fs-16 mb-0">
                                                                Are you sure you want to delete
                                                                <strong>{{ $service->title }}</strong>?<br>
                                                                This action cannot be undone.
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light"
                                                        data-bs-dismiss="modal">Cancel</button>
                                                    <form method="POST" action="{{ route('services.destroy', $service) }}" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">Yes, Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center flex-wrap p-3 border-top">
                        <div class="mb-md-0 mb-3 services-pagination-text">
                            Showing 1 to {{ $services->count() }} of {{ $services->count() }} entries
                        </div>
                        <div class="d-flex gap-1 services-pagination">
                            <button class="btn btn-sm btn-outline-secondary" disabled>
                                <i class="bi bi-chevron-left"></i> Previous
                            </button>
                            <button class="btn btn-sm btn-primary">1</button>
                            <button class="btn btn-sm btn-outline-secondary" disabled>
                                Next <i class="bi bi-chevron-right"></i>
                            </button>
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-1 text-muted"></i>
                        <h5 class="mt-3 text-muted">No Services Found</h5>
                        <p class="text-muted">Start by creating your first service.</p>
                        <a href="{{ route('services.create') }}" class="btn btn-success">
                            <i class="bi bi-plus-circle me-1"></i>Create Service
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>



<style>
    .avatar-xs {
        height: 2rem;
        width: 2rem;
    }

    .avatar-sm {
        height: 3rem;
        width: 3rem;
    }

    .avatar-title {
        align-items: center;
        color: #fff;
        display: flex;
        font-weight: 500;
        height: 100%;
        justify-content: center;
        width: 100%;
    }

    .card-height-100 {
        height: calc(100% - 0px);
    }

    .cursor-pointer {
        cursor: pointer;
    }

    .table th.sort {
        cursor: pointer;
        user-select: none;
        position: relative;
    }

    .table th.sort:hover {
        background-color: var(--bs-gray-100);
    }

    .table th.sort i {
        opacity: 0.5;
        transition: opacity 0.2s;
    }

    .table th.sort:hover i {
        opacity: 1;
    }

    .badge {
        font-size: 0.75em;
    }

    .dropdown-item.active {
        color: black;
    }

    @media (max-width: 768px) {
        .card-body {
            padding: 1rem 0.5rem;
        }

        .table-responsive {
            font-size: 0.875rem;
        }
    }
</style>

<script>
    // Service Status Update Function
    function ServiceUpdateStatus(serviceId, status, elementObj) {
        const statusLabels = ['Draft', 'Published', 'Private'];
        const newStatusText = statusLabels[status] || 'Unknown';

        const statusClasses = {
            0: 'bg-warning-subtle text-warning',
            1: 'bg-success-subtle text-success',
            2: 'bg-secondary-subtle text-secondary',
            3: 'bg-danger-subtle text-danger'
        };

        $.ajax({
            url: '/admin/services/' + serviceId + '/update-status',
            type: 'PUT',
            data: {
                active: status,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                // Update status badge in the table
                const $statusCell = $(elementObj).closest('tr').find('.active-status .badge');
                $statusCell.removeClass().addClass('badge ' + statusClasses[status]).text(newStatusText);

                // Show success modal with SweetAlert2
                Swal.fire({
                    icon: 'success',
                    title: 'Status Updated',
                    text: `Service status updated to ${newStatusText} successfully.`,
                    timer: 2000,
                    showConfirmButton: false,
                    timerProgressBar: true
                });
            },
            error: function(xhr) {
                const errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                
                // Show error modal with SweetAlert2
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage,
                    confirmButtonText: 'OK'
                });
            }
        });
    }

    function searchServices(searchTerm) {
        // Simple client-side search for now
        const rows = document.querySelectorAll('tbody tr');
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            if (text.includes(searchTerm.toLowerCase())) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    }
</script>
