@include('Admin.Includes.header')

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Edit Testimonial') }}: {{ $testimonial->customer_name }}</h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.testimonials.index') }}" class="link-primary text-decoration-none">
                                Testimonials
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Edit Testimonial</li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex align-items-center gap-2">
                <a href="{{ route('admin.testimonials.index') }}" class="btn btn-primary global-list-btn">
                    <i class="bi bi-list me-1"></i> Testimonial List
                </a>
            </div>
        </div>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <form id="edit_testimonial_form" method="POST" action="{{ route('admin.testimonials.update', $testimonial->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="card shadow-sm mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">Testimonial Information</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Customer Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="customer_name" value="{{ old('customer_name', $testimonial->customer_name) }}" required>
                        @error('customer_name')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Rating <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="rating" value="{{ old('rating', $testimonial->rating) }}" 
                            step="0.1" min="0" max="5" required placeholder="e.g., 4.5">
                        <small class="text-muted">Rating from 0.0 to 5.0 (e.g., 4.5)</small>
                        @error('rating')
                            <div class="text-danger small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Customer Position</label>
                        <input type="text" class="form-control" name="customer_position" value="{{ old('customer_position', $testimonial->customer_position) }}" 
                            placeholder="e.g., CEO, Manager">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Company Name</label>
                        <input type="text" class="form-control" name="company_name" value="{{ old('company_name', $testimonial->company_name) }}" 
                            placeholder="Company name">
                    </div>

                    <div class="col-md-12 mb-3">
                        <label class="form-label">Short Description</label>
                        <textarea class="form-control" name="short_description" rows="3" maxlength="500" 
                            placeholder="Brief testimonial (max 500 characters)">{{ old('short_description', $testimonial->short_description) }}</textarea>
                        <small class="text-muted">Maximum 500 characters</small>
                    </div>

                    <div class="col-md-12 mb-3">
                        <label class="form-label">Long Description</label>
                        <textarea class="form-control" name="long_description" rows="6" 
                            placeholder="Full testimonial text">{{ old('long_description', $testimonial->long_description) }}</textarea>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Customer Image</label>
                        @if($testimonial->customer_image)
                            <div class="mb-2">
                                <img src="{{ asset($testimonial->customer_image) }}" alt="Current image" 
                                    class="img-thumbnail" style="max-width: 100px; max-height: 100px;">
                                <div><small class="text-muted">Current Image</small></div>
                            </div>
                        @endif
                        <input type="file" class="form-control" name="customer_image" accept="image/*">
                        <small class="text-muted">Leave empty to keep current image. Recommended: Square image (e.g., 400x400px)</small>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <div class="form-check form-switch mt-2">
                            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                {{ old('is_active', $testimonial->is_active) ? 'checked' : '' }} value="1">
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-sm mb-4">
            <div class="card-footer">
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-success">
                        <i class="fa-solid fa-save me-1"></i>Update Testimonial
                    </button>
                    <a href="{{ route('admin.testimonials.index') }}" class="btn btn-secondary ms-2">
                        <i class="fa-solid fa-times me-1"></i>Cancel
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

@include('Admin.Includes.footer')

<script>
    $('#edit_testimonial_form').on('submit', function(e) {
        e.preventDefault();
        
        Swal.fire({
            title: 'Please wait...',
            text: 'Updating testimonial',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        var formData = new FormData(this);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-HTTP-Method-Override': 'PUT'
            },
            success: function(response) {
                Swal.close();

                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message || 'Testimonial updated successfully.',
                        timer: 2000,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = '{{ route('admin.testimonials.index') }}';
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to update testimonial.',
                        confirmButtonColor: '#7c3aed'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();

                let errorMessage = 'Something went wrong. Please try again later.';
                
                if (xhr.status == 422) {
                    // Handle Laravel validation errors
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        let errors = xhr.responseJSON.errors;
                        let errorList = '<ul style="text-align: left; margin: 10px 0;">';
                        for (let field in errors) {
                            if (errors[field] && errors[field].length > 0) {
                                let fieldName = field.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());
                                errorList += '<li style="margin: 5px 0;">' + fieldName + ': ' + errors[field][0] + '</li>';
                            }
                        }
                        errorList += '</ul>';
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            html: errorList,
                            confirmButtonColor: '#7c3aed'
                        });
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            text: errorMessage,
                            confirmButtonColor: '#7c3aed'
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            text: 'Please check your input and try again.',
                            confirmButtonColor: '#7c3aed'
                        });
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: errorMessage,
                        confirmButtonColor: '#7c3aed'
                    });
                }
            }
        });
    });
</script>

