@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
    $generalSettings = \App\General\GeneralSettingsClass::getAllSettings();
    $localJobMovers = (int)($generalSettings['_local_job_number_of_movers'] ?? 2);
    $localJobPrice = (float)($generalSettings['_local_job_mover_per_hour_price'] ?? 85);
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Truck Management') }}</h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Truck Management
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ route('admin.trucks.create') }}'"
                    class="btn btn-success global-create-btn">
                    <i class="fa-solid fa-plus me-1"></i>Add New Truck</button>
            </div>
        </div>
    </div>

    <!-- Advanced Filters Card -->
    <div class="card shadow-sm mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="bi bi-funnel me-2"></i>Advanced Filters
                </h6>
                <button class="btn btn-sm btn-outline-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse">
                    <i class="bi bi-chevron-down"></i>
                </button>
            </div>
        </div>
        <div class="collapse {{ request()->hasAny(['keyword', 'truck_type', 'status', 'pricing_type']) ? 'show' : '' }}"
            id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.trucks.index') }}" class="row g-3">
                    <div class="col-lg-4 col-md-6">
                        <label for="keyword_filter" class="form-label">Search</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                            <input type="text" class="form-control" id="keyword_filter" name="keyword"
                                value="{{ request('keyword') }}" placeholder="Search truck name...">
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-4">
                        <label for="truck_type_filter" class="form-label">Truck Type</label>
                        <select class="form-select" id="truck_type_filter" name="truck_type">
                            <option value="">All Types</option>
                            <option value="light_rigid" {{ request('truck_type') == 'light_rigid' ? 'selected' : '' }}>Light</option>
                            <option value="medium_rigid" {{ request('truck_type') == 'medium_rigid' ? 'selected' : '' }}>Medium</option>
                            <option value="heavy_rigid" {{ request('truck_type') == 'heavy_rigid' ? 'selected' : '' }}>Heavy</option>
                        </select>
                    </div>

                    <div class="col-lg-2 col-md-4">
                        <label for="status_filter" class="form-label">Status</label>
                        <select class="form-select" id="status_filter" name="status">
                            <option value="">All Status</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>

                    <div class="col-lg-2 col-md-4">
                        <label for="pricing_type_filter" class="form-label">Pricing Type</label>
                        <select class="form-select" id="pricing_type_filter" name="pricing_type">
                            <option value="">All Pricing</option>
                            <option value="global" {{ request('pricing_type') == 'global' ? 'selected' : '' }}>Global</option>
                            <option value="custom" {{ request('pricing_type') == 'custom' ? 'selected' : '' }}>Custom</option>
                        </select>
                    </div>

                    <div class="col-lg-2 col-md-12 d-flex align-items-end">
                        <div class="btn-group w-100" role="group">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-funnel me-1"></i>Filter
                            </button>
                            <a href="{{ route('admin.trucks.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-clockwise me-1"></i>Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h5 class="card-title mb-0">Trucks Table</h5>
            <div class="text-muted">
                @if(request()->hasAny(['keyword', 'truck_type', 'status', 'pricing_type']))
                    Filtered Results: {{ $trucks->count() }}
                    <a href="{{ route('admin.trucks.index') }}" class="btn btn-sm btn-outline-secondary ms-2">
                        <i class="fa-solid fa-times me-1"></i>Clear Filters
                    </a>
                @else
                    Total Trucks: {{ $trucks->count() }}
                @endif
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless">
                    <thead>
                        <tr>
                            <th>Truck Details</th>
                            <th>Type & Capacity</th>
                            <th>Movers & Pricing</th>
                            <th>Status</th>
                            <th width="120px">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($trucks as $truck)
                            <tr class="align-middle">
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($truck->truck_image)
                                            <img src="{{ asset($truck->truck_image) }}" alt="Truck image" class="img-thumbnail me-3" style="width: 50px; height: 40px; object-fit: cover;">
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 40px;">
                                                <i class="fas fa-truck text-muted"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <div class="fw-semibold">{{ $truck->truck_name }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="fw-semibold">
                                        <span class="badge bg-primary">{{ ucfirst(str_replace('_', ' ', $truck->truck_type)) }}</span>
                                    </div>
                                    <div class="mt-1">
                                        <small class="text-muted">
                                            <i class="fa-solid fa-cube me-1"></i>
                                            {{ number_format($truck->cubic_capacity, 2) }} m³
                                        </small>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <small class="text-muted">Movers:</small>
                                        <span class="fw-semibold">{{ $localJobMovers }}</span>
                                        <small class="text-muted">(Local Job)</small>
                                    </div>
                                    <div>
                                        <small class="text-muted">Price/Hour:</small>
                                        <span class="fw-semibold">${{ number_format($localJobPrice, 2) }}</span>
                                        <small class="text-muted">(Local Job)</small>
                                    </div>
                                    <div class="mt-1">
                                        @if($truck->pricing_type === 'custom')
                                            <span class="badge bg-primary-subtle text-primary">Custom Pricing</span>
                                        @else
                                            <span class="badge bg-info-subtle text-info">Global Pricing</span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    @if($truck->is_active)
                                        <span class="badge bg-success px-2 py-1">
                                            <i class="fa-solid fa-check-circle me-1"></i>Active
                                        </span>
                                    @else
                                        <span class="badge bg-danger px-2 py-1">
                                            <i class="fa-solid fa-times-circle me-1"></i>Inactive
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm"
                                            type="button" data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <button class="dropdown-item" onclick="viewTruck({{ $truck->id }})">
                                                    <i class="bi bi-eye me-2"></i> View Details
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="window.location = '{{ route('admin.trucks.edit', $truck->id) }}'">
                                                    <i class="bi bi-pencil me-2"></i> Edit
                                                </button>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="changeTruckStatus({{ $truck->id }}, this)">
                                                    <i class="bi bi-toggle-{{ $truck->is_active ? 'on' : 'off' }} me-2"></i> 
                                                    {{ $truck->is_active ? 'Deactivate' : 'Activate' }}
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-danger" onclick="deleteTruck({{ $truck->id }})">
                                                    <i class="bi bi-trash me-2"></i> Delete
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                        <tr class="no-data-row">
                            <td></td>
                            <td></td>
                            <td class="text-center text-muted py-4">No trucks found</td>
                            <td></td>
                            <td></td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Truck Details</th>
                            <th>Type & Capacity</th>
                            <th>Movers & Pricing</th>
                            <th>Status</th>
                            <th width="120px">Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Truck View Modal -->
<div class="modal fade" id="truckViewModal" tabindex="-1" aria-labelledby="truckViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="truckViewModalLabel">Truck Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="truck-details-container" style="max-height: 70vh; overflow-y: auto; padding: 1rem;">
                    <div id="truckViewContent">
                        <!-- Content will be loaded here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    /* Custom scrollbar for truck details modal */
    .truck-details-container::-webkit-scrollbar {
        width: 8px;
    }
    
    .truck-details-container::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 4px;
    }
    
    .truck-details-container::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 4px;
    }
    
    .truck-details-container::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }

    /* Status badge improvements */
    .badge {
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .modal-xl {
            max-width: 95%;
            margin: 0.5rem auto;
        }
        
        .truck-details-container {
            max-height: 60vh !important;
        }
        
        .truck-details-content .row .col-md-6 {
            margin-bottom: 1rem;
        }
    }
    
    @media (max-width: 576px) {
        .truck-details-container {
            max-height: 50vh !important;
            padding: 0.5rem !important;
        }
        
        .truck-details-content {
            padding: 1rem !important;
        }
        
        .detail-item {
            font-size: 0.85rem;
        }
    }
</style>

<script>
    // Auto-submit form on filter change (optional)
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize DataTables
        if ($.fn.DataTable.isDataTable('#data_Table')) {
            $('#data_Table').DataTable().destroy();
        }
        
        $('#data_Table').DataTable({
            responsive: true,
            autoWidth: false,
            columnDefs: [
                { orderable: false, targets: -1 } // Disable sorting on "Actions" column
            ],
            language: {
                searchPlaceholder: 'Search trucks...',
                sSearch: ''
            },
            "order": [[0, "asc"]], // Sort by first column (Truck Details) ascending
            "columnDefs": [
                { "targets": [4], "orderable": false, "searchable": false } // Actions column
            ],
            "pageLength": 10,
            "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
            "dom": '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rtip',
        });

        const filterForm = document.querySelector('form[action="{{ route('admin.trucks.index') }}"]');
        const filterInputs = filterForm.querySelectorAll('select[name="truck_type"], select[name="status"], select[name="pricing_type"]');
        
        // Add change event listeners to select elements for auto-submit
        filterInputs.forEach(function(select) {
            select.addEventListener('change', function() {
                setTimeout(function() {
                    filterForm.submit();
                }, 100);
            });
        });

        // Add enter key support for keyword search
        const keywordInput = filterForm.querySelector('input[name="keyword"]');
        if (keywordInput) {
            keywordInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    filterForm.submit();
                }
            });
        }
    });

    // View truck function
    function viewTruck(truckId) {
        $.ajax({
            url: "{{ route('admin.trucks.show', '') }}/" + truckId,
            type: "GET",
            success: function(response) {
                $('#truckViewContent').html(response);
                $('#truckViewModal').modal('show');
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to load truck details'
                });
            }
        });
    }

    // Change truck status
    function changeTruckStatus(truckId, element) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You want to change the truck status?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, change it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "{{ route('admin.trucks.changeStatus') }}",
                    type: "POST",
                    data: { id: truckId },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Status Updated',
                                text: response.message,
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message || 'Failed to update status'
                            });
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = 'Something went wrong';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage
                        });
                    }
                });
            }
        });
    }

    // Delete truck
    function deleteTruck(truckId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                const deleteUrl = "{{ route('admin.trucks.destroy', ':id') }}".replace(':id', truckId);
                
                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.message || 'Truck has been deleted.',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message || 'Failed to delete truck'
                            });
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = 'Something went wrong';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage
                        });
                    }
                });
            }
        });
    }
</script>
