@extends('Admin.Includes.header')
@section('title', 'Dashboard - Speedy Move')

@section('content')
<div class="page-content">
    <div class="container-fluid">
        <!-- Filter and Export Section -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card shadow-sm border-0">
                    <div class="card-body py-3">
                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                            <div class="d-flex align-items-center gap-2">
                                <label for="filter-select" class="mb-0 fw-semibold text-muted">Filter:</label>
                                <select class="form-select form-select-sm modern-select" id="filter-select" style="width: auto; min-width: 150px;">
                                    <option value="this_year" {{ $filter == 'this_year' ? 'selected' : '' }}>This Year</option>
                                    <option value="today" {{ $filter == 'today' ? 'selected' : '' }}>Today</option>
                                    <option value="yesterday" {{ $filter == 'yesterday' ? 'selected' : '' }}>Yesterday</option>
                                    <option value="this_week" {{ $filter == 'this_week' ? 'selected' : '' }}>This Week</option>
                                    <option value="last_week" {{ $filter == 'last_week' ? 'selected' : '' }}>Last Week</option>
                                    <option value="this_month" {{ $filter == 'this_month' ? 'selected' : '' }}>This Month</option>
                                    <option value="last_month" {{ $filter == 'last_month' ? 'selected' : '' }}>Last Month</option>
                                    <option value="last_6_months" {{ $filter == 'last_6_months' ? 'selected' : '' }}>Last 6 Months</option>
                                    <option value="last_year" {{ $filter == 'last_year' ? 'selected' : '' }}>Last Year</option>
                                    <option value="all" {{ $filter == 'all' ? 'selected' : '' }}>All</option>
                                </select>
                            </div>
                            {{-- <button class="btn btn-primary btn-sm px-4" id="export-csv-btn">
                                <i class="bi bi-download me-1"></i> Download CSV Report
                            </button> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Module Stats - Moved to Top -->
        <div class="row g-3 mb-4">
            <div class="col-lg-4 col-md-6">
                <a href="{{ route('blogs.index') }}" class="text-decoration-none">
                    <div class="card module-card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1 small fw-medium">Active Blogs</p>
                                    <h4 class="mb-0 fw-bold">{{ $metrics['active_blogs'] }}</h4>
                                </div>
                                <div class="module-icon bg-info-subtle">
                                    <i class="bi bi-journal-text text-info"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-4 col-md-6">
                <a href="{{ route('admin.trucks.index') }}" class="text-decoration-none">
                    <div class="card module-card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1 small fw-medium">Active Trucks</p>
                                    <h4 class="mb-0 fw-bold">{{ $metrics['active_trucks'] }}</h4>
                                </div>
                                <div class="module-icon bg-success-subtle">
                                    <i class="bi bi-truck text-success"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            {{-- <div class="col-lg-3 col-md-6">
                <a href="{{ route('admin.jobs.index') }}" class="text-decoration-none">
                    <div class="card module-card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1 small fw-medium">Active Jobs</p>
                                    <h4 class="mb-0 fw-bold">{{ $metrics['active_jobs'] }}</h4>
                                </div>
                                <div class="module-icon bg-warning-subtle">
                                    <i class="bi bi-briefcase text-warning"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div> --}}
            <div class="col-lg-4 col-md-6">
                <a href="{{ route('admin.testimonials.index') }}" class="text-decoration-none">
                    <div class="card module-card border-0 shadow-sm h-100 hover-lift">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1">
                                    <p class="text-muted mb-1 small fw-medium">Testimonials</p>
                                    <h4 class="mb-0 fw-bold">{{ $metrics['active_testimonials'] }}</h4>
                                </div>
                                <div class="module-icon bg-primary-subtle">
                                    <i class="bi bi-star text-primary"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <!-- Stats Cards Row -->
        <div class="row g-3 mb-4">
            <div class="col-xl-4 col-md-6">
                <div class="card stats-card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted mb-2 small fw-medium">Total Orders</p>
                                <h3 class="mb-0 fw-bold" id="stat-total-orders">{{ $metrics['total_orders'] }}</h3>
                            </div>
                            <div class="stats-icon bg-primary-subtle">
                                <i class="bi bi-cart-check text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card stats-card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted mb-2 small fw-medium">Total Revenue</p>
                                <h3 class="mb-0 fw-bold text-success" id="stat-total-revenue">${{ number_format($metrics['total_revenue'], 2) }}</h3>
                            </div>
                            <div class="stats-icon bg-success-subtle">
                                <i class="bi bi-currency-dollar text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card stats-card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted mb-2 small fw-medium">Total Customers</p>
                                <h3 class="mb-0 fw-bold text-info" id="stat-total-customers">{{ $metrics['total_customers'] }}</h3>
                            </div>
                            <div class="stats-icon bg-info-subtle">
                                <i class="bi bi-people text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{-- <div class="col-xl-3 col-md-6">
                <div class="card stats-card border-0 shadow-sm h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <p class="text-muted mb-2 small fw-medium">Job Applications</p>
                                <h3 class="mb-0 fw-bold text-warning" id="stat-job-apps">{{ $metrics['job_applications'] }}</h3>
                            </div>
                            <div class="stats-icon bg-warning-subtle">
                                <i class="bi bi-briefcase text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}
        </div>

        <!-- Dashboard Overview Chart -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0 pb-0 pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Dashboard Overview</h5>
                    </div>
                    <div class="card-body">
                        <div id="overviewChart" style="min-height: 400px; width: 100%; position: relative;"></div>
                        <div class="mt-4 row g-2" id="metrics-legend">
                            <div class="col-6 col-md-3">
                                <div class="d-flex align-items-center p-2 rounded bg-light">
                                    <span class="badge bg-secondary me-2" style="width: 12px; height: 12px; border-radius: 2px;"></span>
                                    <small class="text-muted">Bookings: <strong id="metric-total-bookings">{{ $metrics['total_bookings'] }}</strong></small>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="d-flex align-items-center p-2 rounded bg-light">
                                    <span class="badge bg-success me-2" style="width: 12px; height: 12px; border-radius: 2px;"></span>
                                    <small class="text-muted">Completed: <strong id="metric-completed-bookings">{{ $metrics['completed_bookings'] }}</strong></small>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="d-flex align-items-center p-2 rounded bg-light">
                                    <span class="badge bg-warning me-2" style="width: 12px; height: 12px; border-radius: 2px;"></span>
                                    <small class="text-muted">Pending: <strong id="metric-pending-bookings">{{ $metrics['pending_bookings'] }}</strong></small>
                                </div>
                            </div>
                            <div class="col-6 col-md-3">
                                <div class="d-flex align-items-center p-2 rounded bg-light">
                                    <span class="badge bg-primary me-2" style="width: 12px; height: 12px; border-radius: 2px;"></span>
                                    <small class="text-muted">Customers: <strong id="metric-total-customers">{{ $metrics['total_customers'] }}</strong></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-transparent border-0 pb-0 pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Quick Stats</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                            <div>
                                <p class="text-muted small mb-1">Quotes</p>
                                <h4 class="mb-0 fw-bold" id="summary-quotes">{{ $metrics['total_quotes'] }}</h4>
                            </div>
                            <div class="quick-stat-icon bg-info-subtle">
                                <i class="bi bi-file-earmark-text text-info"></i>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                            <div>
                                <p class="text-muted small mb-1">Orders</p>
                                <h4 class="mb-0 fw-bold text-success" id="summary-orders">{{ $metrics['total_orders'] }}</h4>
                            </div>
                            <div class="quick-stat-icon bg-primary-subtle">
                                <i class="bi bi-cart-check text-primary"></i>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                            <div>
                                <p class="text-muted small mb-1">Conversion Rate</p>
                                <h4 class="mb-0 fw-bold text-primary" id="summary-conversion">
                                    @if($metrics['total_quotes'] > 0)
                                        {{ number_format(($metrics['total_orders'] / $metrics['total_quotes']) * 100, 2) }}%
                                    @else
                                        0.00%
                                    @endif
                                </h4>
                            </div>
                            <div class="quick-stat-icon bg-primary-subtle">
                                <i class="bi bi-graph-up text-primary"></i>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <p class="text-muted small mb-1">Earnings</p>
                                <h4 class="mb-0 fw-bold text-success" id="summary-earnings">${{ number_format($metrics['total_revenue'], 2) }}</h4>
                            </div>
                            <div class="quick-stat-icon bg-success-subtle">
                                <i class="bi bi-cash-stack text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Chart and Top Locations -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0 pb-0 pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Revenue Trend</h5>
                    </div>
                    <div class="card-body">
                        <div id="revenueChart" style="min-height: 320px; width: 100%; position: relative;"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-transparent border-0 pb-0 pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Top Locations <small class="text-muted">({{ date('Y') }})</small></h5>
                    </div>
                    <div class="card-body">
                        @php
                            $totalSales = array_sum(array_column($topLocations, 'revenue'));
                        @endphp
                        <div class="mb-3 pb-3 border-bottom">
                            <h3 class="text-primary mb-0 fw-bold" id="total-sales">${{ number_format($totalSales, 2) }}</h3>
                            <small class="text-muted">Total Sales</small>
                        </div>
                        <div id="top-locations-list" style="max-height: 250px; overflow-y: auto;">
                            @forelse($topLocations as $index => $location)
                                @php
                                    $totalSales = array_sum(array_column($topLocations, 'revenue'));
                                    $percentage = $totalSales > 0 ? ($location['revenue'] / $totalSales) * 100 : 0;
                                @endphp
                                <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                                    <div class="d-flex align-items-center">
                                        <div class="location-icon bg-primary-subtle rounded-circle me-2">
                                            <i class="bi bi-geo-alt-fill text-primary"></i>
                                        </div>
                                        <div>
                                            <div class="fw-semibold small">{{ $location['location'] ?: 'Unknown Location' }}</div>
                                            <small class="text-muted">{{ $location['count'] }} booking(s)</small>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <div class="fw-bold">${{ number_format($location['revenue'], 2) }}</div>
                                        <small class="text-muted">{{ number_format($percentage, 0) }}%</small>
                                    </div>
                                </div>
                            @empty
                                <p class="text-muted text-center py-3">No location data available</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Orders and Customers -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Recent Orders</h5>
                        <a href="{{ route('admin.quotes.index') }}" class="btn btn-sm btn-link text-decoration-none">View All <i class="bi bi-arrow-right ms-1"></i></a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th class="border-0">Order ID</th>
                                        <th class="border-0">Customer</th>
                                        <th class="border-0">Amount</th>
                                        <th class="border-0">Date</th>
                                        <th class="border-0">Status</th>
                                        <th class="border-0 text-end">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="recent-quotes-table">
                                    @forelse($recentQuotes as $quote)
                                        <tr>
                                            <td><span class="fw-semibold">#{{ $quote->order_number ?? $quote->quote_number ?? $quote->id }}</span></td>
                                            <td>{{ $quote->user->name ?? 'N/A' }}</td>
                                            <td><span class="fw-semibold">${{ number_format($quote->total_cost ?? 0, 2) }}</span></td>
                                            <td><small class="text-muted">{{ $quote->created_at->format('d M Y, h:i A') }}</small></td>
                                            <td>
                                                @if($quote->status == 'approved')
                                                    <span class="badge bg-success-subtle text-success">Approved</span>
                                                @elseif($quote->status == 'pending')
                                                    <span class="badge bg-warning-subtle text-warning">Pending</span>
                                                @else
                                                    <span class="badge bg-danger-subtle text-danger">{{ ucfirst($quote->status) }}</span>
                                                @endif
                                            </td>
                                            <td class="text-end">
                                                <a href="{{ route('admin.quotes.show', $quote->id) }}" class="btn btn-sm btn-outline-primary">View</a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-muted py-4">No orders found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center pt-3">
                        <h5 class="card-title mb-0 fw-semibold">Recent Customers</h5>
                        <a href="{{ route('Customer.List') }}" class="btn btn-sm btn-link text-decoration-none">View All <i class="bi bi-arrow-right ms-1"></i></a>
                    </div>
                    <div class="card-body">
                        <div id="recent-customers-list" style="max-height: 580px; overflow-y: auto;">
                            @forelse($recentCustomers as $customer)
                                <div class="d-flex align-items-center mb-3 pb-3 border-bottom customer-item">
                                    <div class="customer-avatar bg-primary-subtle rounded-circle d-flex align-items-center justify-content-center me-3">
                                        <span class="text-primary fw-bold">{{ strtoupper(substr($customer->name, 0, 1)) }}</span>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="fw-semibold small">{{ $customer->name }}</div>
                                        <small class="text-muted d-block">{{ $customer->email }}</small>
                                        <small class="text-muted">{{ $customer->created_at->format('d M Y') }}</small>
                                    </div>
                                    <button type="button" class="btn btn-sm btn-outline-primary view-customer-btn" data-customer-id="{{ $customer->id }}">View</button>
                                </div>
                            @empty
                                <p class="text-muted text-center py-3">No customers found</p>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Customer View Modal -->
<div class="modal fade" id="customerViewModal" tabindex="-1" aria-labelledby="customerViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-primary text-white border-0">
                <h5 class="modal-title fw-bold" id="customerViewModalLabel">
                    <i class="bi bi-person-circle me-2"></i>Customer Details
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4" id="customerModalContent">
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="text-muted mt-3">Loading customer information...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .stats-card {
        transition: transform 0.2s, box-shadow 0.2s;
        border-left: 4px solid transparent !important;
    }
    .stats-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important;
    }
    .stats-card:nth-child(1) { border-left-color: #0d6efd !important; }
    .stats-card:nth-child(2) { border-left-color: #198754 !important; }
    .stats-card:nth-child(3) { border-left-color: #0dcaf0 !important; }
    .stats-card:nth-child(4) { border-left-color: #ffc107 !important; }
    
    .stats-icon, .quick-stat-icon, .module-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
    }
    
    .location-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
    }
    
    .customer-avatar {
        width: 40px;
        height: 40px;
        font-size: 14px;
    }
    
    .customer-item {
        transition: background-color 0.2s;
        padding: 8px;
        margin: -8px;
        border-radius: 8px;
    }
    .customer-item:hover {
        background-color: #f8f9fa;
    }
    
    .module-card {
        transition: all 0.3s ease;
    }
    
    .hover-lift:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 20px rgba(0,0,0,0.12) !important;
    }
    
    .modern-select {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        transition: all 0.2s;
    }
    .modern-select:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.1);
    }
    
    [data-bs-theme="dark"] {
        --bs-body-bg: #1a1d29;
        --bs-body-color: #e9ecef;
        --bs-card-bg: #212529;
        --bs-border-color: #495057;
    }
    
    [data-bs-theme="dark"] .card {
        background-color: var(--bs-card-bg);
        border-color: var(--bs-border-color);
    }
    
    [data-bs-theme="dark"] .table {
        --bs-table-bg: var(--bs-card-bg);
        color: var(--bs-body-color);
    }
    
    [data-bs-theme="dark"] .text-muted {
        color: #adb5bd !important;
    }
    
    [data-bs-theme="dark"] .customer-item:hover {
        background-color: #2c3034;
    }
    
    [data-bs-theme="dark"] .table-light {
        background-color: #2c3034 !important;
    }
</style>

<script>
// Ensure script runs after page is fully loaded
(function() {
    function initializeDashboard() {
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initializeDashboard);
            return;
        }
        
        // Additional check for window load
        if (document.readyState !== 'complete') {
            window.addEventListener('load', initializeDashboard);
            return;
        }
        
        runDashboardScript();
    }
    
    function runDashboardScript() {
    // Theme Toggle
    const themeToggle = document.getElementById('theme-toggle');
    const themeIcon = document.getElementById('theme-icon');
    const html = document.documentElement;
    
    if (themeToggle && themeIcon) {
        const currentTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-bs-theme', currentTheme);
        updateThemeIcon(currentTheme);
        
        themeToggle.addEventListener('click', function() {
            const currentTheme = html.getAttribute('data-bs-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            html.setAttribute('data-bs-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeIcon(newTheme);
            updateCharts();
        });
    } else {
        // Set default theme even if toggle doesn't exist
        const currentTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-bs-theme', currentTheme);
    }
    
    function updateThemeIcon(theme) {
        if (themeIcon) {
            if (theme === 'dark') {
                themeIcon.className = 'bi bi-moon';
            } else {
                themeIcon.className = 'bi bi-sun';
            }
        }
    }

    // Customer View Modal - Use event delegation for dynamically loaded content
    const customerModalElement = document.getElementById('customerViewModal');
    const customerModal = customerModalElement ? new bootstrap.Modal(customerModalElement) : null;
    
    // Use event delegation to handle clicks on view buttons
    document.addEventListener('click', function(e) {
        if (e.target.closest('.view-customer-btn')) {
            const btn = e.target.closest('.view-customer-btn');
            const customerId = btn.getAttribute('data-customer-id');
            const modalContent = document.getElementById('customerModalContent');
            
            if (!customerModal || !modalContent) return;
            
            modalContent.innerHTML = `
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="text-muted mt-3">Loading customer information...</p>
                </div>
            `;
            
            customerModal.show();
            
            fetch(`/admin/users/${customerId}`, {
                headers: {
                    'Accept': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 200) {
                    const user = data.user_details;
                    const quotes = data.quotes || [];
                    const orders = data.orders || [];
                    const userMeta = data.user_meta || [];
                    
                    // Get business info from meta
                    const businessName = userMeta.find(m => m.option === '_b_name')?.value || 'N/A';
                    const businessEmail = userMeta.find(m => m.option === '_b_email')?.value || 'N/A';
                    const businessPhone = userMeta.find(m => m.option === '_b_number')?.value || 'N/A';
                    const businessAddress = userMeta.find(m => m.option === '_b_street_address')?.value || 'N/A';
                    const businessArea = userMeta.find(m => m.option === '_b_area_address')?.value || 'N/A';
                    
                    modalContent.innerHTML = `
                        <div class="row mb-4">
                            <div class="col-md-4 text-center">
                                <div class="customer-avatar bg-primary-subtle rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 80px; height: 80px; font-size: 32px;">
                                    <span class="text-primary fw-bold">${user.name.charAt(0).toUpperCase()}</span>
                                </div>
                                <h5 class="fw-bold mb-1">${user.name}</h5>
                                <p class="text-muted small mb-0">Customer ID: #${user.id}</p>
                            </div>
                            <div class="col-md-8">
                                <div class="row g-3">
                                    <div class="col-6">
                                        <label class="text-muted small d-block mb-1">Email</label>
                                        <p class="mb-0 fw-semibold">${user.email}</p>
                                    </div>
                                    <div class="col-6">
                                        <label class="text-muted small d-block mb-1">Phone</label>
                                        <p class="mb-0 fw-semibold">${user.phone || 'N/A'}</p>
                                    </div>
                                    <div class="col-6">
                                        <label class="text-muted small d-block mb-1">Status</label>
                                        <span class="badge ${user.active ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'}">${user.active ? 'Active' : 'Inactive'}</span>
                                    </div>
                                    <div class="col-6">
                                        <label class="text-muted small d-block mb-1">Registered</label>
                                        <p class="mb-0 small">${new Date(user.created_at).toLocaleDateString()}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <hr>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h6 class="fw-semibold mb-3"><i class="bi bi-building me-2"></i>Business Information</h6>
                                <table class="table table-sm table-borderless">
                                    <tr><td class="text-muted small" style="width: 40%;">Business Name:</td><td class="fw-semibold">${businessName}</td></tr>
                                    <tr><td class="text-muted small">Business Email:</td><td class="fw-semibold">${businessEmail}</td></tr>
                                    <tr><td class="text-muted small">Business Phone:</td><td class="fw-semibold">${businessPhone}</td></tr>
                                    <tr><td class="text-muted small">Address:</td><td class="fw-semibold">${businessAddress}</td></tr>
                                    <tr><td class="text-muted small">Area:</td><td class="fw-semibold">${businessArea}</td></tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6 class="fw-semibold mb-3"><i class="bi bi-graph-up me-2"></i>Statistics</h6>
                                <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                                    <span class="text-muted">Total Quotes</span>
                                    <span class="fw-bold text-info">${data.quotes_count || 0}</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3 pb-3 border-bottom">
                                    <span class="text-muted">Total Orders</span>
                                    <span class="fw-bold text-success">${data.orders_count || 0}</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="text-muted">Conversion Rate</span>
                                    <span class="fw-bold text-primary">
                                        ${data.quotes_count > 0 ? ((data.orders_count / data.quotes_count) * 100).toFixed(2) : 0}%
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        ${quotes.length > 0 || orders.length > 0 ? `
                        <hr>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="fw-semibold mb-0"><i class="bi bi-list-ul me-2"></i>Recent Activity</h6>
                            <a href="/admin/users/${user.id}/edit" class="btn btn-sm btn-primary">Edit Customer</a>
                        </div>
                        ${quotes.length > 0 ? `
                        <div class="mb-3">
                            <small class="text-muted fw-semibold">Recent Quotes (${quotes.length})</small>
                            <div class="list-group list-group-flush mt-2">
                                ${quotes.slice(0, 3).map(quote => `
                                    <div class="list-group-item border-0 px-0">
                                        <div class="d-flex justify-content-between">
                                            <div>
                                                <span class="fw-semibold">#${quote.quote_number || quote.id}</span>
                                                <small class="text-muted d-block">${new Date(quote.created_at).toLocaleDateString()}</small>
                                            </div>
                                            <span class="badge bg-info-subtle text-info">$${parseFloat(quote.total_cost || 0).toFixed(2)}</span>
                                        </div>
                                    </div>
                                `).join('')}
                            </div>
                        </div>
                        ` : ''}
                        ${orders.length > 0 ? `
                        <div>
                            <small class="text-muted fw-semibold">Recent Orders (${orders.length})</small>
                            <div class="list-group list-group-flush mt-2">
                                ${orders.slice(0, 3).map(order => `
                                    <div class="list-group-item border-0 px-0">
                                        <div class="d-flex justify-content-between">
                                            <div>
                                                <span class="fw-semibold">#${order.order_number || order.quote_number || order.id}</span>
                                                <small class="text-muted d-block">${new Date(order.created_at).toLocaleDateString()}</small>
                                            </div>
                                            <span class="badge bg-success-subtle text-success">$${parseFloat(order.total_cost || 0).toFixed(2)}</span>
                                        </div>
                                    </div>
                                `).join('')}
                            </div>
                        </div>
                        ` : ''}
                        ` : ''}
                    `;
                } else {
                    modalContent.innerHTML = `
                        <div class="alert alert-danger">
                            <i class="bi bi-exclamation-triangle me-2"></i>${data.message || 'Failed to load customer information'}
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                modalContent.innerHTML = `
                    <div class="alert alert-danger">
                        <i class="bi bi-exclamation-triangle me-2"></i>Error loading customer information. Please try again.
                    </div>
                `;
            });
        }
    });

    // Revenue Chart - Improved with Area Chart
    let revenueChart;
    function initRevenueChart() {
        const isDark = html.getAttribute('data-bs-theme') === 'dark';
        const revenueData = @json($revenueData);
        const chartElement = document.querySelector("#revenueChart");
        
        if (!chartElement) {
            console.error('Revenue chart element not found');
            return;
        }
        
        if (revenueChart) {
            revenueChart.destroy();
        }
        
        const revenueValues = revenueData.map(item => parseFloat(item.revenue) || 0);
        const maxRevenue = Math.max(...revenueValues, 1);
        
        const options = {
            series: [{
                name: 'Revenue',
                data: revenueValues
            }],
            chart: {
                type: 'area',
                height: 320,
                toolbar: { show: false },
                background: 'transparent',
                zoom: { enabled: false },
                sparkline: { enabled: false },
                animations: {
                    enabled: true,
                    easing: 'easeinout',
                    speed: 1000
                }
            },
            colors: ['#0d6efd'],
            fill: {
                type: 'gradient',
                gradient: {
                    shadeIntensity: 1,
                    opacityFrom: 0.7,
                    opacityTo: 0.15,
                    stops: [0, 90, 100],
                    colorStops: [
                        {
                            offset: 0,
                            color: '#0d6efd',
                            opacity: 0.8
                        },
                        {
                            offset: 50,
                            color: '#0d6efd',
                            opacity: 0.4
                        },
                        {
                            offset: 100,
                            color: '#0d6efd',
                            opacity: 0.1
                        }
                    ]
                }
            },
            dataLabels: {
                enabled: false
            },
            stroke: {
                curve: 'smooth',
                width: 3,
                lineCap: 'round'
            },
            markers: {
                size: 0,
                hover: {
                    size: 6,
                    sizeOffset: 3
                },
                strokeWidth: 2,
                strokeColors: '#fff',
                strokeOpacity: 1
            },
            xaxis: {
                categories: revenueData.map(item => item.month || ''),
                labels: {
                    style: {
                        colors: isDark ? '#adb5bd' : '#6c757d',
                        fontSize: '11px',
                        fontWeight: 500
                    },
                    rotate: -45,
                    rotateAlways: false,
                    trim: true,
                    maxHeight: 60
                },
                axisBorder: {
                    show: false
                },
                axisTicks: {
                    show: false
                }
            },
            yaxis: {
                title: {
                    text: 'Amount ($)',
                    style: {
                        color: isDark ? '#adb5bd' : '#6c757d',
                        fontSize: '12px',
                        fontWeight: 600
                    },
                    offsetX: -10
                },
                labels: {
                    formatter: function(val) {
                        if (val >= 1000) {
                            return '$' + (val / 1000).toFixed(1) + 'k';
                        }
                        return '$' + parseFloat(val).toFixed(0);
                    },
                    style: {
                        colors: isDark ? '#adb5bd' : '#6c757d',
                        fontSize: '11px'
                    }
                },
                min: 0,
                forceNiceScale: true
            },
            grid: {
                borderColor: isDark ? '#495057' : '#e9ecef',
                strokeDashArray: 3,
                xaxis: {
                    lines: {
                        show: false
                    }
                },
                yaxis: {
                    lines: {
                        show: true
                    }
                },
                padding: {
                    top: 0,
                    right: 0,
                    bottom: 0,
                    left: 0
                }
            },
            tooltip: {
                theme: isDark ? 'dark' : 'light',
                style: {
                    fontSize: '12px'
                },
                y: {
                    formatter: function(val) {
                        return '$' + parseFloat(val).toLocaleString('en-US', {
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2
                        });
                    }
                },
                marker: {
                    show: true
                },
                fixed: {
                    enabled: false,
                    position: 'topRight',
                    offsetX: 0,
                    offsetY: 0
                }
            },
            legend: {
                show: false
            },
            noData: {
                text: 'No revenue data available',
                align: 'center',
                verticalAlign: 'middle',
                style: {
                    color: isDark ? '#adb5bd' : '#6c757d',
                    fontSize: '14px'
                }
            }
        };
        
        try {
            if (typeof window.ApexCharts === 'undefined') {
                console.error('ApexCharts is not defined for revenue chart');
                chartElement.innerHTML = '<div class="text-center text-muted p-4">Chart library not loaded. Please refresh the page.</div>';
                return;
            }
            revenueChart = new window.ApexCharts(chartElement, options);
            revenueChart.render();
        } catch (error) {
            console.error('Error rendering revenue chart:', error);
            chartElement.innerHTML = '<div class="text-center text-danger p-4">Error: ' + error.message + '</div>';
        }
    }

    // Overview Chart (Bar Chart with proper width control)
    let overviewChart;
    function initOverviewChart() {
        const isDark = html.getAttribute('data-bs-theme') === 'dark';
        const metrics = @json($metrics);
        const chartElement = document.querySelector("#overviewChart");
        
        if (!chartElement) {
            console.error('Overview chart element not found');
            return;
        }
        
        if (overviewChart) {
            try {
                overviewChart.destroy();
            } catch(e) {
                console.warn('Error destroying chart:', e);
            }
            overviewChart = null;
        }
        
        // Ensure data is numeric
        const chartData = [
            Number(metrics.total_bookings) || 0,
            Number(metrics.completed_bookings) || 0,
            Number(metrics.pending_bookings) || 0,
            Number(metrics.inprogress_bookings) || 0,
            Number(metrics.cancelled_bookings) || 0,
            Number(metrics.total_customers) || 0,
            Number(metrics.total_quotes) || 0,
            Number(metrics.total_orders) || 0
        ];
        
        console.log('Chart Data:', chartData);
        console.log('Metrics:', metrics);
        
        const options = {
            series: [{
                name: 'Count',
                data: chartData
            }],
            chart: {
                type: 'bar',
                height: 400,
                toolbar: { show: false },
                background: 'transparent',
                animations: {
                    enabled: true,
                    easing: 'easeinout',
                    speed: 800
                }
            },
            plotOptions: {
                bar: {
                    distributed: true,
                    borderRadius: 6,
                    columnWidth: '50%',
                    dataLabels: {
                        position: 'top'
                    }
                }
            },
            colors: ['#6c757d', '#198754', '#ffc107', '#0dcaf0', '#dc3545', '#0d6efd', '#0dcaf0', '#198754'],
            dataLabels: {
                enabled: true,
                offsetY: -20,
                style: {
                    fontSize: '11px',
                    fontWeight: 600,
                    colors: [isDark ? '#e9ecef' : '#495057']
                },
                formatter: function(val) {
                    return val;
                }
            },
            xaxis: {
                categories: ['All Bookings', 'Completed', 'Pending', 'In Progress', 'Cancelled', 'Customers', 'Quotes', 'Orders'],
                labels: {
                    style: {
                        colors: isDark ? '#adb5bd' : '#495057',
                        fontSize: '11px'
                    },
                    rotate: -45,
                    rotateAlways: false
                }
            },
            yaxis: {
                labels: {
                    style: {
                        colors: isDark ? '#adb5bd' : '#495057'
                    }
                }
            },
            grid: {
                borderColor: isDark ? '#495057' : '#dee2e6',
                strokeDashArray: 4
            },
            tooltip: {
                theme: isDark ? 'dark' : 'light'
            },
            noData: {
                text: 'No data available',
                align: 'center',
                verticalAlign: 'middle',
                style: {
                    color: isDark ? '#adb5bd' : '#495057',
                    fontSize: '14px'
                }
            }
        };
        
        try {
            // Clear any existing content
            chartElement.innerHTML = '';
            
            if (typeof window.ApexCharts === 'undefined') {
                console.error('ApexCharts is not defined');
                chartElement.innerHTML = '<div class="text-center text-muted p-4">Chart library not loaded. Please refresh the page.</div>';
                return;
            }
            
            overviewChart = new window.ApexCharts(chartElement, options);
            overviewChart.render().then(() => {
                console.log('Overview chart rendered successfully');
            }).catch((error) => {
                console.error('Error during chart render:', error);
                chartElement.innerHTML = '<div class="text-center text-danger p-4">Error rendering chart: ' + error.message + '</div>';
            });
        } catch (error) {
            console.error('Error creating overview chart:', error);
            chartElement.innerHTML = '<div class="text-center text-muted p-4">Error loading chart: ' + error.message + '</div>';
        }
    }

    function updateCharts() {
        setTimeout(() => {
            initRevenueChart();
            initOverviewChart();
        }, 100);
    }

    // Wait for ApexCharts to be available
    function waitForApexCharts(callback, maxAttempts = 50) {
        let attempts = 0;
        const checkInterval = setInterval(() => {
            attempts++;
            if (typeof window.ApexCharts !== 'undefined' && typeof window.ApexCharts === 'function') {
                clearInterval(checkInterval);
                console.log('ApexCharts loaded after', attempts, 'attempts');
                callback();
            } else if (attempts >= maxAttempts) {
                clearInterval(checkInterval);
                console.error('ApexCharts library not loaded after', maxAttempts, 'attempts');
                console.log('window.ApexCharts:', typeof window.ApexCharts);
                const overviewElement = document.querySelector("#overviewChart");
                const revenueElement = document.querySelector("#revenueChart");
                if (overviewElement) {
                    overviewElement.innerHTML = '<div class="text-center text-danger p-4">Chart library failed to load. Please refresh the page.</div>';
                }
                if (revenueElement) {
                    revenueElement.innerHTML = '<div class="text-center text-danger p-4">Chart library failed to load. Please refresh the page.</div>';
                }
            }
        }, 100);
    }

    // Initialize charts after everything is ready
    waitForApexCharts(() => {
        // Wait for DOM to be fully ready and visible
        const initCharts = () => {
            const overviewElement = document.querySelector("#overviewChart");
            const revenueElement = document.querySelector("#revenueChart");
            
            if (overviewElement && revenueElement) {
                // Check if elements have dimensions
                const overviewReady = overviewElement.offsetWidth > 0 || overviewElement.offsetHeight > 0;
                const revenueReady = revenueElement.offsetWidth > 0 || revenueElement.offsetHeight > 0;
                
                if (overviewReady && revenueReady) {
                    console.log('Initializing charts...');
                    initRevenueChart();
                    initOverviewChart();
                } else {
                    // Retry after a short delay if elements aren't ready
                    console.log('Chart elements not ready, retrying...');
                    setTimeout(initCharts, 200);
                }
            } else {
                // Retry if elements don't exist yet
                console.log('Chart elements not found, retrying...');
                setTimeout(initCharts, 200);
            }
        };
        
        // Start initialization after a short delay
        setTimeout(initCharts, 500);
    });

    // Filter Change
    document.getElementById('filter-select').addEventListener('change', function() {
        const filter = this.value;
        window.location.href = "{{ route('Admin.Dashboard') }}?filter=" + filter;
    });

    // CSV Export
    document.getElementById('export-csv-btn').addEventListener('click', function() {
        const filter = document.getElementById('filter-select').value;
        window.location.href = "{{ route('admin.dashboard.export') }}?filter=" + filter;
    });
    }
    
    // Start initialization
    initializeDashboard();
})();
</script>
@endsection