<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\DashboardController;

use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ChildCategoryController;
use App\Http\Controllers\Admin\JobController;
use App\Http\Controllers\Admin\BlogCategoryController;
use App\Http\Controllers\Admin\CategorysliderController;
use App\Http\Controllers\Admin\GeneralSettingsController;
use App\Http\Controllers\Admin\DynamicPageController;
use App\Http\Controllers\Admin\TruckController;
use App\Http\Controllers\Admin\QuoteController;
use App\Http\Controllers\Admin\StorageItemController;
use App\Http\Controllers\Admin\TestimonialController;
// use App\Http\Controllers\JobApplicationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/




#Non-Authenticated Routes
Route::post('/admin/login', [AuthController::class, 'login'])->name('Admin.Login');
Route::post('/admin/forget-password', [AuthController::class, 'sendResetLinkEmail'])->name('Admin.ForgotPassword');

Route::get('/admin/reset-password', function () {
    return view('Admin.Auth.reset_password');
})->name('Admin.Auth.ResetPassword');
Route::post('/admin/update-password/submit', [AuthController::class, 'updatePassword'])->name('Admin.PasswordUpdate.Submit');



// Frontend dynamic page route (must be at the end, after all other routes)

Route::middleware(['super_user'])->group(function () {


    Route::group(['prefix' => 'admin'], function () {
            Route::get('/blogs', [App\Http\Controllers\Admin\BlogController::class, 'index'])->name('blogs.index');
            Route::get('/blogs/create', [App\Http\Controllers\Admin\BlogController::class, 'create'])->name('blogs.create');
            Route::post('/blogs', [App\Http\Controllers\Admin\BlogController::class, 'store'])->name('blogs.store');
            Route::get('/blogs/{blog}', [App\Http\Controllers\Admin\BlogController::class, 'show'])->name('blogs.show');
            Route::get('/blogs/{blog}/edit', [App\Http\Controllers\Admin\BlogController::class, 'edit'])->name('blogs.edit');
            Route::put('/blogs/{blog}', [App\Http\Controllers\Admin\BlogController::class, 'update'])->name('blogs.update');
            Route::delete('/blogs/{blog}', [App\Http\Controllers\Admin\BlogController::class, 'destroy'])->name('blogs.destroy');
            Route::put('/blogs/{blog}/update-status', [App\Http\Controllers\Admin\BlogController::class, 'updateStatus']);
            Route::get('/blogs/list/trash', [App\Http\Controllers\Admin\BlogController::class, 'trash'])->name('Admin.Blog.Trash');
            Route::put('/blogs/restore/{id}', [App\Http\Controllers\Admin\BlogController::class, 'restore'])->name('blogs.restore');
            Route::post('/blogs/check-permalink', [App\Http\Controllers\Admin\BlogController::class, 'checkPermalink'])->name('blogs.check.permalink');
            Route::post('/blogs/upload-content-image', [App\Http\Controllers\Admin\BlogController::class, 'uploadContentImage'])->name('blogs.upload.content.image');
            
            #Services
            Route::get('/services', [App\Http\Controllers\Admin\ServiceController::class, 'index'])->name('services.index');
            Route::get('/services/create', [App\Http\Controllers\Admin\ServiceController::class, 'create'])->name('services.create');
            Route::post('/services', [App\Http\Controllers\Admin\ServiceController::class, 'store'])->name('services.store');
            Route::get('/services/{service}', [App\Http\Controllers\Admin\ServiceController::class, 'show'])->name('services.show');
            Route::get('/services/{service}/edit', [App\Http\Controllers\Admin\ServiceController::class, 'edit'])->name('services.edit');
            Route::put('/services/{service}', [App\Http\Controllers\Admin\ServiceController::class, 'update'])->name('services.update');
            Route::delete('/services/{service}', [App\Http\Controllers\Admin\ServiceController::class, 'destroy'])->name('services.destroy');
            Route::put('/services/{service}/update-status', [App\Http\Controllers\Admin\ServiceController::class, 'updateStatus']);
            Route::get('/services/list/trash', [App\Http\Controllers\Admin\ServiceController::class, 'trash'])->name('Admin.Service.Trash');
            Route::put('/services/restore/{id}', [App\Http\Controllers\Admin\ServiceController::class, 'restore'])->name('services.restore');
            Route::post('/services/check-permalink', [App\Http\Controllers\Admin\ServiceController::class, 'checkPermalink'])->name('services.check.permalink');

            Route::get('/faqs', [App\Http\Controllers\Admin\FAQController::class, 'index'])->name('faqs.index');
            Route::get('/faqs/create', [App\Http\Controllers\Admin\FAQController::class, 'create'])->name('faqs.create');
            Route::post('/faqs', [App\Http\Controllers\Admin\FAQController::class, 'store'])->name('faqs.store');
            Route::get('/faqs/{faq}', [App\Http\Controllers\Admin\FAQController::class, 'show'])->name('faqs.show');
            Route::get('/faqs/{faq}/edit', [App\Http\Controllers\Admin\FAQController::class, 'edit'])->name('faqs.edit');
            Route::put('/faqs/{faq}', [App\Http\Controllers\Admin\FAQController::class, 'update'])->name('faqs.update');
            Route::delete('/faqs/{faq}', [App\Http\Controllers\Admin\FAQController::class, 'destroy'])->name('faqs.destroy');
            Route::put('/faqs/{faq}/update-status', [App\Http\Controllers\Admin\FAQController::class, 'updateStatus']);
            Route::post('/faqs/check-permalink', [App\Http\Controllers\Admin\FAQController::class, 'checkPermalink'])->name('faqs.check.permalink');
            Route::post('/faqs/generate-permalink', [App\Http\Controllers\Admin\FAQController::class, 'generatePermalink'])->name('faqs.generate.permalink');
            
            #Blog Categories
            Route::get('/blog-categories', [BlogCategoryController::class, 'index'])->name('admin.blog-categories.index');
            Route::post('/blog-categories', [BlogCategoryController::class, 'store'])->name('admin.blog-categories.store');
            Route::post('/blog-categories/check-permalink', [BlogCategoryController::class, 'checkPermalink'])->name('admin.blog-categories.check-permalink');
            Route::get('/blog-categories/{blogCategory}', [BlogCategoryController::class, 'show'])->name('admin.blog-categories.show');
            Route::get('/blog-categories/{blogCategory}/edit', [BlogCategoryController::class, 'edit'])->name('admin.blog-categories.edit');
            Route::put('/blog-categories/{blogCategory}', [BlogCategoryController::class, 'store'])->name('admin.blog-categories.update');
            Route::delete('/blog-categories/{blogCategory}', [BlogCategoryController::class, 'destroy'])->name('admin.blog-categories.destroy');
    });
    Route::get('/admin/blog/child-categories/{category}', [App\Http\Controllers\Admin\BlogController::class, 'getChildCategories'])->name('admin.blog.child-categories');
        

    #General
    Route::get('/admin', [DashboardController::class, 'index'])->name('Admin.Dashboard');
    Route::get('/admin/dashboard/metrics', [DashboardController::class, 'getFilteredDashboardMetrics'])->name('admin.dashboard.metrics');
    Route::get('/admin/dashboard/export', [DashboardController::class, 'exportReport'])->name('admin.dashboard.export');
    Route::get('/admin-logout', [AuthController::class, 'logout'])->name('Admin.Logout');
    
    Route::post('/admin/update-password', [UserController::class, 'updatePassword'])->name('Admin.LoggedUpdatePassword');
    Route::post('/admin/update-profile-image', [UserController::class, 'updateProfileImage'])->name('Admin.ProfileImage');

    #Customers (Users with role_id = 2)
    Route::get('/admin/users', [UserController::class, 'customers'])->name('users.index'); // Redirect to customers
    Route::get('/admin/users/list/customer', [UserController::class, 'customers'])->name('Customer.List');
    Route::get('/admin/users/create', [UserController::class, 'create'])->name('users.create');
    Route::post('/admin/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/admin/users/{user}', [UserController::class, 'show'])->name('users.show');
    Route::get('/admin/users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/admin/users/{user}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/admin/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
    Route::put('/admin/users/{user}/update-status', [UserController::class, 'updateStatus'])->name('Admin.User.UpdateStatus');
    Route::put('/profile/update', [UserController::class, 'updateProfile'])->name('admin.profile.update');
    Route::get('/profile', [UserController::class, 'showUserProfile'])->name('user.profile');

   

    #Product Categories
    #- Category
    Route::get('admin/category', [CategoryController::class, 'index'])->name('category.index');
    Route::post('/store', [CategoryController::class, 'store'])->name('category.store');
    Route::get('/fetch-all', [CategoryController::class, 'get_category'])->name('category');
    Route::get('/edit_category', [CategoryController::class, 'edit_category'])->name('category.edit');
    Route::post('/update_category/{id}', [CategoryController::class, 'update_category'])->name('category.update');
    Route::post('/delete_category', [CategoryController::class, 'delete'])->name('category.delete');
    Route::get('/show_category_detail', [CategoryController::class, 'show_category_detail'])->name('category.show_category_detail');
    Route::get('/admin/categories/next-sort-order', [CategoryController::class, 'getNextSortOrder'])->name('admin.categories.nextSortOrder');

    # Assemble/Disassemble Categories
    Route::get('/admin/assemble-disassemble-categories', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'index'])->name('admin.assemble-disassemble-categories.index');
    Route::post('/admin/assemble-disassemble-categories', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'store'])->name('admin.assemble-disassemble-categories.store');
    Route::delete('/admin/assemble-disassemble-categories/{assembleDisassembleCategory}', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'destroy'])->name('admin.assemble-disassemble-categories.destroy');
    Route::get('/admin/assemble-disassemble-categories/edit_category', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'edit_category'])->name('admin.assemble-disassemble-categories.edit_category');
    Route::post('/admin/assemble-disassemble-categories/update_category/{id}', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'update_category'])->name('admin.assemble-disassemble-categories.update_category');
    Route::get('/admin/assemble-disassemble-categories/next-sort-order', [App\Http\Controllers\Admin\AssembleDisassembleCategoryController::class, 'getNextSortOrder'])->name('admin.assemble-disassemble-categories.getNextSortOrder');

    #- child category
    Route::post('/store_child_category', [ChildCategoryController::class, 'store'])->name('child.category.store');
    Route::get('/admin/get_child_category', [ChildCategoryController::class, 'index'])->name('child.category.index');
    Route::get('/edit_child_category', [ChildCategoryController::class, 'edit'])->name('child.category.edit');
    Route::post('/update_child_category/{id}', [ChildCategoryController::class, 'update'])->name('child.category.update');
    Route::post('/delete_child_catgory', [ChildCategoryController::class, 'delete'])->name('child.category.delete');
    Route::get('/show_child_detail', [ChildCategoryController::class, 'show'])->name('child.category.show_detail');
    Route::get('/admin/child-categories/next-sort-order', [ChildCategoryController::class, 'getNextSortOrder'])->name('admin.child_categories.nextSortOrder');





    #- Category Slider
    Route::resource('/admin/catsliders', CategorysliderController::class);
    Route::put('/admin/catsliders/{catslider}/update-status', [CategorysliderController::class, 'updateStatus'])->name('Admin.catslider.UpdateStatus');
    Route::get('/admin/catsliders/list/trash', [CategorysliderController::class, 'trash'])->name('Admin.catslider.Trash');

  


    Route::get('/admin/newsletter/subscriptions', [GeneralSettingsController::class, 'newsletter_subscriptions'])->name('Admin.Subscription.index');
    Route::post('/admin/subscription/destroy/{id}', [GeneralSettingsController::class, 'subscription_destroy'])->name('Admin.Subscription.destroy');
    Route::post('/admin/subscription/bulk-delete', [GeneralSettingsController::class, 'subcription_bulk_delete'])->name('Admin.subscription.bulk-delete');

    Route::resource('/admin/general-settings', GeneralSettingsController::class);

  

    #-- Dynamic Pages Crud
    Route::resource('/admin/pages', DynamicPageController::class);
    Route::put('/admin/pages/{page}/update-status', [DynamicPageController::class, 'updateStatus'])->name('Admin.Page.UpdateStatus');
    Route::get('/admin/pages/list/trash', [DynamicPageController::class, 'trash'])->name('Admin.Pages.Trash');

    #Job Management
    Route::get('/admin/jobs', [JobController::class, 'index'])->name('admin.jobs.index');
    Route::get('/admin/jobs/create', [JobController::class, 'create'])->name('admin.jobs.create');
    Route::post('/admin/jobs/store', [JobController::class, 'store'])->name('admin.jobs.store');
    Route::get('/admin/jobs/edit', [JobController::class, 'edit'])->name('admin.jobs.edit');
    Route::get('/admin/jobs/{id}/edit', [JobController::class, 'edit'])->name('admin.jobs.edit');
    Route::put('/admin/jobs/update/{id}', [JobController::class, 'update'])->name('admin.jobs.update');
    Route::post('/admin/jobs/delete', [JobController::class, 'delete'])->name('admin.jobs.delete');
    Route::get('/admin/jobs/show', [JobController::class, 'show'])->name('admin.jobs.show');
    Route::get('/admin/jobs/next-sort-order', [JobController::class, 'getNextSortOrder'])->name('admin.jobs.nextSortOrder');
    Route::post('/admin/jobs/change-status', [JobController::class, 'changeStatus'])->name('admin.jobs.changeStatus');
    Route::post('/admin/jobs/check-permalink', [JobController::class, 'checkPermalink'])->name('admin.jobs.check.permalink');
    Route::post('/admin/jobs/generate-permalink', [JobController::class, 'generatePermalink'])->name('admin.jobs.generate.permalink');
    Route::get('/admin/jobs/{jobId}/applications', [JobController::class, 'applications'])->name('admin.jobs.applications');
    Route::post('/admin/job-applications/{applicationId}/update-status', [JobController::class, 'updateApplicationStatus'])->name('admin.job_applications.updateStatus');
    Route::get('/admin/job-applications/show', [JobController::class, 'showApplication'])->name('admin.job_applications.show');
    
    #Job Applications Management
    Route::get('/admin/job-applications', [JobController::class, 'allApplications'])->name('admin.job_applications.index');
    
    #Truck Management
    Route::get('/admin/trucks', [TruckController::class, 'index'])->name('admin.trucks.index');
    Route::get('/admin/trucks/create', [TruckController::class, 'create'])->name('admin.trucks.create');
    Route::post('/admin/trucks/store', [TruckController::class, 'store'])->name('admin.trucks.store');
    Route::get('/admin/trucks/{id}', [TruckController::class, 'show'])->name('admin.trucks.show');
    Route::get('/admin/trucks/{id}/edit', [TruckController::class, 'edit'])->name('admin.trucks.edit');
    Route::put('/admin/trucks/{id}', [TruckController::class, 'update'])->name('admin.trucks.update');
    Route::delete('/admin/trucks/{id}', [TruckController::class, 'destroy'])->name('admin.trucks.destroy');
    Route::post('/admin/trucks/change-status', [TruckController::class, 'changeStatus'])->name('admin.trucks.changeStatus');
    Route::get('/admin/trucks/next-sort-order', [TruckController::class, 'getNextSortOrder'])->name('admin.trucks.nextSortOrder');
    
    #Quote/Order Management
    Route::get('/admin/quotes', [QuoteController::class, 'index'])->name('admin.quotes.index');
    Route::get('/admin/quotes/{id}', [QuoteController::class, 'show'])->name('admin.quotes.show');
    Route::get('/admin/quotes/{id}/edit', [QuoteController::class, 'edit'])->name('admin.quotes.edit');
    Route::get('/admin/quotes/{id}/edit-data', [QuoteController::class, 'editData'])->name('admin.quotes.editData');
    Route::post('/admin/quotes/{id}/update-status', [QuoteController::class, 'updateStatus'])->name('admin.quotes.updateStatus');
    Route::put('/admin/quotes/{id}', [QuoteController::class, 'update'])->name('admin.quotes.update');
    Route::delete('/admin/quotes/{id}', [QuoteController::class, 'destroy'])->name('admin.quotes.destroy');
    Route::post('/admin/quotes/{id}/send-remaining-payment-email', [QuoteController::class, 'sendRemainingPaymentEmail'])->name('admin.quotes.sendRemainingPaymentEmail');
    Route::post('/admin/quotes/{id}/release-remaining-payment', [QuoteController::class, 'releaseRemainingPayment'])->name('admin.quotes.releaseRemainingPayment');
    Route::get('/admin/quotes/{id}/get-payment-link', [QuoteController::class, 'getRemainingPaymentLink'])->name('admin.quotes.getRemainingPaymentLink');
    Route::post('/admin/quotes/{id}/apply-discount', [QuoteController::class, 'applyDiscount'])->name('admin.quotes.applyDiscount');
    Route::post('/admin/quotes/{id}/approve-bank-transfer-payment', [QuoteController::class, 'approveBankTransferPayment'])->name('admin.quotes.approveBankTransferPayment');
    Route::post('/admin/quotes/{id}/adjust-remaining-amount', [QuoteController::class, 'adjustRemainingAmount'])->name('admin.quotes.adjustRemainingAmount');
    Route::post('/admin/quotes/{id}/upload-remaining-proof', [QuoteController::class, 'uploadRemainingProof'])->name('admin.quotes.uploadRemainingProof');

    Route::get('/admin/storage-items', [StorageItemController::class, 'index'])->name('admin.storage-items.index');
    Route::post('/admin/storage-items', [StorageItemController::class, 'store'])->name('admin.storage-items.store');
    Route::get('/admin/storage-items/next-sort-order', [StorageItemController::class, 'getNextSortOrder'])->name('admin.storage-items.nextSortOrder');
    Route::get('/admin/storage-items/edit', [StorageItemController::class, 'edit'])->name('admin.storage-items.edit');
    Route::post('/admin/storage-items/delete', [StorageItemController::class, 'delete'])->name('admin.storage-items.delete');
    Route::post('/admin/storage-items/{id}/status', [StorageItemController::class, 'update'])->name('admin.storage-items.updateStatus');
    
    #Testimonials Management
    Route::get('/admin/testimonials', [TestimonialController::class, 'index'])->name('admin.testimonials.index');
    Route::get('/admin/testimonials/create', [TestimonialController::class, 'create'])->name('admin.testimonials.create');
    Route::post('/admin/testimonials', [TestimonialController::class, 'store'])->name('admin.testimonials.store');
    Route::post('/admin/testimonials/{id}/change-status', [TestimonialController::class, 'changeStatus'])->name('admin.testimonials.changeStatus');
    Route::get('/admin/testimonials/{id}/edit', [TestimonialController::class, 'edit'])->name('admin.testimonials.edit');
    Route::put('/admin/testimonials/{id}', [TestimonialController::class, 'update'])->name('admin.testimonials.update');
    Route::delete('/admin/testimonials/{id}', [TestimonialController::class, 'destroy'])->name('admin.testimonials.destroy');
    Route::get('/admin/testimonials/{id}', [TestimonialController::class, 'show'])->name('admin.testimonials.show');
    
    #Contact Us Management
    Route::get('/admin/contact-us', [App\Http\Controllers\Admin\ContactUsController::class, 'index'])->name('admin.contact-us.index');
    Route::get('/admin/contact-us/{contact}', [App\Http\Controllers\Admin\ContactUsController::class, 'show'])->name('admin.contact-us.show');
    Route::get('/admin/contact-us/{contact}/edit', [App\Http\Controllers\Admin\ContactUsController::class, 'edit'])->name('admin.contact-us.edit');
    Route::put('/admin/contact-us/{contact}', [App\Http\Controllers\Admin\ContactUsController::class, 'update'])->name('admin.contact-us.update');
    Route::delete('/admin/contact-us/{contact}', [App\Http\Controllers\Admin\ContactUsController::class, 'destroy'])->name('admin.contact-us.destroy');
    Route::get('/admin/contact-us/{contact}/download', [App\Http\Controllers\Admin\ContactUsController::class, 'downloadFile'])->name('admin.contact-us.download');
    Route::post('/admin/contact-us/bulk-delete', [App\Http\Controllers\Admin\ContactUsController::class, 'bulkDelete'])->name('admin.contact-us.bulk-delete');
});

#Public Job Routes
// Route::get('/careers', [JobApplicationController::class, 'index'])->name('jobs.index');
// Route::get('/careers/{id}', [JobApplicationController::class, 'show'])->name('jobs.show');

Route::fallback(function () {
    if (request()->is('admin/login')) {
        return redirect('/');
    }
    
    // Default 404 handling
    abort(404);
});

$route = 1;
if($route == 1){
            Route::get('', function () {
                $user = Auth::user();
                if (!$user) {
                    return view('Admin.Auth.login');
                }
                return redirect('/admin');
            });

}


