<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\API\Traits\ValidationTrait;
use App\Http\Controllers\API\Traits\EmailTrait;
use App\Http\Controllers\API\Traits\JsonResponseTrait;
use App\Http\Controllers\Controller;
use App\Models\Contactu;
use App\Models\NewsLetterSubscription;
use Illuminate\Http\Request;

class NewLetterSubscriptionController extends Controller
{

    use ValidationTrait, EmailTrait, JsonResponseTrait;
    public function store(NewsLetterSubscription $newsLetterSubscription, Request $request)
    {
        return $this->newsLetter($newsLetterSubscription, $request);
    }

    public function contactUs(Request $request)
    {
        $validator = $this->contactUsValidationRequest($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $data = $request->all();
        // Handle file upload if present
        // if ($request->hasFile('file')) {
            //     $file = $request->file('file');
            //     $fileName = time() . '_' . $file->getClientOriginalName();
            //     $filePath = $file->storeAs('contact_us_files', $fileName, 'public');
            //     $data['file_path'] = $filePath;
            // }
            $contact = Contactu::create($data);
            if (!$contact) {
                return $this->message('something went wrong');
            }

        // Send contact us email
        try {
            $emailSent = $this->contactUsEmail($contact);
            if ($emailSent) {
                return $this->message('Message sent successfully. We will get back to you soon.');
            } else {
                // Email failed but contact was saved
                \Illuminate\Support\Facades\Log::warning('Contact us email failed to send', [
                    'contact_id' => $contact->id,
                    'email' => $contact->email ?? 'unknown'
                ]);
                return $this->message('Your message has been received. We will get back to you soon.');
            }
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::error('Contact us email exception', [
                'contact_id' => $contact->id,
                'error' => $e->getMessage()
            ]);
            return $this->message('Your message has been received. We will get back to you soon.');
        }
    }
}
