<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Job;
use App\Models\JobApplication;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class JobApplicationController extends Controller
{
    public function index()
    {
        $jobs = Job::active()->valid()->ordered()->get();
        return view('jobs.index', compact('jobs'));
    }

    public function show($id)
    {
        $job = Job::active()->valid()->find($id);
        return view('jobs.show', compact('job'));
    }

   
}