<?php

namespace App\Http\Controllers\Admin\Traits;

use App\Models\Product;
use Illuminate\Http\Request;
use App\Models\Invoices;
use DB;
use App\Models\UserMeta;
use App\Models\GeneralSettings;
use App\General\UserClass;
use App\General\GeneralSettingsClass;
use App\Models\User;

trait InvoiceTrait
{
    public function ReviewInvoice($id)
    {
        $GST = config('app.PERCENTAGE') ?? 0;
        $settings = GeneralSettings::get();
        $pos_invoice_note = GeneralSettingsClass::getOptionValue('_pos_invoice_note', $settings);

        # Company Details
        $company_logo = url('/') . '/' . GeneralSettingsClass::getOptionValue('_header_logo', $settings);
        $company = GeneralSettingsClass::getOptionValue('_b_name', $settings);
        $company_address = GeneralSettingsClass::getOptionValue('_b_street_address', $settings);
        $company_state_country = GeneralSettingsClass::getOptionValue('_b_area_address', $settings);
        $company_email = GeneralSettingsClass::getOptionValue('_b_email', $settings);
        $company_phone = GeneralSettingsClass::getOptionValue('_b_number', $settings);
        $abn = GeneralSettingsClass::getOptionValue('_abn', $settings);
        $bankDetails = GeneralSettingsClass::getOptionValue('_bank_details', $settings);
        $bsb = GeneralSettingsClass::getOptionValue('_bsb', $settings);
        $acc = GeneralSettingsClass::getOptionValue('_acc', $settings);
        $bankName = GeneralSettingsClass::getOptionValue('_bank_name', $settings);

        $invoice = Invoices::find($id);
        if ($invoice) {
            $customer_details = "";
            if ($invoice->customer_type == "existing") {
                // Get all user meta for the customer
                $UserMeta = UserMeta::where('user_id', $invoice->customer)->get()->keyBy('option');
                $user = User::find($invoice->customer);
            
                // Get values from user meta or fallback to user table
                $b_name = $UserMeta['_b_name']->value ?? $user->name ?? 'N/A';
                $street_address = $UserMeta['_b_street_address']->value ?? 'N/A';
                $area_address = $UserMeta['_b_area_address']->value ?? 'N/A';
                $email = $UserMeta['_b_email']->value ?? $user->email ?? 'N/A';
                $phone = $UserMeta['_b_number']->value ?? $user->phone ?? 'N/A';
                
                // Build the HTML block
                $customer_details = '<strong>' . $b_name . '</strong><br>' .
                                    $street_address . '<br>' .
                                    $area_address . '<br>' .
                                    '<abbr title="Email">E:</abbr> ' . $email . '<br>' .
                                    '<abbr title="Phone">P:</abbr> ' . $phone;
            } 
            else if ($invoice->customer_type == "random") {
                $customer_details = "<strong>" . $invoice->customer . "</strong>";
            }

            $invoice_items = "";
            $i = 1;
            foreach ($invoice->invoiceMeta as $invoice_item) {
                $product = Product::find($invoice_item->product_id);
                if ($product) {
                    $product_sku = $product->sku;
                } else {
                    $product_sku = 'N/A';
                }
                
                $total_sale_price = $invoice_item->unit_price * $invoice_item->units;
                $invoice_items = $invoice_items . '<tr>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $i . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $invoice_item->product_name . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee;">' . $product_sku . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: center;">' . $invoice_item->units . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $invoice_item->unit_price . '</td>
                                    <td style="padding: 8px; border-bottom: 1px solid #eee; text-align: right;">$' . $invoice_item->unit_total_price . '</td>
                                </tr>';
                $i++;
            }

            $invoice_template = <<<INVOICE
                <div style="max-width: 800px; margin: 0 auto; padding: 20px; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333; background-color: #fff;">
                    <div style="text-align: center; margin-bottom: 20px;">
                        <img src="$company_logo" style="max-width: 180px; height: auto;" alt="logo">
                    </div>
                    
                    <div style="border-bottom: 2px solid #ed1c24; padding-bottom: 10px; margin-bottom: 20px;">
                        <h2 style="color: #ed1c24; margin: 0;">INVOICE <span style="float: right; font-size: 16px;">#$invoice->invoice_number</span></h2>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
                        <div style="width: 48%;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">From:</h4>
                            <div style="line-height: 1.5;">
                                <strong>$company</strong><br>
                                $company_address<br>
                                $company_state_country<br>
                                <span style="display: inline-block; margin-right: 10px;"><strong>E:</strong> $company_email</span><br>
                                <span><strong>P:</strong> $company_phone</span>
                            </div>
                            <div style="margin-top: 10px;">
                                <span><strong>ABN:</strong> $abn</span><br>
                                <span><strong>Bank:</strong> $bankName</span><br>
                                <span><strong>BSB:</strong> $bsb</span><br>
                                <span><strong>Account:</strong> $acc</span>
                            </div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">To:</h4>
                            <div style="line-height: 1.5;">
                                $customer_details
                            </div>
                        </div>
                    </div>
                    
                    <div style="display: flex; justify-content: space-between; margin-bottom: 20px; background-color: #f9f9f9; padding: 15px; border-radius: 5px;">
                        <div style="width: 48%;">
                            <div><strong>Payment Method:</strong> $invoice->payment_method</div>
                            <div><strong>Payment Status:</strong> $invoice->payment_status</div>
                        </div>
                        <div style="width: 48%; text-align: right;">
                            <div><strong>Invoice Date:</strong> $invoice->invoice_date</div>
                            <div><strong>Due Date:</strong> $invoice->due_date</div>
                        </div>
                    </div>
                    
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px;">
                        <thead>
                            <tr style="background-color: #ed1c24; color: white;">
                                <th style="padding: 10px; text-align: left;">#</th>
                                <th style="padding: 10px; text-align: left;">Description</th>
                                <th style="padding: 10px; text-align: left;">SKU</th>
                                <th style="padding: 10px; text-align: center;">Quantity</th>
                                <th style="padding: 10px; text-align: right;">Unit Cost</th>
                                <th style="padding: 10px; text-align: right;">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            $invoice_items
                        </tbody>
                    </table>
                    
                    <div style="display: flex; justify-content: space-between;">
                        <div style="width: 48%; padding-right: 20px;">
                            <h4 style="margin: 0 0 8px; color: #ed1c24;">Notes</h4>
                            <div style="background-color: #f9f9f9; padding: 10px; border-radius: 5px; min-height: 100px;">
                                <p style="margin: 0 0 5px;">$invoice->payment_id</p>
                                <p style="margin: 0;">$pos_invoice_note</p>
                            </div>
                            <div style="margin-top: 15px;">
                                <p style="margin: 0 0 5px;"><strong>Bank Details:</strong> $bankDetails</p>
                            </div>
                        </div>
                        <div style="width: 48%; border-left: 1px solid #eee; padding-left: 20px;">
                            <table style="width: 100%; border-collapse: collapse;">
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Sub - Total amount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice->sub_total</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">General Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->discount%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Discounted Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice->discounted_amount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Additional Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice->additional_discount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$invoice->membership_discount_percentage%</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discount Amount:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice->membership_dicount</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left;">Membership Discounted Total:</td>
                                    <td style="padding: 5px 0; text-align: right;">$$invoice->membership_dicounted_total</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0; text-align: left; color: #777; font-size: 12px;">GST ($GST%):</td>
                                    <td style="padding: 5px 0; text-align: right; color: #777; font-size: 12px;">$$invoice->gst</td>
                                </tr>
                            </table>
                            <div style="margin-top: 15px; padding-top: 15px; border-top: 2px solid #ed1c24;">
                                <div style="display: flex; justify-content: space-between; align-items: center;">
                                    <strong style="font-size: 16px;">Grand Total:</strong>
                                    <span style="font-size: 22px; color: #ed1c24; font-weight: bold;">$$invoice->grand_total</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div style="margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; text-align: center; font-size: 12px; color: #777;">
                        <p style="margin: 0;">Thank you for your business!</p>
                        <p style="margin: 5px 0 0;">This invoice was automatically generated by $company © $invoice->invoice_date</p>
                    </div>
                </div>
INVOICE;
            return $invoice_template;
        }
    }
}