<?php

namespace App\Models;
use App\Models\ChildCategory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'title',
        'sku',
        'description',
        'image',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    public function childCategories()
    {
        return $this->hasMany(ChildCategory::class, 'main_parent_category', 'id');
    }

    public function categoryMeta()
    {
        return $this->hasMany(CategoryMeta::class);
    }

  

    // Scope for active categories
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Scope for ordering
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    // Get next sort order for new categories
    public static function getNextSortOrder()
    {
        $lastCategory = self::orderBy('sort_order', 'desc')->first();
        return $lastCategory ? $lastCategory->sort_order + 1 : 1;
    }
}
