<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PropertyDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'property_id',
        'flights_of_stairs',
        'access_required',
        'lift_booking_info',
        'internal_levels',
        'levels_in_house',
        'truck_parking',
        'storage_name',
        'storage_units',
        'walk_distance',
        'comments',
        'property_type',
        'property_category',
        'commercial_property_type'
    ];

    protected $casts = [
        'flights_of_stairs' => 'string',
        'access_required' => 'string',
        'internal_levels' => 'string',
        'levels_in_house' => 'string',
        'truck_parking' => 'string',
        'walk_distance' => 'string',
    ];

    // Relationships
    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    // Scopes
    public function scopeWithStairs($query)
    {
        return $query->whereIn('flights_of_stairs', ['1 Flight', '2 Flights', '3+ Flights']);
    }

    public function scopeWithLiftAccess($query)
    {
        return $query->where('access_required', 'Yes - A Lift');
    }

    public function scopeWithDrivewayParking($query)
    {
        return $query->where('truck_parking', 'Driveway');
    }

    public function scopeStorageProperties($query)
    {
        return $query->whereNotNull('storage_name');
    }

    // Accessors
    public function getHasStairsAttribute()
    {
        return in_array($this->flights_of_stairs, ['1 Flight', '2 Flights', '3+ Flights']);
    }

    public function getHasLiftAttribute()
    {
        return $this->access_required === 'Yes - A Lift';
    }

    public function getIsStorageAttribute()
    {
        return !empty($this->storage_name);
    }
}