<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Australian Zip Codes by City/State
    |--------------------------------------------------------------------------
    |
    | This configuration contains zip codes organized by Australian cities
    | and states. Used for location-based services and job type determination.
    |
    */

    'sydney' => [
        2000, 2006, 2007, 2008, 2009, 2010, 2011, 2015, 2016, 2017, 2018, 2019, 2020,
        2021, 2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031, 2032, 2033,
        2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046,
        2047, 2048, 2049, 2050, 2052, 2055, 2060, 2061, 2062, 2063, 2064, 2065, 2066,
        2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076, 2077, 2079, 2080,
        2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 2090, 2091, 2092, 2093,
        2094, 2095, 2096, 2097, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 2106, 2107,
        2108, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121,
        2122, 2125, 2126, 2127, 2128, 2130, 2131, 2132, 2133, 2134, 2135, 2136, 2137,
        2138, 2140, 2141, 2142, 2143, 2144, 2145, 2146, 2147, 2148, 2150, 2151, 2152,
        2153, 2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161, 2162, 2163, 2164, 2165,
        2166, 2167, 2168, 2170, 2171, 2173, 2174, 2175, 2176, 2177, 2178, 2179, 2190,
        2191, 2192, 2193, 2194, 2195, 2196, 2197, 2198, 2199, 2200, 2203, 2204, 2205,
        2206, 2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214, 2216, 2217, 2218, 2219,
        2220, 2221, 2222, 2223, 2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232,
        2233, 2234, 2557, 2558, 2559, 2560, 2563, 2564, 2565, 2566, 2567, 2568, 2569,
        2570, 2571, 2572, 2745, 2747, 2748, 2749, 2750, 2751, 2752, 2753, 2754, 2755,
        2756, 2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 2765, 2766, 2767, 2768,
        2769, 2770, 2773, 2774, 2775, 2776, 2777, 2778, 2779, 2780, 2782, 2783, 2784,
        2785, 2786,
    ],

    'melbourne' => [
        3000, 3001, 3002, 3003, 3004, 3005, 3006, 3008, 3010, 3011, 3012, 3013, 3015,
        3016, 3018, 3019, 3020, 3021, 3022, 3023, 3024, 3025, 3026, 3027, 3028, 3029,
        3030, 3031, 3032, 3033, 3034, 3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043,
        3044, 3045, 3046, 3047, 3048, 3049, 3050, 3051, 3052, 3053, 3054, 3055, 3056,
        3057, 3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065, 3066, 3067, 3068, 3070,
        3071, 3072, 3073, 3074, 3075, 3076, 3078, 3079, 3081, 3082, 3083, 3084, 3085,
        3086, 3087, 3088, 3089, 3090, 3091, 3093, 3094, 3095, 3096, 3097, 3099, 3101,
        3102, 3103, 3104, 3105, 3106, 3107, 3108, 3109, 3110, 3111, 3113, 3114, 3115,
        3116, 3121, 3122, 3123, 3124, 3125, 3126, 3127, 3128, 3129, 3130, 3131, 3132,
        3133, 3134, 3135, 3136, 3137, 3138, 3139, 3140, 3141, 3142, 3143, 3144, 3145,
        3146, 3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 3155, 3156, 3158, 3159,
        3160, 3161, 3162, 3163, 3164, 3165, 3166, 3167, 3168, 3169, 3170, 3171, 3172,
        3173, 3174, 3175, 3176, 3177, 3178, 3179, 3180, 3181, 3182, 3183, 3184, 3185,
        3186, 3187, 3188, 3189, 3190, 3191, 3192, 3193, 3194, 3195, 3196, 3197, 3198,
        3199, 3200, 3201, 3202, 3204, 3205, 3206, 3207, 3211, 3212, 3214, 3215, 3216,
        3217, 3218, 3219, 3220, 3221, 3222, 3223, 3224, 3225, 3226, 3227, 3228, 3230,
        3231, 3232, 3233, 3234, 3235, 3236, 3237, 3238, 3239, 3240, 3241, 3242, 3243,
        3249, 3250, 3251, 3254, 3260, 3264, 3265, 3266, 3267, 3268, 3269, 3270, 3271,
        3272, 3273, 3274, 3275, 3276, 3277, 3278, 3279, 3280, 3281, 3282, 3283, 3284,
        3285, 3286, 3287, 3289, 3290, 3291, 3292, 3293, 3294, 3300, 3301, 3302, 3303,
        3304, 3305, 3309, 3310, 3311, 3312, 3314, 3315, 3317, 3318, 3319, 3321, 3322,
        3323, 3324, 3325, 3328, 3329, 3330, 3331, 3332, 3333, 3334, 3335, 3337, 3338,
        3340, 3341, 3342, 3345, 3350, 3351, 3352, 3355, 3356, 3357, 3360, 3361, 3363,
        3364, 3370, 3371, 3373, 3375, 3377, 3379, 3380, 3381, 3384, 3385, 3387, 3388,
        3390, 3391, 3392, 3393, 3395, 3396, 3400, 3401, 3407, 3409, 3412, 3413, 3414,
        3415, 3418, 3419, 3420, 3423, 3424, 3427, 3428, 3429, 3430, 3431, 3432, 3433,
        3434, 3435, 3437, 3438, 3440, 3441, 3442, 3444, 3446, 3447, 3448, 3450, 3451,
        3453, 3458, 3460, 3461, 3462, 3463, 3464, 3465, 3467, 3468, 3469, 3472, 3475,
        3477, 3478, 3480, 3482, 3483, 3485, 3487, 3488, 3489, 3490, 3491, 3494, 3496,
        3498, 3500, 3501, 3505, 3506, 3507, 3509, 3512, 3515, 3516, 3517, 3518, 3520,
        3521, 3522, 3523, 3525, 3527, 3529, 3530, 3531, 3533, 3537, 3540, 3542, 3544,
        3546, 3549, 3550, 3551, 3552, 3554, 3555, 3556, 3557, 3558, 3559, 3561, 3562,
        3563, 3564, 3565, 3566, 3567, 3568, 3570, 3571, 3572, 3573, 3575, 3576, 3579,
        3580, 3581, 3583, 3584, 3585, 3586, 3588, 3589, 3590, 3591, 3594, 3595, 3596,
        3597, 3599, 3607, 3608, 3610, 3612, 3614, 3616, 3617, 3618, 3619, 3620, 3621,
        3622, 3623, 3624, 3629, 3630, 3631, 3632, 3633, 3634, 3635, 3636, 3637, 3638,
        3639, 3640, 3641, 3644, 3646, 3647, 3649, 3658, 3659, 3660, 3662, 3663, 3664,
        3665, 3666, 3669, 3670, 3671, 3672, 3673, 3675, 3676, 3677, 3678, 3682, 3683,
        3685, 3687, 3688, 3689, 3690, 3691, 3694, 3695, 3697, 3698, 3699, 3700, 3701,
        3704, 3705, 3707, 3708, 3709, 3711, 3712, 3713, 3714, 3715, 3717, 3718, 3719,
        3720, 3722, 3723, 3725, 3726, 3727, 3728, 3730, 3732, 3733, 3735, 3736, 3737,
        3738, 3739, 3740, 3741, 3744, 3746, 3747, 3749, 3750, 3751, 3752, 3753, 3754,
        3755, 3756, 3757, 3758, 3759, 3760, 3761, 3762, 3763, 3764, 3765, 3766, 3767,
        3770, 3775, 3777, 3778, 3779, 3781, 3782, 3783, 3785, 3786, 3787, 3788, 3789,
        3791, 3792, 3793, 3795, 3796, 3797, 3799, 3800, 3802, 3803, 3804, 3805, 3806,
        3807, 3808, 3809, 3810, 3812, 3813, 3814, 3815, 3816, 3818, 3820, 3821, 3822,
        3823, 3824, 3825, 3830, 3831, 3832, 3833, 3835, 3840, 3841, 3842, 3844, 3847,
        3850, 3851, 3852, 3854, 3856, 3857, 3858, 3859, 3860, 3862, 3864, 3865, 3869,
        3870, 3871, 3873, 3874, 3875, 3878, 3880, 3882, 3885, 3886, 3887, 3888, 3889,
        3890, 3891, 3892, 3893, 3895, 3896, 3898, 3900, 3902, 3903, 3904, 3909, 3910,
        3911, 3912, 3913, 3915, 3916, 3918, 3919, 3920, 3921, 3922, 3923, 3925, 3926,
        3927, 3928, 3929, 3930, 3931, 3933, 3934, 3936, 3937, 3938, 3939, 3940, 3941,
        3942, 3943, 3944, 3945, 3946, 3950, 3951, 3953, 3954, 3956, 3957, 3958, 3959,
        3960, 3962, 3964, 3965, 3966, 3967, 3971, 3975, 3976, 3977, 3978, 3979, 3980,
        3981, 3984, 3987, 3988, 3990, 3991, 3992, 3995, 3996,
    ],

    'brisbane' => [
        4000, 4001, 4002, 4003, 4004, 4005, 4006, 4007, 4008, 4009, 4010, 4011, 4012,
        4013, 4014, 4017, 4018, 4019, 4020, 4021, 4022, 4025, 4029, 4030, 4031, 4032,
        4034, 4035, 4036, 4037, 4051, 4053, 4054, 4055, 4059, 4060, 4061, 4064, 4065,
        4066, 4067, 4068, 4069, 4070, 4072, 4073, 4074, 4075, 4076, 4077, 4078, 4101,
        4102, 4103, 4104, 4105, 4106, 4107, 4108, 4109, 4110, 4111, 4112, 4113, 4114,
        4115, 4116, 4117, 4118, 4119, 4120, 4121, 4122, 4123, 4124, 4125, 4127, 4128,
        4129, 4130, 4131, 4132, 4133, 4151, 4152, 4153, 4154, 4155, 4156, 4157, 4158,
        4159, 4160, 4161, 4163, 4164, 4165, 4169, 4170, 4171, 4172, 4173, 4174, 4178,
        4179, 4183, 4184, 4205, 4207, 4208, 4209, 4210, 4211, 4212, 4213, 4214, 4215,
        4216, 4217, 4218, 4220, 4221, 4223, 4224, 4225, 4226, 4227, 4228, 4230, 4270,
        4271, 4272, 4275, 4280, 4285, 4287, 4300, 4301, 4303, 4304, 4305, 4306, 4307,
        4309, 4310, 4311, 4312, 4313, 4340, 4341, 4342, 4343, 4344, 4346, 4347, 4350,
        4352, 4353, 4354, 4355, 4356, 4357, 4358, 4359, 4360, 4361, 4362, 4363, 4364,
        4365, 4370, 4371, 4372, 4373, 4374, 4375, 4376, 4377, 4378, 4380, 4381, 4382,
        4383, 4384, 4385, 4387, 4388, 4390, 4400, 4401, 4402, 4403, 4404, 4405, 4406,
        4407, 4408, 4410, 4411, 4412, 4413, 4415, 4416, 4417, 4418, 4419, 4420, 4421,
        4422, 4423, 4424, 4425, 4426, 4427, 4428, 4454, 4455, 4461, 4462, 4465, 4467,
        4468, 4470, 4472, 4474, 4475, 4477, 4478, 4479, 4480, 4481, 4482, 4486, 4487,
        4488, 4489, 4490, 4491, 4492, 4493, 4494, 4496, 4497, 4498, 4500, 4501, 4502,
        4503, 4504, 4505, 4506, 4507, 4508, 4509, 4510, 4511, 4512, 4514, 4515, 4516,
        4517, 4518, 4519, 4520, 4521, 4550, 4551, 4552, 4553, 4554, 4555, 4556, 4557,
        4558, 4559, 4560, 4561, 4562, 4563, 4564, 4565, 4566, 4567, 4568, 4569, 4570,
        4571, 4572, 4573, 4574, 4575, 4580, 4581, 4600, 4601, 4605, 4606, 4608, 4610,
        4611, 4612, 4613, 4614, 4615, 4620, 4621, 4625, 4626, 4627, 4630, 4650, 4655,
        4659, 4660, 4662, 4670, 4671, 4673, 4674, 4676, 4677, 4678, 4680, 4694, 4695,
        4697, 4699, 4700, 4701, 4702, 4703, 4704, 4705, 4706, 4707, 4709, 4710, 4711,
        4712, 4713, 4714, 4715, 4716, 4717, 4718, 4719, 4720, 4721, 4722, 4723, 4724,
        4725, 4726, 4727, 4728, 4730, 4731, 4732, 4733, 4735, 4736, 4737, 4738, 4739,
        4740, 4741, 4742, 4743, 4744, 4745, 4746, 4750, 4751, 4753, 4754, 4756, 4757,
        4798, 4799,
    ],

    'perth' => [
        6000, 6001, 6003, 6004, 6005, 6006, 6007, 6008, 6009, 6010, 6011, 6012, 6014,
        6015, 6016, 6017, 6018, 6019, 6020, 6021, 6022, 6023, 6024, 6025, 6026, 6027,
        6028, 6029, 6030, 6031, 6032, 6033, 6034, 6035, 6036, 6037, 6038, 6041, 6042,
        6043, 6044, 6050, 6051, 6052, 6053, 6054, 6055, 6056, 6057, 6058, 6059, 6060,
        6061, 6062, 6063, 6064, 6065, 6066, 6067, 6068, 6069, 6070, 6071, 6072, 6073,
        6074, 6076, 6077, 6078, 6079, 6081, 6082, 6083, 6084, 6085, 6090, 6100, 6101,
        6102, 6103, 6104, 6105, 6106, 6107, 6108, 6109, 6110, 6111, 6112, 6121, 6122,
        6123, 6124, 6125, 6126, 6147, 6148, 6149, 6150, 6151, 6152, 6153, 6154, 6155,
        6156, 6157, 6158, 6159, 6160, 6161, 6162, 6163, 6164, 6165, 6166, 6167, 6168,
        6169, 6170, 6171, 6172, 6173, 6174, 6175, 6176, 6207, 6208, 6209, 6210, 6211,
        6213, 6214, 6215, 6218, 6220, 6221, 6223, 6224, 6225, 6226, 6227, 6228, 6229,
        6230, 6232, 6233, 6236, 6237, 6239, 6240, 6243, 6244, 6251, 6252, 6253, 6254,
        6255, 6256, 6258, 6260, 6262, 6271, 6275, 6280, 6281, 6282, 6284, 6285, 6286,
        6288, 6290, 6302, 6304, 6306, 6308, 6309, 6311, 6312, 6313, 6315, 6316, 6317,
        6318, 6320, 6321, 6322, 6323, 6324, 6326, 6327, 6328, 6330, 6333, 6335, 6336,
        6337, 6338, 6341, 6343, 6346, 6348, 6350, 6351, 6352, 6353, 6355, 6356, 6357,
        6358, 6359, 6361, 6363, 6365, 6367, 6368, 6369, 6370, 6372, 6373, 6375, 6383,
        6384, 6385, 6386, 6390, 6391, 6392, 6393, 6394, 6395, 6396, 6397, 6398, 6401,
        6403, 6405, 6407, 6409, 6410, 6411, 6412, 6413, 6414, 6415, 6418, 6419, 6420,
        6421, 6422, 6423, 6424, 6425, 6426, 6427, 6428, 6429, 6430, 6431, 6432, 6433,
        6434, 6436, 6437, 6438, 6440, 6442, 6443, 6445, 6446, 6447, 6448, 6450, 6452,
        6460, 6461, 6462, 6463, 6465, 6466, 6467, 6468, 6470, 6472, 6473, 6475, 6476,
        6477, 6479, 6480, 6484, 6485, 6487, 6488, 6489, 6490, 6501, 6502, 6503, 6504,
        6505, 6506, 6507, 6509, 6510, 6511, 6512, 6513, 6514, 6515, 6516, 6517, 6518,
        6519, 6521, 6522, 6525, 6528, 6530, 6532, 6535, 6536, 6537, 6556, 6558, 6560,
        6562, 6564, 6566, 6567, 6568, 6569, 6571, 6572, 6574, 6575, 6603, 6605, 6606,
        6608, 6609, 6612, 6613, 6614, 6616, 6620, 6623, 6625, 6627, 6628, 6630, 6631,
        6632, 6635, 6638, 6639, 6640, 6642, 6646, 6701, 6705, 6707, 6710, 6711, 6712,
        6713, 6714, 6716, 6718, 6720, 6721, 6722, 6725, 6726, 6728, 6731, 6733, 6740,
        6743, 6751, 6753, 6754, 6758, 6760, 6762, 6765, 6770,
    ],

    'adelaide' => [
        5000, 5001, 5002, 5003, 5004, 5005, 5006, 5007, 5008, 5009, 5010, 5011, 5012,
        5013, 5014, 5015, 5016, 5017, 5018, 5019, 5020, 5021, 5022, 5023, 5024, 5025,
        5031, 5032, 5033, 5034, 5035, 5037, 5038, 5039, 5040, 5041, 5042, 5043, 5044,
        5045, 5046, 5047, 5048, 5049, 5050, 5051, 5052, 5061, 5062, 5063, 5064, 5065,
        5066, 5067, 5068, 5069, 5070, 5072, 5073, 5074, 5075, 5076, 5081, 5082, 5083,
        5084, 5085, 5086, 5087, 5088, 5089, 5090, 5091, 5092, 5093, 5094, 5095, 5096,
        5097, 5098, 5106, 5107, 5108, 5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116,
        5117, 5118, 5120, 5121, 5125, 5126, 5127, 5131, 5132, 5133, 5134, 5136, 5137,
        5138, 5139, 5140, 5141, 5142, 5144, 5150, 5151, 5152, 5153, 5154, 5155, 5156,
        5157, 5158, 5159, 5160, 5161, 5162, 5163, 5164, 5165, 5166, 5167, 5168, 5169,
        5170, 5171, 5172, 5173, 5174, 5201, 5202, 5203, 5204, 5210, 5211, 5212, 5213,
        5214, 5220, 5221, 5222, 5223, 5231, 5232, 5233, 5234, 5235, 5236, 5237, 5238,
        5240, 5241, 5242, 5243, 5244, 5245, 5250, 5251, 5252, 5253, 5254, 5255, 5256,
        5260, 5261, 5262, 5263, 5264, 5265, 5266, 5267, 5268, 5269, 5270, 5271, 5272,
        5273, 5275, 5276, 5277, 5278, 5279, 5280, 5290, 5291, 5301, 5302, 5303, 5304,
        5306, 5307, 5308, 5309, 5310, 5311, 5320, 5321, 5322, 5330, 5331, 5332, 5333,
        5340, 5341, 5342, 5343, 5344, 5345, 5346, 5350, 5351, 5352, 5353, 5354, 5355,
        5356, 5357, 5360, 5371, 5372, 5373, 5374, 5381, 5400, 5401, 5410, 5411, 5412,
        5413, 5414, 5415, 5416, 5417, 5418, 5419, 5420, 5421, 5422, 5451, 5452, 5453,
        5454, 5455, 5460, 5461, 5462, 5464, 5470, 5471, 5472, 5473, 5480, 5481, 5482,
        5483, 5485, 5490, 5491, 5493, 5495, 5501, 5502, 5510, 5520, 5521, 5522, 5523,
        5540, 5550, 5552, 5554, 5555, 5556, 5558, 5560, 5570, 5571, 5572, 5573, 5575,
        5576, 5577, 5580, 5581, 5582, 5583, 5600, 5601, 5602, 5603, 5604, 5605, 5606,
        5607, 5608, 5609, 5630, 5631, 5632, 5633, 5640, 5641, 5642, 5650, 5651, 5652,
        5653, 5654, 5655, 5670, 5671, 5680, 5690, 5710, 5713, 5715, 5717, 5719, 5720,
        5722, 5723, 5724, 5725, 5730, 5731, 5732, 5733, 5734,
    ],

    /*
    |--------------------------------------------------------------------------
    | State-based Zip Code Ranges
    |--------------------------------------------------------------------------
    |
    | Zip code ranges by Australian states for easier state-based lookups
    |
    */

    'states' => [
        'NSW' => [
            'cities' => ['sydney'],
            'ranges' => [[2000, 2999], [8000, 8999]],
        ],
        'VIC' => [
            'cities' => ['melbourne'],
            'ranges' => [[3000, 3999]],
        ],
        'QLD' => [
            'cities' => ['brisbane'],
            'ranges' => [[4000, 4999], [9000, 9999]],
        ],
        'WA' => [
            'cities' => ['perth'],
            'ranges' => [[6000, 6799]],
        ],
        'SA' => [
            'cities' => ['adelaide'],
            'ranges' => [[5000, 5999]],
        ],
        'TAS' => [
            'cities' => [],
            'ranges' => [[7000, 7999]],
        ],
        'ACT' => [
            'cities' => [],
            'ranges' => [[200, 299], [2600, 2699]],
        ],
        'NT' => [
            'cities' => [],
            'ranges' => [[800, 899], [900, 999]],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Helper Functions
    |--------------------------------------------------------------------------
    |
    | Use these helper methods to check zip codes:
    | 
    | config('australian_zipcodes.sydney') - Get Sydney zip codes
    | config('australian_zipcodes.states.NSW.cities') - Get NSW cities
    |
    */
];

