<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('faqs', function (Blueprint $table) {
            $table->id();
            $table->string('page_url')->nullable(); // URL where FAQ will be displayed
            $table->string('permalink')->unique(); // SEO-friendly URL slug
            $table->string('title')->nullable(); // FAQ page title
            $table->text('description')->nullable(); // FAQ page description
            $table->integer('sort_order')->default(0); // For ordering FAQ pages
            $table->tinyInteger('status')->default(1); // 0=inactive, 1=active
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes(); // For soft delete functionality
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('faqs');
    }
};