<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('faq_questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('faq_id');
            $table->text('question');
            $table->longText('answer');
            $table->integer('sort_order')->default(0);
            $table->tinyInteger('status')->default(1); // 0=inactive, 1=active
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Foreign key constraint
            $table->foreign('faq_id')->references('id')->on('faqs')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index(['faq_id', 'sort_order']);
            $table->index(['faq_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('faq_questions');
    }
};