<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('property_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('property_id')->constrained('properties')->onDelete('cascade');
            $table->enum('property_type', ['pick_up', 'drop_off'])->nullable();
            $table->enum('property_category', ['House', 'Unit', 'Townhouse', 'Apartment', 'Storage', 'Commercial'])->nullable();
            $table->enum('commercial_property_type', ['office', 'shop/retail', 'industrial', 'warehouse', 'other'])->nullable();
            $table->enum('flights_of_stairs', ['1_flight', '2_flights', '3+_flights', 'N/A'])->nullable();
            $table->enum('access_required', ['no', 'yes_stairs', 'yes_a_lift', 'N/A'])->nullable();
            $table->text('lift_booking_info')->nullable();
            $table->enum('internal_levels', ['yes', 'no', 'N/A'])->nullable();
            $table->enum('levels_in_house', ['single', 'double', 'triple', 'N/A'])->nullable();
            $table->enum('truck_parking', ['driveway', 'street', 'loading_dock'])->nullable();
            
            // Storage-related fields
            $table->string('storage_name')->nullable();
            $table->string('storage_units')->nullable();
            $table->enum('walk_distance', ['less_than_20m', 'more_than_20m', 'I_dont_know', 'N/A'])->nullable();
            $table->text('comments')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index('property_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('property_details');
    }
};