<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('customer_name');
            $table->text('short_description')->nullable();
            $table->longText('long_description')->nullable();
            $table->decimal('rating', 3, 2)->default(0.00); // e.g., 4.50, max 5.00
            $table->string('customer_image')->nullable();
            $table->string('customer_position')->nullable();
            $table->string('company_name')->nullable();
            
            // Status and ordering
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            
            // User tracking
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
