<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('quotes', function (Blueprint $table) {
            $table->string('stripe_customer_id')->nullable()->after('quote_payment_proof');
            $table->string('stripe_payment_intent_deposit_id')->nullable()->after('stripe_customer_id');
            $table->string('stripe_payment_intent_remaining_id')->nullable()->after('stripe_payment_intent_deposit_id');
            $table->decimal('deposit_amount', 10, 2)->nullable()->after('stripe_payment_intent_remaining_id');
            $table->decimal('remaining_amount', 10, 2)->nullable()->after('deposit_amount');
            $table->enum('deposit_payment_status', ['pending', 'processing', 'succeeded', 'failed', 'canceled'])->default('pending')->after('remaining_amount');
            $table->enum('remaining_payment_status', ['pending', 'processing', 'succeeded', 'failed', 'canceled'])->default('pending')->after('deposit_payment_status');
            $table->string('remaining_payment_url')->nullable()->after('remaining_payment_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('quotes', function (Blueprint $table) {
            $table->dropColumn([
                'stripe_customer_id',
                'stripe_payment_intent_deposit_id',
                'stripe_payment_intent_remaining_id',
                'deposit_amount',
                'remaining_amount',
                'deposit_payment_status',
                'remaining_payment_status',
                'remaining_payment_url'
            ]);
        });
    }
};
