<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\ChildCategory;
use Illuminate\Support\Facades\DB;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key checks temporarily
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        
        // Delete all child categories first (due to foreign key constraint)
        DB::table('child_categories')->truncate();
        
        // Delete all categories
        DB::table('categories')->truncate();
        
        // Re-enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Define main categories
        $categories = [
            [
                'title' => 'Bedrooms',
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'title' => 'Living / Family Rooms',
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'title' => 'Dining Room / Meals Area',
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'title' => 'Kitchen',
                'sort_order' => 4,
                'is_active' => true,
            ],
            [
                'title' => 'Laundry',
                'sort_order' => 5,
                'is_active' => true,
            ],
            [
                'title' => 'Study / Office',
                'sort_order' => 6,
                'is_active' => true,
            ],
            [
                'title' => 'Hall / Entry',
                'sort_order' => 7,
                'is_active' => true,
            ],
            [
                'title' => 'Outdoor / Garden',
                'sort_order' => 8,
                'is_active' => true,
            ],
            [
                'title' => 'Garage / Shed',
                'sort_order' => 9,
                'is_active' => true,
            ],
            [
                'title' => 'Fitness / Gym Equipment',
                'sort_order' => 10,
                'is_active' => true,
            ],
            [
                'title' => 'Boxes / Storage',
                'sort_order' => 11,
                'is_active' => true,
            ],
        ];

        // Create main categories and store their IDs
        $categoryIds = [];
        foreach ($categories as $categoryData) {
            $category = Category::create($categoryData);
            $categoryIds[$category->title] = $category->id;
        }

        // Define child categories with their parent category titles
        $childCategories = [
            'Bedrooms' => [
                ['title' => 'Bed King & Mattress', 'volumn' => 2.0],
                ['title' => 'Bed Double & Mattress', 'volumn' => 1.2],
                ['title' => 'Bed Queen & Mattress', 'volumn' => 1.4],
                ['title' => 'Bed Single & Mattress', 'volumn' => 0.6],
                ['title' => 'Bassinette', 'volumn' => 0.25],
                ['title' => 'Bed - Water', 'volumn' => 2.0],
                ['title' => 'Bunks', 'volumn' => 1.24],
                ['title' => 'Bedside Table / Chest', 'volumn' => 0.25],
                ['title' => 'Chair', 'volumn' => 0.15],
                ['title' => 'Bookcase', 'volumn' => 1.0],
                ['title' => 'Change Table', 'volumn' => 0.8],
                ['title' => 'Chest of Drawers', 'volumn' => 0.5],
                ['title' => 'Cot - Collapsible / Rigid', 'volumn' => 0.5],
                ['title' => 'Cupboard', 'volumn' => 1.0],
                ['title' => 'Dressing Table', 'volumn' => 1.0],
                ['title' => 'Headboard', 'volumn' => 0.3],
                ['title' => 'Large Toys', 'volumn' => 0.8],
                ['title' => 'Mirror', 'volumn' => 0.05],
                ['title' => 'Play Pen', 'volumn' => 2.2],
                ['title' => 'Pram', 'volumn' => 1.2],
                ['title' => 'Stool', 'volumn' => 0.15],
                ['title' => 'Stroller', 'volumn' => 1.2],
                ['title' => 'Suitcase', 'volumn' => 0.2],
                ['title' => 'Table Lamp', 'volumn' => 0.14],
                ['title' => 'Toy Box', 'volumn' => 0.4],
                ['title' => 'Wardrobe (Large)', 'volumn' => 2.0],
                ['title' => 'Wardrobe (Small)', 'volumn' => 1.5],
                ['title' => 'Bean Bag', 'volumn' => 0.4],
                ['title' => 'Rocking Horse', 'volumn' => 0.3],
                ['title' => 'Doll Pram', 'volumn' => 0.15],
            ],
            'Living / Family Rooms' => [
                ['title' => 'Air Conditioner', 'volumn' => 0.25],
                ['title' => 'Bookcase Lounge', 'volumn' => 1.5],
                ['title' => 'Coffee Tables', 'volumn' => 0.28],
                ['title' => 'Electric Organ', 'volumn' => 1.0],
                ['title' => 'Lounge Chair', 'volumn' => 0.48],
                ['title' => 'Lounge Modular', 'volumn' => 3.5],
                ['title' => 'Lounge 2 Seater', 'volumn' => 1.7],
                ['title' => 'Lounge 3 Seater', 'volumn' => 2.2],
                ['title' => 'Firescreen & Fire Set', 'volumn' => 0.1],
                ['title' => 'Heater', 'volumn' => 0.1],
                ['title' => 'Nest of Tables', 'volumn' => 0.5],
                ['title' => 'Ottoman / Pouffe', 'volumn' => 0.2],
                ['title' => 'Piano Upright / Grand', 'volumn' => 1.0],
                ['title' => 'Piano Stool', 'volumn' => 0.15],
                ['title' => 'Pool Table', 'volumn' => 2.4],
                ['title' => 'Rocker / Recliner Chair', 'volumn' => 0.9],
                ['title' => 'Standard Lamp', 'volumn' => 0.14],
                ['title' => 'Stereo & Speakers', 'volumn' => 0.4],
                ['title' => 'Carpets & Rugs', 'volumn' => 0.15],
                ['title' => 'Aquarium', 'volumn' => 1.0],
                ['title' => 'Television', 'volumn' => 0.4],
                ['title' => 'TV / Stereo Cabinet', 'volumn' => 0.8],
                ['title' => 'Video', 'volumn' => 0.1],
                ['title' => 'Wall Unit Large / Small', 'volumn' => 2.0],
            ],
            'Dining Room / Meals Area' => [
                ['title' => 'Buffet', 'volumn' => 0.8],
                ['title' => 'Bar or Crystal Cabinet', 'volumn' => 1.0],
                ['title' => 'China Cabinet', 'volumn' => 2.0],
                ['title' => 'Cocktail Cabinet', 'volumn' => 0.8],
                ['title' => 'Bookcase', 'volumn' => 1.0],
                ['title' => 'Chairs', 'volumn' => 0.15],
                ['title' => 'Table', 'volumn' => 2.0],
                ['title' => 'Traymobile', 'volumn' => 0.2],
                ['title' => 'Cabinet', 'volumn' => 0.85],
            ],
            'Kitchen' => [
                ['title' => 'Dishwasher', 'volumn' => 0.5],
                ['title' => 'Cupboard', 'volumn' => 1.0],
                ['title' => 'Freezer', 'volumn' => 1.0],
                ['title' => 'High Chair', 'volumn' => 0.15],
                ['title' => 'Kitchen Tidy', 'volumn' => 0.2],
                ['title' => 'Microwave', 'volumn' => 0.15],
                ['title' => 'Refrigerator', 'volumn' => 1.0],
                ['title' => 'Table', 'volumn' => 0.98],
                ['title' => 'Stool', 'volumn' => 0.15],
            ],
            'Laundry' => [
                ['title' => 'Baby Bath', 'volumn' => 0.1],
                ['title' => 'Clothes Basket', 'volumn' => 0.1],
                ['title' => 'Clothes Horse / Airer', 'volumn' => 0.05],
                ['title' => 'Cupboard', 'volumn' => 0.8],
                ['title' => 'Drier Tumble / Cabinet', 'volumn' => 0.5],
                ['title' => 'Ironing Board', 'volumn' => 0.1],
                ['title' => 'Laundry Trolley', 'volumn' => 0.1],
                ['title' => 'Sewing Machine', 'volumn' => 0.6],
                ['title' => 'Stool', 'volumn' => 0.5],
                ['title' => 'Vacuum Cleaner', 'volumn' => 0.2],
                ['title' => 'Brooms, Mops etc', 'volumn' => 0.15],
                ['title' => 'Washing Machine', 'volumn' => 0.5],
            ],
            'Study / Office' => [
                ['title' => 'Computer', 'volumn' => 0.28],
                ['title' => 'Desk', 'volumn' => 1.0],
                ['title' => 'Desk Lounge', 'volumn' => 1.0],
                ['title' => 'Filing Cabinet', 'volumn' => 0.85],
                ['title' => 'Roll Top Desk', 'volumn' => 1.0],
            ],
            'Hall / Entry' => [
                ['title' => 'Hall Stand / Table', 'volumn' => 0.28],
                ['title' => 'Hat Rack / Stand', 'volumn' => 0.14],
                ['title' => 'Grand Father Clock', 'volumn' => 0.5],
                ['title' => 'Pictures / Mirror', 'volumn' => 0.28],
                ['title' => 'Telephone Table', 'volumn' => 0.15],
            ],
            'Outdoor / Garden' => [
                ['title' => 'Barbeque', 'volumn' => 1.0],
                ['title' => 'Beach Umbrella', 'volumn' => 0.3],
                ['title' => 'Card Table', 'volumn' => 1.0],
                ['title' => 'Chairs', 'volumn' => 0.14],
                ['title' => "Child's Table & Chairs", 'volumn' => 0.3],
                ['title' => 'Esky', 'volumn' => 0.1],
                ['title' => 'Folding Chair / Lounge', 'volumn' => 0.1],
                ['title' => 'Garbage Bin', 'volumn' => 0.2],
                ['title' => 'Garden Seat', 'volumn' => 1.0],
                ['title' => 'Garden Tools & Hose', 'volumn' => 0.21],
                ['title' => 'Outdoor Setting', 'volumn' => 2.0],
                ['title' => 'Tricycle', 'volumn' => 0.5],
                ['title' => 'Wading Pool', 'volumn' => 0.1],
                ['title' => 'Small Pot Plant', 'volumn' => 1.0],
                ['title' => 'Large Pot Plant', 'volumn' => 1.0],
            ],
            'Garage / Shed' => [
                ['title' => 'Lawn Mower', 'volumn' => 0.3],
                ['title' => 'Ladder', 'volumn' => 0.4],
                ['title' => 'Tool Box', 'volumn' => 0.4],
                ['title' => 'Tool Cupboard', 'volumn' => 0.85],
                ['title' => 'Wheel Barrow', 'volumn' => 0.58],
                ['title' => 'Work Bench', 'volumn' => 1.0],
            ],
            'Fitness / Gym Equipment' => [
                ['title' => 'Bicycle', 'volumn' => 0.4],
                ['title' => 'Golf Bag & Buggy', 'volumn' => 0.2],
                ['title' => 'Swing (Dismantled)', 'volumn' => 1.0],
                ['title' => 'Trampoline (Dismantled)', 'volumn' => 1.0],
            ],
            'Boxes / Storage' => [
                ['title' => 'Removalist Cartons', 'volumn' => 0.15],
                ['title' => 'Book Boxes', 'volumn' => 0.125],
                ['title' => 'Picture Boxes', 'volumn' => 0.1],
                ['title' => 'Portarobes', 'volumn' => 0.3],
                ['title' => 'Striped Bags', 'volumn' => 0.125],
            ],
        ];

        // Create child categories
        $sortOrder = 1;
        foreach ($childCategories as $parentCategoryTitle => $childItems) {
            $parentCategoryId = $categoryIds[$parentCategoryTitle];
            
            foreach ($childItems as $childItem) {
                ChildCategory::create([
                    'main_parent_category' => $parentCategoryId,
                    'title' => $childItem['title'],
                    'volumn' => $childItem['volumn'],
                    'is_active' => true,
                    'sort_order' => $sortOrder++,
                ]);
            }
        }

        $this->command->info('Categories and child categories seeded successfully!');
        $this->command->info('Created ' . count($categories) . ' main categories');
        $this->command->info('Created ' . array_sum(array_map('count', $childCategories)) . ' child categories');
    }
}

