@php
    use App\General\GeneralSettingsClass;
@endphp
@include('Admin.Includes.links')

<div class="container-fluid p-0">
    <div class="row g-0">
        <!-- Left side branding panel with background image -->
        <div class="col-md-6 min-vh-100 d-flex flex-column align-items-center justify-content-center text-white position-relative overflow-hidden">
            <!-- Background image with overlay -->
            <div class="position-absolute top-0 start-0 w-100 h-100" 
                 style="background-image: url('{{ asset('/assets/images/login-bg.png') }}'); 
                        background-size: 100% 100%; 
                        background-position: center;
                        background-repeat: no-repeat;">
            </div>
            <!-- Dark overlay with brand color -->
            <div class="position-absolute top-0 start-0 w-100 h-100" 
                 style="background: linear-gradient(135deg, rgba(0,0,0,0.6) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0.7) 100%);">
            </div>
            
            <div class="logo mb-4 position-relative z-1">
                <img src="{{ url('/') . '/' . GeneralSettingsClass::getRequiredValue('_header_logo') }}" 
                     alt="Speedy Move" style="max-width: 100%; filter: drop-shadow(0 4px 15px rgba(0,0,0,0.5));">
            </div>
            
            <div class="heading mb-3 position-relative z-1">
                <h3 class="fw-bold text-white" style="text-shadow: 2px 2px 4px rgba(0,0,0,0.8); font-size: 2rem;">We Care about Quality</h3>
            </div>
            
            <div class="description px-md-5 px-4 text-center position-relative z-1" style="max-width: 500px;">
                <p class="fs-6 text-white" style="text-shadow: 1px 1px 3px rgba(0,0,0,0.8); line-height: 1.6;">
                    At Speedy Move, we prioritize your security and convenience. If you've forgotten your password or need to reset it for security reasons, you're in the right place. Simply enter your new password below, and regain access to your account in seconds. For your safety, choose a strong password that you haven't used before.
                </p>
                <p class="small mt-4 text-white" style="text-shadow: 1px 1px 2px rgba(0,0,0,0.8);">Copyright © 2025 Speedy Move Australia.</p>
            </div>
        </div>

        <!-- Right side reset password form -->
        <div class="col-md-6 d-flex align-items-center justify-content-center py-5" style="background-color: #f8f9fa;">
            <div class="w-100 px-4" style="max-width: 450px;">
                
                <!-- Reset Password Form -->
                <div class="  p-4 p-md-5 rounded-4 shadow">
                    <div class="head mb-5">
                        <h2 class="fw-bold mb-2">Reset Password</h2>
                        <p class="text-muted">Please enter your new password</p>
                    </div>
                    
                    <form id="reset_password_form">
                        @csrf
                        <input type="hidden" name="token" value="{{ request('token') }}">
                        
                        <div class="mb-4">
                            <label for="password" class="form-label fw-medium mb-2">New Password</label>
                            <div class="input-group input-group-lg position-relative">
                                <input type="password" 
                                       class="form-control bg-light border-0 password-field"
                                       id="password" 
                                       placeholder="Enter your new password" 
                                       name="password"
                                       style="height: 60px; border-radius: 12px; padding-right: 50px;">
                                <div class="position-absolute end-0 top-50 translate-middle-y d-flex align-items-center pe-3" style="z-index: 5;">
                                    <button type="button" class="btn border-0 bg-transparent p-1 toggle-password" data-target="password">
                                        <i class="bi bi-eye-slash text-muted fs-5"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-4">
                            <label for="password_confirmation" class="form-label fw-medium mb-2">Confirm New Password</label>
                            <div class="input-group input-group-lg position-relative">
                                <input type="password" 
                                       class="form-control bg-light border-0 password-field"
                                       id="password_confirmation" 
                                       placeholder="Confirm your new password" 
                                       name="password_confirmation"
                                       style="height: 60px; border-radius: 12px; padding-right: 50px;">
                                <div class="position-absolute end-0 top-50 translate-middle-y d-flex align-items-center pe-3" style="z-index: 5;">
                                    <button type="button" class="btn border-0 bg-transparent p-1 toggle-password" data-target="password_confirmation">
                                        <i class="bi bi-eye-slash text-muted fs-5"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-grid mt-5">
                            <button type="submit" class="btn btn-lg py-3 btn-success" 
                                    style=" 
                                           color: white !important;
                                           border-radius: 12px;
                                           box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                                Reset Password
                            </button>
                        </div>
                        
                        <div class="response_section mt-3"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $('#reset_password_form').on('submit', function(e) {
        e.preventDefault();
        $('.response_section').html(`<div class="alert alert-info mt-1">Processing...</div>`);
        var formData = $(this).serialize();
        $.ajax({
            url: "{{ route('Admin.PasswordUpdate.Submit') }}",
            type: "POST",
            data: formData,
            success: function(response) {
                switch (response.status) {
                    case 200:
                        $('.response_section').html(
                            `<div class="alert alert-success mt-1">${response.message} <a href="https://speedy-move-frontend.vercel.app/">Login</a></div>`
                        );
                        $('input[name=password_confirmation], input[name=password]').val('');
                        break;
                    case 404:
                        $('.response_section').html(
                            `<div class="alert alert-warning mt-1">${response.message}</div>`);
                        break;
                    case 500:
                        $('.response_section').html(
                            `<div class="alert alert-danger mt-1">${response.message}</div>`);
                        break;
                }
            },
            error: function(xhr, status, error) {
                // handle error response
                if (xhr.status == 422) {
                    $('.response_section').html(
                        `<div class="alert alert-danger mt-1">Password Fields are not matched!</div>`
                    );
                } else {
                    $('.response_section').html(
                        `<div class="alert alert-danger mt-1">Server Error, Try Again Later!</div>`
                    );
                }
            }
        });
    });

    // Password visibility toggle functionality with eye icons
    document.addEventListener('DOMContentLoaded', function() {
        const toggleBtns = document.querySelectorAll('.toggle-password');
        
        toggleBtns.forEach(function(btn) {
            btn.addEventListener('click', function() {
                const targetId = this.getAttribute('data-target');
                const passwordField = document.getElementById(targetId);
                
                // Toggle password visibility
                const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordField.setAttribute('type', type);
                
                // Toggle eye icon
                const icon = this.querySelector('i');
                icon.classList.toggle('bi-eye');
                icon.classList.toggle('bi-eye-slash');
            });
        });
    });
</script>