@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp


<style>
    .form-check-label {
        font-weight: 500;
        color: #6c757d;
    }

    .form-check-input:checked+.form-check-label {
        color: #198754;
    }
</style>
<div class="page-content">
    <div class="container-fluid">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">

                    <div>
                        <h4 class="mb-1">{{ __('Blog Edit') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('blogs.index') }}" class="link-primary text-decoration-none">
                                        Blog
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Blog Edit
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('blogs.index') }}" class="btn btn-primary global-list-btn">
                            <i class="bi bi-list me-1"></i> Blog List
                        </a>

                    </div>
                </div>
            </div>
        </div>

        <form id="blog-edit-form" method="POST" action="{{ route('blogs.update', $blog->id) }}"
            enctype="multipart/form-data" autocomplete="off" class="needs-validation" novalidate>
            @csrf
            @method('PUT')
            <input type="hidden" name="updated_by" value="{{ $logged_in_user->id }}">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <!-- Blog Details -->
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex">
                                <div class="avatar-sm me-3">
                                    <div class="avatar-title rounded-circle bg-light text-primary fs-20">
                                        <i class="bi bi-file-earmark-text"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="card-title mb-1">Blog Details</h5>
                                    <p class="text-muted mb-0">Enter essential blog information below.</p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Title -->
                            <div class="mb-3">
                                <label class="form-label" for="blog-title-input">Blog Title <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control addTitle" name="title" id="blog-title-input"
                                    placeholder="e.g. How to Use Power Tools Safely"
                                    value="{{ old('title', $blog->title) }}" required>
                                <div class="invalid-feedback">Please enter a blog title.</div>
                            </div>

                            <!-- Permalink -->
                            <div class="form-group mb-3">
                                <label class="form-control-label active">Permalink: <span
                                        class="tx-danger">*</span></label>
                                <div class="input-group">
                                    <div class="input-group-prepend custom-permalink">
                                        <span class="input-group-text">{{ url('/') }}/blog/</span>
                                    </div>
                                    <input class="form-control restrict-input-alphabets permalink" id="permalink"
                                        type="text" name="permalink"
                                        value="{{ old('permalink', $blog->permalink) }}"
                                        placeholder="how-to-use-power-tools-safely" required>
                                </div>
                                <div class="text-danger permalink_error"></div>
                                <input type="hidden" class="permalink_status" name="permalink_status"
                                    value="{{ old('permalink_status') }}" required>
                            </div>

                            <!-- Description -->
                            <div class="mb-3">
                                <label class="form-label">Short Description</label>
                                <textarea name="description" class="form-control" rows="4" placeholder="Short description of the blog post...">{{ old('description', $blog->description) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Blog Categories -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Blog Categories</h5>
                            <small class="text-muted">Organize your blog post by selecting relevant categories.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Categories</label>
                                <select name="blog_category_ids[]" id="blog-categories"
                                    class="form-select select2-multiple" multiple size="5" style="width: 100%">
                                    <option></option> <!-- for placeholder -->
                                    @if (isset($blogCategories))
                                        @foreach ($blogCategories as $category)
                                            <option value="{{ $category->id }}"
                                                {{ in_array($category->id, old('blog_category_ids', $blog->blog_category_ids)) ? 'selected' : '' }}>
                                                {{ $category->title }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                                <small class="text-muted">You can select multiple categories</small>
                            </div>
                        </div>
                    </div>

                       <!-- Main Blog Content Section -->
                       <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Main Blog Content</h5>
                            <small class="text-muted">Add detailed content for your blog post including formatting and
                                media.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Blog Content</label>
                                <textarea name="content" class="form-control rich-editor" rows="15">{{ old('content', $blog->content) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Image Section -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Image Section</h5>
                            <small class="text-muted">Add tagline and description that appear with your featured
                                images.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Image Tagline</label>
                                <input type="text" name="image_tagline" class="form-control"
                                    value="{{ old('image_tagline', $blog->image_tagline) }}"
                                    placeholder="Enter a tagline for your image section">
                                <small class="text-muted">A short tagline or heading for the image section.</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Image</label>
                                @if ($blog->image)
                                    <div class="mb-2">
                                        <img src="{{ asset($blog->image) }}" alt="Current image"
                                            class="img-thumbnail" style="max-width: 100%; max-height: 150px;">
                                        <small class="text-muted d-block">Current image</small>
                                    </div>
                                @endif
                                <input type="file" name="image" class="form-control" accept="image/*"
                                    id="imageInput">
                                <small class="text-muted">Upload an image for your image section.</small>
                                <div id="imagePreview" class="mt-2"></div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Image Alt Text</label>
                                <input type="text" name="image_alt_text" class="form-control"
                                    value="{{ old('image_alt_text', $blog->image_alt_text) }}"
                                    placeholder="Enter a alt text for your image section">
                                <small class="text-muted">A short alt text for your image section.</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Image Description</label>
                                <textarea name="image_description" class="form-control rich-editor" rows="4"
                                    placeholder="Enter description for your image section...">{{ old('image_description', $blog->image_description) }}</textarea>
                                <small class="text-muted">A detailed description that appears with your images.</small>
                            </div>
                        </div>
                    </div>

                    <!-- Video Section -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Video Section</h5>
                            <small class="text-muted">Add video URL and content that appears after the video.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Video URL</label>
                                <input type="url" name="video_url" class="form-control"
                                    value="{{ old('video_url', $blog->video_url) }}"
                                    placeholder="https://www.youtube.com/watch?v=... or https://vimeo.com/...">
                                <small class="text-muted">Enter a YouTube or Vimeo video URL to embed it in your blog
                                    post.</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Content After Video</label>
                                <textarea name="video_content" class="form-control rich-editor" rows="10"
                                    placeholder="Add content that appears after the video...">{{ old('video_content', $blog->video_content) }}</textarea>
                                <small class="text-muted">This content will be displayed after the video
                                    section.</small>
                            </div>
                        </div>
                    </div>

                 

                    <!-- SEO -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">SEO Information <small class="text-muted">(Optional)</small>
                            </h5>
                        </div>
                        <div class="card-body">

                            <div class="mb-3">
                                <label class="form-label">SEO Title</label>
                                <input type="text" name="_seo_title" class="form-control"
                                    value="{{ old('_seo_title', $blog->_seo_title) }}" placeholder="SEO Title...">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">SEO Tags</label>
                                <input type="text" name="_seo_tags" class="form-control"
                                    value="{{ old('_seo_tags', $blog->_seo_tags) }}" placeholder="SEO Tags...">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">SEO Description</label>
                                <textarea name="_seo_description" class="form-control" rows="3" placeholder="SEO Description...">{{ old('_seo_description', $blog->_seo_description) }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Canonical URL</label>
                                <input type="url" name="_canonical_url" class="form-control"
                                    value="{{ old('_canonical_url', $blog->_canonical_url) }}"
                                    placeholder="https://example.com/page-url">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Schema Markup (JSON-LD)</label>
                                <textarea name="_schema_markup" class="form-control" rows="6"
                                    placeholder='{ "@context": "https://schema.org", "@type": "BlogPosting", "headline": "Blog Title", "url": "https://example.com/blog-url" }'>{{ old('_schema_markup', $blog->_schema_markup) }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Page Index</label>
                                <div class="form-check form-switch">
                                    <!-- Hidden input comes BEFORE checkbox to be overridden when checked -->
                                    <input type="hidden" name="_page_index" value="0">
                                    <input class="form-check-input" type="checkbox" id="pageIndexToggle"
                                        name="_page_index" value="1"
                                        {{ old('_page_index', $blog->_page_index) == '1' ? 'checked' : '' }}>

                                </div>
                            </div>

                        </div>
                    </div>



                </div>

                <!-- Sidebar Column -->
                <div class="col-xl-3 col-lg-4">
                    <!-- Status -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Status</h5>
                        </div>
                        <div class="card-body">
                            <label for="blog-status" class="form-label">Active Status</label>
                            <select name="active" class="form-select" id="blog-status">
                                <option value="0" @if (old('active', $blog->active) == 0) selected @endif>Draft</option>
                                <option value="1" @if (old('active', $blog->active) == 1) selected @endif>Published
                                </option>
                                <option value="2" @if (old('active', $blog->active) == 2) selected @endif>Private
                                </option>

                            </select>
                        </div>
                    </div>

                    <!-- Media -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Blog Images</h5>
                        </div>
                        <div class="card-body">
                            <!-- Cover Image -->
                            <div class="mb-3">
                                <label class="form-label">Cover Image</label>
                                @if ($blog->cover_image)
                                    <div class="mb-2">
                                        <img src="{{ asset($blog->cover_image) }}" alt="Current cover image"
                                            class="img-thumbnail" style="max-width: 100%; max-height: 150px;">
                                        <small class="text-muted d-block">Current cover image</small>
                                    </div>
                                @endif
                                <input class="form-control" type="file" name="cover_image" accept="image/*"
                                    id="coverImageInput">
                                <small class="text-muted">Recommended: 1200x630px</small>
                                <div id="coverImagePreview" class="mt-2"></div>
                            </div>

                            <!-- Featured Images -->
                            <div class="mb-3">
                                <label class="form-label">Featured Images</label>
                                @if ($blog->featured_images_array && count($blog->featured_images_array) > 0)
                                    <div class="mb-2">
                                        @foreach ($blog->featured_images_array as $image)
                                            <img src="{{ asset($image) }}" alt="Featured image"
                                                class="img-thumbnail me-1 mb-1"
                                                style="max-width: 80px; max-height: 80px;">
                                        @endforeach
                                        <small class="text-muted d-block">Current featured images</small>
                                    </div>
                                @endif
                                <input class="form-control" type="file" name="featured_images[]" accept="image/*"
                                    id="featuredImagesInput" multiple>
                                <div id="featuredImagesPreview" class="mt-2"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="blog-title-input">Feature Image alt Text </label>
                                <input type="text" class="form-control " name="fimage_alt_text"
                                    id="fimage_alt_text" placeholder="Please enter a Feature Image alt Text"
                                    value="{{ old('fimage_alt_text', $blog->fimage_alt_text) }}" required>
                                <div class="invalid-feedback">Please enter a Feature Image alt Text.</div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Featured Blog</label>
                                <div class="form-check form-switch">
                                    <!-- Hidden input comes BEFORE checkbox to be overridden when checked -->
                                    <input type="hidden" name="is_featured" value="0">
                                    <input class="form-check-input" type="checkbox" id="isFeaturedToggle"
                                        name="is_featured" value="1"
                                        {{ old('is_featured', $blog->is_featured) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="isFeaturedToggle">
                                        Mark this blog as featured
                                    </label>
                                </div>
                            </div>


                        </div>
                    </div>

                    <div class="text-end mb-3">
                        <button type="submit" class="btn btn-success w-100">
                            <i class="bi bi-check-circle me-1"></i>Update Blog
                        </button>
                    </div>
                </div>
            </div>
        </form>

    </div>
</div>

<script>
    // Wait for document ready
    $(document).ready(function() {
        // Title to permalink conversion
        $('.addTitle').on('input', function() {
            var title = $(this).val();
            var permalink = title.replace(/\s+/g, '-').toLowerCase().replace(/[^\w\-]+/g, '');
            $('.permalink').val(permalink);
            validate_permalink();
        });

        $('.permalink').on('input', function() {
            validate_permalink();
        });

        // Image preview functionality
        const coverInput = document.getElementById('coverImageInput');
        const coverPreview = document.getElementById('coverImagePreview');
        const featuredInput = document.getElementById('featuredImagesInput');
        const featuredPreview = document.getElementById('featuredImagesPreview');
        const imageInput = document.getElementById('imageInput');
        const imagePreview = document.getElementById('imagePreview');

        // Cover image preview
        if (coverInput && coverPreview) {
            coverInput.addEventListener('change', function(event) {
                showPreviewImage(event.target.files[0], coverPreview);
            });
        }

        // Featured images preview
        if (featuredInput && featuredPreview) {
            featuredInput.addEventListener('change', function(event) {
                showMultiplePreviewImages(event.target.files, featuredPreview);
            });
        }

        // Image preview
        if (imageInput && imagePreview) {
            imageInput.addEventListener('change', function(event) {
                showPreviewImage(event.target.files[0], imagePreview);
            });
        }

        function showPreviewImage(file, container) {
            if (!file) {
                container.innerHTML = '';
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.width = '100%';
                img.style.maxHeight = '200px';
                img.style.objectFit = 'contain';
                img.className = "rounded border";

                container.innerHTML = '';
                container.appendChild(img);
            };
            reader.readAsDataURL(file);
        }

        function showMultiplePreviewImages(files, container) {
            container.innerHTML = '';

            if (!files || files.length === 0) {
                return;
            }

            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                const reader = new FileReader();

                reader.onload = function(e) {
                    const div = document.createElement('div');
                    div.className = 'mb-2';

                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.style.width = '100%';
                    img.style.maxHeight = '150px';
                    img.style.objectFit = 'contain';
                    img.className = "rounded border";

                    const caption = document.createElement('small');
                    caption.className = 'text-muted d-block mt-1';
                    caption.textContent = file.name;

                    div.appendChild(img);
                    div.appendChild(caption);
                    container.appendChild(div);
                };

                reader.readAsDataURL(file);
            }
        }
    });

    // Auto-dismiss alerts
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
            alert.classList.remove('show');
            alert.classList.add('fade');
            setTimeout(() => alert.remove(), 500);
        });
    }, 5000);

    // Permalink validation function
    function validate_permalink() {
        var permalink = $('#permalink').val();

        if (!permalink) {
            $('.permalink_status').val('');
            $('.permalink_error').html('<small class="text-danger">Permalink is required.</small>');
            return;
        }

        $.ajax({
            url: '{{ route('blogs.check.permalink') }}',
            method: 'POST',
            data: {
                permalink: permalink,
                exclude_id: {{ $blog->id }},
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            dataType: 'json',
            success: function(response) {
                if (response.available) {
                    $('.permalink_status').val('1');
                    $('.permalink_error').html('<small class="text-success">✓ ' + response.message +
                        '</small>');
                } else {
                    $('.permalink_status').val('');
                    $('.permalink_error').html('<small class="text-danger">✗ ' + response.message +
                        '</small>');
                }
            },
            error: function(xhr, status, error) {
                $('.permalink_status').val('');
                $('.permalink_error').html(
                    '<small class="text-danger">✗ Error checking permalink. Please try again.</small>');
            }
        });
    }
</script>

<script>
    $(document).ready(function() {


        // Check if Summernote is loaded
        if (typeof $.fn.summernote === 'undefined') {
            return;
        }

        // Initialize Summernote for video_content
        if ($('textarea[name="video_content"]').length && !$('textarea[name="video_content"]').hasClass(
                'note-editable')) {
            $('textarea[name="video_content"]').summernote({
                height: 300,
                minHeight: 200,
                maxHeight: 500,
                focus: false,
                disableDragAndDrop: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                followingToolbar: false,
                dialogsInBody: true,
                fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica',
                    'Impact', 'Tahoma', 'Times New Roman', 'Verdana'
                ],
                fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                shortcuts: false,
                callbacks: {
                    onPaste: function(e) {
                        setTimeout(() => {
                            var content = $(this).summernote('code');
                            content = content.replace(/<meta[^>]*>/gi, '');
                            content = content.replace(/<link[^>]*>/gi, '');
                            content = content.replace(/<!\[if[^>]*>.*?<!\[endif\]>/gsi, '');
                            content = content.replace(/<!--.*?-->/gs, '');
                            content = content.replace(/\s*style\s*=\s*["'][^"']*["']/gi,
                            '');
                            content = content.replace(/\s*class\s*=\s*["'][^"']*["']/gi,
                            '');
                            content = content.replace(
                                /\s*data-[a-zA-Z0-9\-]*\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/<o:p[^>]*>.*?<\/o:p>/gsi, '');
                            content = content.replace(/<w:[^>]*>.*?<\/w:[^>]*>/gsi, '');
                            content = content.replace(/<m:[^>]*>.*?<\/m:[^>]*>/gsi, '');
                            content = content.replace(/<v:[^>]*>.*?<\/v:[^>]*>/gsi, '');
                            content = content.replace(/<font[^>]*>(.*?)<\/font>/gsi, '$1');
                            content = content.replace(/<p[^>]*><\/p>/gi, '');
                            content = content.replace(/<p[^>]*>/gi, '<p>');
                            content = content.replace(
                                /<span[^>]*font-weight:\s*bold[^>]*>(.*?)<\/span>/gsi,
                                '<strong>$1</strong>');
                            content = content.replace(
                                /<span[^>]*font-style:\s*italic[^>]*>(.*?)<\/span>/gsi,
                                '<em>$1</em>');
                            content = content.replace(/<span[^>]*>/gi, '');
                            content = content.replace(/<\/span>/gi, '');
                            content = content.replace(/<div[^>]*>/gi, '');
                            content = content.replace(/<\/div>/gi, '');
                            content = content.replace(/\s+/g, ' ');
                            content = content.replace(/\u00A0/g, ' ');
                            content = content.replace(/&nbsp;/g, ' ');
                            if (content.length > 50000) {
                                content = content.substring(0, 50000) + '...';
                            }
                            $(this).summernote('code', content);
                        }, 100);
                    },
                    onChange: function(contents, $editable) {
                        $(this).val(contents);
                    }
                }
            });
        }

        // Initialize Summernote for image_description
        if ($('textarea[name="image_description"]').length && !$('textarea[name="image_description"]').hasClass('note-editable')) {
            $('textarea[name="image_description"]').summernote({
                height: 300,
                minHeight: 200,
                maxHeight: 500,
                focus: false,
                disableDragAndDrop: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                followingToolbar: false,
                dialogsInBody: true,
                fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
                fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                shortcuts: false,
                callbacks: {
                    onPaste: function(e) {
                        setTimeout(() => {
                            var content = $(this).summernote('code');
                            content = content.replace(/<meta[^>]*>/gi, '');
                            content = content.replace(/<link[^>]*>/gi, '');
                            content = content.replace(/<!\[if[^>]*>.*?<!\[endif\]>/gsi, '');
                            content = content.replace(/<!--.*?-->/gs, '');
                            content = content.replace(/\s*style\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/\s*class\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/\s*data-[a-zA-Z0-9\-]*\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/<o:p[^>]*>.*?<\/o:p>/gsi, '');
                            content = content.replace(/<w:[^>]*>.*?<\/w:[^>]*>/gsi, '');
                            content = content.replace(/<m:[^>]*>.*?<\/m:[^>]*>/gsi, '');
                            content = content.replace(/<v:[^>]*>.*?<\/v:[^>]*>/gsi, '');
                            content = content.replace(/<font[^>]*>(.*?)<\/font>/gsi, '$1');
                            content = content.replace(/<p[^>]*><\/p>/gi, '');
                            content = content.replace(/<p[^>]*>/gi, '<p>');
                            content = content.replace(/<span[^>]*font-weight:\s*bold[^>]*>(.*?)<\/span>/gsi, '<strong>$1</strong>');
                            content = content.replace(/<span[^>]*font-style:\s*italic[^>]*>(.*?)<\/span>/gsi, '<em>$1</em>');
                            content = content.replace(/<span[^>]*>/gi, '');
                            content = content.replace(/<\/span>/gi, '');
                            content = content.replace(/<div[^>]*>/gi, '');
                            content = content.replace(/<\/div>/gi, '');
                            content = content.replace(/\s+/g, ' ');
                            content = content.replace(/\u00A0/g, ' ');
                            content = content.replace(/&nbsp;/g, ' ');
                            if (content.length > 50000) {
                                content = content.substring(0, 50000) + '...';
                            }
                            $(this).summernote('code', content);
                        }, 100);
                    },
                    onChange: function(contents, $editable) {
                        $(this).val(contents);
                    }
                }
            });
        }
        
        // Ensure Summernote is initialized for blog content
        if ($('textarea[name="content"]').length && !$('textarea[name="content"]').hasClass('note-editable')) {
            $('textarea[name="content"]').summernote({
                height: 400,
                minHeight: 300,
                maxHeight: 600,
                focus: false,
                disableDragAndDrop: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                followingToolbar: false,
                dialogsInBody: true,
                fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica',
                    'Impact', 'Tahoma', 'Times New Roman', 'Verdana'
                ],
                fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                shortcuts: false,
                popover: {
                    image: [
                        ['image', ['resizeFull', 'resizeHalf', 'resizeQuarter', 'resizeNone']],
                        ['float', ['floatLeft', 'floatRight', 'floatNone']],
                        ['remove', ['removeMedia']]
                    ],
                    link: [
                        ['link', ['linkDialogShow', 'unlink']]
                    ],
                    table: [
                        ['add', ['addRowDown', 'addRowUp', 'addColLeft', 'addColRight']],
                        ['delete', ['deleteRow', 'deleteCol', 'deleteTable']],
                    ],
                    air: [
                        ['color', ['color']],
                        ['font', ['bold', 'underline', 'clear']]
                    ]
                },
                callbacks: {
                    onPaste: function(e) {
                        console.log('Paste event triggered for blog content');
                        setTimeout(() => {
                            var content = $(this).summernote('code');
                            // Clean Google Docs content
                            content = content.replace(/<meta[^>]*>/gi, '');
                            content = content.replace(/<link[^>]*>/gi, '');
                            content = content.replace(/<!\[if[^>]*>.*?<!\[endif\]>/gsi, '');
                            content = content.replace(/<!--.*?-->/gs, '');
                            content = content.replace(/\s*style\s*=\s*["'][^"']*["']/gi,
                            '');
                            content = content.replace(/\s*class\s*=\s*["'][^"']*["']/gi,
                            '');
                            content = content.replace(
                                /\s*data-[a-zA-Z0-9\-]*\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/<o:p[^>]*>.*?<\/o:p>/gsi, '');
                            content = content.replace(/<w:[^>]*>.*?<\/w:[^>]*>/gsi, '');
                            content = content.replace(/<m:[^>]*>.*?<\/m:[^>]*>/gsi, '');
                            content = content.replace(/<v:[^>]*>.*?<\/v:[^>]*>/gsi, '');
                            content = content.replace(/<font[^>]*>(.*?)<\/font>/gsi, '$1');
                            content = content.replace(/<p[^>]*><\/p>/gi, '');
                            content = content.replace(/<p[^>]*>/gi, '<p>');
                            content = content.replace(
                                /<span[^>]*font-weight:\s*bold[^>]*>(.*?)<\/span>/gsi,
                                '<strong>$1</strong>');
                            content = content.replace(
                                /<span[^>]*font-style:\s*italic[^>]*>(.*?)<\/span>/gsi,
                                '<em>$1</em>');
                            content = content.replace(/<span[^>]*>/gi, '');
                            content = content.replace(/<\/span>/gi, '');
                            content = content.replace(/<div[^>]*>/gi, '');
                            content = content.replace(/<\/div>/gi, '');
                            content = content.replace(/\s+/g, ' ');
                            content = content.replace(/\u00A0/g, ' ');
                            content = content.replace(/&nbsp;/g, ' ');
                            if (content.length > 50000) {
                                content = content.substring(0, 50000) + '...';
                            }
                            $(this).summernote('code', content);
                        }, 100);
                    },
                    onChange: function(contents, $editable) {
                        $(this).val(contents);
                    },
                    onInit: function() {

                        // Fix dropdown menus after initialization
                        setTimeout(function() {
                            var $editor = $('textarea[name="content"]').next(
                            '.note-editor');
                            if ($editor.length) {

                                // Fix style dropdown
                                $editor.find('.note-toolbar .note-btn-group').each(
                                function() {
                                    var $group = $(this);
                                    var $btn = $group.find('.note-btn');

                                    if ($btn.hasClass('dropdown-toggle')) {
                                        $btn.on('click', function(e) {
                                            e.preventDefault();
                                            e.stopPropagation();

                                            // Close other dropdowns
                                            $editor.find('.note-btn-group')
                                                .removeClass('open');

                                            // Toggle current dropdown
                                            $group.toggleClass('open');
                                        });
                                    }
                                });

                                // Close dropdowns when clicking outside
                                $(document).on('click', function(e) {
                                    if (!$(e.target).closest('.note-editor')
                                        .length) {
                                        $editor.find('.note-btn-group').removeClass(
                                            'open');
                                    }
                                });
                            }
                        }, 500);
                    }
                }
            });
        }
    });
</script>

<script>
    $(document).ready(function() {
        // Initialize Select2
        $('.select2-multiple').select2({
            placeholder: "Select options",
            allowClear: true,
            width: 'resolve' // adapts to the container width
        });

        // Process base64 images before form submission to reduce payload size
        $('#blog-edit-form').on('submit', function(e) {
            e.preventDefault();
            const form = $(this);

            // Show loading indicator
            const submitBtn = form.find('button[type="submit"]');
            const originalBtnText = submitBtn.html();
            submitBtn.prop('disabled', true).html(
                '<i class="fas fa-spinner fa-spin"></i> Processing images...');

            // Process content, video_content, and image_description fields
            processSummernoteImages(form.find('textarea[name="content"]'), 'content', function() {
                processSummernoteImages(form.find('textarea[name="video_content"]'),
                    'video_content',
                    function() {
                        processSummernoteImages(form.find('textarea[name="image_description"]'), 'image_description', function() {
                            // All images processed, submit form
                            form.off('submit').submit();
                        });
                    });
            });
        });
    });

    // Function to process base64 and external images in Summernote content
    function processSummernoteImages($textarea, fieldName, callback) {
        let content = $textarea.val();

        // First, check for external HTTP/HTTPS image URLs (not already local)
        const externalPattern = /<img([^>]*?)src="(https?:\/\/[^"]+)"([^>]*?)>/gi;
        const externalMatches = [];
        let externalMatch;

        while ((externalMatch = externalPattern.exec(content)) !== null) {
            const imageUrl = externalMatch[2];
            // Skip if already our local image
            if (imageUrl.indexOf('/blogs/content-images/') === -1 &&
                imageUrl.indexOf(window.location.origin + '/blogs/content-images/') === -1) {
                externalMatches.push({
                    fullMatch: externalMatch[0],
                    beforeSrc: externalMatch[1],
                    imageUrl: imageUrl,
                    afterSrc: externalMatch[3]
                });
            }
        }

        // Then, check if content has base64 images
        const base64Pattern = /<img([^>]*?)src="data:image\/([^;]+);base64,([^"]+)"([^>]*?)>/gi;
        const base64Matches = [];
        let base64Match;

        while ((base64Match = base64Pattern.exec(content)) !== null) {
            base64Matches.push({
                fullMatch: base64Match[0],
                beforeSrc: base64Match[1],
                imageType: base64Match[2],
                base64Data: base64Match[3],
                afterSrc: base64Match[4]
            });
        }

        const allMatches = externalMatches.map(m => ({
                ...m,
                type: 'external'
            }))
            .concat(base64Matches.map(m => ({
                ...m,
                type: 'base64'
            })));

        if (allMatches.length === 0) {
            // No images to process, proceed immediately
            if (callback) callback();
            return;
        }

        // Process images one by one
        let processedCount = 0;
        const totalImages = allMatches.length;

        allMatches.forEach(function(imgMatch, index) {
            if (imgMatch.type === 'external') {
                // Handle external URL
                $.ajax({
                    url: '/admin/blogs/upload-content-image',
                    method: 'POST',
                    data: {
                        image_url: imgMatch.imageUrl,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.success && response.url) {
                            // Replace external URL with local URL
                            const newImgTag = '<img' + imgMatch.beforeSrc + 'src="' + response.url +
                                '"' + imgMatch.afterSrc + '>';
                            content = content.replace(imgMatch.fullMatch, newImgTag);

                            processedCount++;

                            // Update textarea value
                            $textarea.val(content);

                            // If this is Summernote, update its code too
                            if ($textarea.hasClass('rich-editor') || $textarea.next('.note-editor')
                                .length > 0) {
                                $textarea.summernote('code', content);
                            }

                            // All images processed
                            if (processedCount === totalImages) {
                                if (callback) callback();
                            }
                        } else {
                            console.error('Failed to download external image:', response);
                            // Continue even if one image fails
                            processedCount++;
                            if (processedCount === totalImages) {
                                if (callback) callback();
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error downloading external image:', error);
                        // Continue even if one image fails
                        processedCount++;
                        if (processedCount === totalImages) {
                            if (callback) callback();
                        }
                    }
                });
            } else {
                // Handle base64 image
                const base64Data = imgMatch.base64Data;
                const imageType = imgMatch.imageType;
                const mimeType = 'image/' + imageType;

                // Decode base64
                const byteCharacters = atob(base64Data);
                const byteNumbers = new Array(byteCharacters.length);
                for (let i = 0; i < byteCharacters.length; i++) {
                    byteNumbers[i] = byteCharacters.charCodeAt(i);
                }
                const byteArray = new Uint8Array(byteNumbers);
                const blob = new Blob([byteArray], {
                    type: mimeType
                });

                // Create FormData for upload
                const formData = new FormData();
                formData.append('image', blob, 'blog_image_' + Date.now() + '_' + index + '.' + imageType);
                formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                // Upload image via AJAX
                $.ajax({
                    url: '/admin/blogs/upload-content-image',
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.success && response.url) {
                            // Replace base64 image with URL
                            const newImgTag = '<img' + imgMatch.beforeSrc + 'src="' + response.url +
                                '"' + imgMatch.afterSrc + '>';
                            content = content.replace(imgMatch.fullMatch, newImgTag);

                            processedCount++;

                            // Update textarea value
                            $textarea.val(content);

                            // If this is Summernote, update its code too
                            if ($textarea.hasClass('rich-editor') || $textarea.next('.note-editor')
                                .length > 0) {
                                $textarea.summernote('code', content);
                            }

                            // All images processed
                            if (processedCount === totalImages) {
                                if (callback) callback();
                            }
                        } else {
                            console.error('Failed to upload image:', response);
                            // Continue even if one image fails
                            processedCount++;
                            if (processedCount === totalImages) {
                                if (callback) callback();
                            }
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error uploading image:', error);
                        // Continue even if one image fails
                        processedCount++;
                        if (processedCount === totalImages) {
                            if (callback) callback();
                        }
                    }
                });
            }
        });
    }
</script>
