@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Edit Contact Message') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.contact-us.index') }}" class="link-primary text-decoration-none">
                                        Contact Us Messages
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Edit Message
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.contact-us.index') }}" class="btn btn-primary">
                            <i class="bi bi-list me-1"></i> Contact List
                        </a>
                        <a href="{{ route('admin.contact-us.show', $contact) }}" class="btn btn-warning">
                            <i class="bi bi-eye me-1"></i> Message Details
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Form -->
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fa-solid fa-edit me-2"></i>Edit Contact Message
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('admin.contact-us.update', $contact) }}">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="f_name" class="form-label">First Name</label>
                            <input type="text" class="form-control @error('f_name') is-invalid @enderror" 
                                   id="f_name" name="f_name" value="{{ old('f_name', $contact->f_name) }}">
                            @error('f_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="l_name" class="form-label">Last Name</label>
                            <input type="text" class="form-control @error('l_name') is-invalid @enderror" 
                                   id="l_name" name="l_name" value="{{ old('l_name', $contact->l_name) }}">
                            @error('l_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email', $contact->email) }}" required>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="phone" class="form-label">Phone</label>
                            <input type="text" class="form-control @error('phone') is-invalid @enderror" 
                                   id="phone" name="phone" value="{{ old('phone', $contact->phone) }}">
                            @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="subject" class="form-label">Subject</label>
                            <input type="text" class="form-control @error('subject') is-invalid @enderror" 
                                   id="subject" name="subject" value="{{ old('subject', $contact->subject) }}">
                            @error('subject')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="order_id" class="form-label">Order ID</label>
                            <input type="text" class="form-control @error('order_id') is-invalid @enderror" 
                                   id="order_id" name="order_id" value="{{ old('order_id', $contact->order_id) }}">
                            @error('order_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="col-12 mb-3">
                            <label for="message" class="form-label">Message</label>
                            <textarea class="form-control @error('message') is-invalid @enderror" 
                                      id="message" name="message" rows="5">{{ old('message', $contact->message) }}</textarea>
                            @error('message')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-success">
                            <i class="fa-solid fa-save me-1"></i> Update Message
                        </button>
                        <a href="{{ route('admin.contact-us.show', $contact) }}" class="btn btn-secondary">
                            <i class="fa-solid fa-times me-1"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@include('Admin.Includes.footer')
