@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Contact Us Messages') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Contact Us Messages
                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>

        <!-- Alerts -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Contact Messages Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="contactUsTable" class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>
                                    <input type="checkbox" id="selectAll" class="form-check-input">
                                </th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Subject</th>
                                <th>Message</th>
                                <th>File</th>
                                <th>Registered At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($contacts as $contact)
                                <tr>
                                    <td>
                                        <input type="checkbox" name="contact_ids[]" value="{{ $contact->id }}"
                                            class="form-check-input contact-checkbox">
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div
                                                class="avatar-sm bg-primary-subtle text-primary rounded-circle me-2 d-flex align-items-center justify-content-center">
                                                <i class="fa-solid fa-user"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $contact->f_name }} {{ $contact->l_name }}</h6>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="mailto:{{ $contact->email }}" class="text-decoration-none">
                                            {{ $contact->email }}
                                        </a>
                                    </td>
                                    <td>
                                        @if ($contact->phone)
                                            <a href="tel:{{ $contact->phone }}" class="text-decoration-none">
                                                {{ $contact->phone }}
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($contact->subject)
                                            <span class="badge bg-info-subtle text-info">{{ $contact->subject }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($contact->message)
                                            <span class="text-truncate d-inline-block" style="max-width: 200px;"
                                                title="{{ $contact->message }}">
                                                {{ Str::limit($contact->message, 50) }}
                                            </span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($contact->file_path)
                                            <a href="{{ route('admin.contact-us.download', $contact) }}"
                                                class="btn btn-sm btn-outline-primary">
                                                <i class="fa-solid fa-download"></i> Download
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small
                                            class="text-muted">{{ $contact->created_at->format('Y-m-d H:i:s') }}</small>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-sm text-dark rounded shadow-sm" type="button"
                                                data-bs-toggle="dropdown" aria-expanded="false"
                                                style="background-color: #c2d6e7;">
                                                &#8942;
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a class="dropdown-item"
                                                        href="{{ route('admin.contact-us.show', $contact) }}">
                                                        <i class="bi bi-eye me-2"></i>View</a>
                                                </li>

                                                <li><a class="dropdown-item"
                                                        href="{{ route('admin.contact-us.edit', $contact) }}">
                                                        <i class="bi bi-pencil-square me-2"></i>Edit</a>
                                                </li>

                                                <li><button class="dropdown-item text-danger" data-bs-toggle="modal"
                                                        data-bs-target="#deleteConfirmModal{{ $contact->id }}">
                                                        <i class="bi bi-trash me-2"></i>Delete</button>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                            <tr class="no-data-row">
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td class="text-center text-muted py-4">No data</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Delete Confirmation Modals -->
                @foreach ($contacts as $contact)
                    <div class="modal fade zoomIn" id="deleteConfirmModal{{ $contact->id }}" tabindex="-1"
                        aria-labelledby="deleteConfirmModalLabel{{ $contact->id }}" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body p-md-5">
                                    <div class="text-center">
                                        <div class="text-danger">
                                            <i class="bi bi-trash display-4"></i>
                                        </div>
                                        <div class="mt-4 fs-15">
                                            <h4 class="mb-1">Are you sure?</h4>
                                            <p class="text-muted mx-3 fs-16 mb-0">
                                                Are you sure you want to delete the contact message from
                                                <strong>{{ $contact->f_name }} {{ $contact->l_name }}</strong>?<br>
                                                This action cannot be undone.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Cancel</button>
                                    <form method="POST" action="{{ route('admin.contact-us.destroy', $contact) }}"
                                        style="display: inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">Yes, Delete</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

                <!-- Bulk Delete Confirmation Modal -->
                <div class="modal fade zoomIn" id="bulkDeleteConfirmModal" tabindex="-1"
                    aria-labelledby="bulkDeleteConfirmModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body p-md-5">
                                <div class="text-center">
                                    <div class="text-danger">
                                        <i class="bi bi-trash display-4"></i>
                                    </div>
                                    <div class="mt-4 fs-15">
                                        <h4 class="mb-1">Are you sure?</h4>
                                        <p class="text-muted mx-3 fs-16 mb-0">
                                            Are you sure you want to delete the selected contact message(s)?<br>
                                            This action cannot be undone.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                <button type="button" class="btn btn-danger" id="confirmBulkDelete">
                                    Yes, Delete Selected
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        <button type="button" class="btn btn-danger" id="bulkDeleteBtn" disabled
                            data-bs-toggle="modal" data-bs-target="#bulkDeleteConfirmModal">
                            <i class="fa-solid fa-trash"></i> Delete Selected
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<script>
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#contactUsTable').DataTable({
            "processing": true,
            "serverSide": false,
            "responsive": true,
            "pageLength": 25,
            "lengthMenu": [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"]
            ],
            "order": [
                [7, "desc"]
            ], // Sort by Registered At column (index 7) descending
            "columnDefs": [{
                    "targets": [0, 8], // Checkbox and Actions columns
                    "orderable": false,
                    "searchable": false
                },
                {
                    "targets": [5], // Message column
                    "orderable": false
                }
            ],
            "language": {
                "search": "Search:",
                "lengthMenu": "Show _MENU_ entries",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "Showing 0 to 0 of 0 entries",
                "infoFiltered": "(filtered from _MAX_ total entries)",
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Next",
                    "previous": "Previous"
                },
                "emptyTable": "No contact messages found"
            },
            "dom": '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>' +
                '<"row"<"col-sm-12"tr>>' +
                '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
            "drawCallback": function() {
                // Re-initialize checkboxes after table redraw
                initializeCheckboxes();
            }
        });

        // Initialize checkbox functionality
        function initializeCheckboxes() {
            const selectAllCheckbox = document.getElementById('selectAll');
            const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');

            if (!selectAllCheckbox || !bulkDeleteBtn) return;

            // Use event delegation for checkboxes since DataTables redraws content
            $(document).off('change', '#selectAll').on('change', '#selectAll', function() {
                const isChecked = this.checked;
                $('.contact-checkbox').prop('checked', isChecked);
                updateBulkDeleteButton();
            });

            $(document).off('change', '.contact-checkbox').on('change', '.contact-checkbox', function() {
                console.log('Individual checkbox changed:', this.checked, this.value);
                updateSelectAllCheckbox();
                updateBulkDeleteButton();
            });

            function updateSelectAllCheckbox() {
                const totalCheckboxes = $('.contact-checkbox').length;
                const checkedCheckboxes = $('.contact-checkbox:checked').length;

                if (checkedCheckboxes === 0) {
                    selectAllCheckbox.checked = false;
                    selectAllCheckbox.indeterminate = false;
                } else if (checkedCheckboxes === totalCheckboxes) {
                    selectAllCheckbox.checked = true;
                    selectAllCheckbox.indeterminate = false;
                } else {
                    selectAllCheckbox.checked = false;
                    selectAllCheckbox.indeterminate = true;
                }
            }

            function updateBulkDeleteButton() {
                const checkedCount = $('.contact-checkbox:checked').length;
                bulkDeleteBtn.disabled = checkedCount === 0;

                if (checkedCount > 0) {
                    bulkDeleteBtn.classList.remove('disabled');
                } else {
                    bulkDeleteBtn.classList.add('disabled');
                }
            }

            // Initial button state
            updateBulkDeleteButton();
        }

        // Initialize checkboxes on page load
        initializeCheckboxes();

        // Bulk delete button click handler
        $('#bulkDeleteBtn').on('click', function(e) {
            e.preventDefault();

            console.log('Bulk delete button clicked');
            const checkedCount = $('.contact-checkbox:checked').length;
            console.log('Checked count:', checkedCount);

            if (checkedCount === 0) {
                alert('Please select at least one contact message to delete.');
                return false;
            }

            // Update modal text with count
            const modalText = $('#bulkDeleteConfirmModal .modal-body p');
            modalText.html(
                `Are you sure you want to delete <strong>${checkedCount}</strong> selected contact message(s)?<br>This action cannot be undone.`
                );

            // Modal will be shown automatically due to data-bs-toggle
        });

        // Confirm bulk delete button in modal
        $('#confirmBulkDelete').on('click', function() {
            console.log('Confirm bulk delete clicked');

            // Get selected contact IDs
            const contactIds = [];
            $('.contact-checkbox:checked').each(function() {
                contactIds.push($(this).val());
            });

            console.log('Contact IDs to delete:', contactIds);

            // Close the modal
            $('#bulkDeleteConfirmModal').modal('hide');

            // Submit via AJAX
            $.ajax({
                url: '{{ route('admin.contact-us.bulk-delete') }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    contact_ids: contactIds
                },
                success: function(response) {
                    console.log('Bulk delete successful');
                    // Reload the page to show updated data
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    console.error('Bulk delete failed:', error);
                    alert('Error deleting contact messages. Please try again.');
                }
            });
        });
    });
</script>
