@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Contact Message Details') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.contact-us.index') }}" class="link-primary text-decoration-none">
                                        Contact Us Messages
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Message Details
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.contact-us.index') }}" class="btn btn-primary">
                            <i class="bi bi-list me-1"></i>Contact List
                        </a>
                        <a href="{{ route('admin.contact-us.edit', $contact) }}" class="btn btn-success">
                            <i class="bi bi-pencil-square me-1"></i> Edit
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Message Details -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fa-solid fa-envelope me-2"></i>Message Details
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">Name</label>
                                <p class="form-control-plaintext">{{ $contact->f_name }} {{ $contact->l_name }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">Email</label>
                                <p class="form-control-plaintext">
                                    <a href="mailto:{{ $contact->email }}" class="text-decoration-none">
                                        {{ $contact->email }}
                                    </a>
                                </p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">Phone</label>
                                <p class="form-control-plaintext">
                                    @if($contact->phone)
                                        <a href="tel:{{ $contact->phone }}" class="text-decoration-none">
                                            {{ $contact->phone }}
                                        </a>
                                    @else
                                        <span class="text-muted">Not provided</span>
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">Subject</label>
                                <p class="form-control-plaintext">
                                    @if($contact->subject)
                                        <span class="badge bg-info-subtle text-info">{{ $contact->subject }}</span>
                                    @else
                                        <span class="text-muted">No subject</span>
                                    @endif
                                </p>
                            </div>
                            @if($contact->order_id)
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-semibold">Order ID</label>
                                <p class="form-control-plaintext">{{ $contact->order_id }}</p>
                            </div>
                            @endif
                            <div class="col-12 mb-3">
                                <label class="form-label fw-semibold">Message</label>
                                <div class="border rounded p-3 bg-light">
                                    @if($contact->message)
                                        {{ $contact->message }}
                                    @else
                                        <span class="text-muted">No message provided</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fa-solid fa-info-circle me-2"></i>Additional Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Submitted Date</label>
                            <p class="form-control-plaintext">{{ $contact->created_at->format('F d, Y \a\t H:i A') }}</p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Last Updated</label>
                            <p class="form-control-plaintext">{{ $contact->updated_at->format('F d, Y \a\t H:i A') }}</p>
                        </div>

                        @if($contact->file_path)
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Attached File</label>
                            <div class="d-grid">
                                <a href="{{ route('admin.contact-us.download', $contact) }}" class="btn btn-primary">
                                    <i class="fa-solid fa-download me-1"></i> Download File
                                </a>
                            </div>
                        </div>
                        @endif

                        <div class="d-grid gap-2">
                            <a href="mailto:{{ $contact->email }}?subject=Re: {{ $contact->subject ?? 'Contact Message' }}" class="btn btn-success">
                                <i class="fa-solid fa-reply me-1"></i> Reply via Email
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

