<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Your Account Login Details | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
    <style>
        .credentials-box {
            background-color: #f8f9fa;
            border: 2px solid #01A7EF;
            border-radius: 8px;
            padding: 25px;
            margin: 25px 0;
        }

        .credentials-box b {
            color: #01A7EF;
            font-size: 16px;
        }

        .credentials-box .credential-item {
            margin: 15px 0;
            padding: 12px;
            background-color: #ffffff;
            border-radius: 5px;
            border-left: 3px solid #01A7EF;
        }

        .credentials-box .credential-label {
            color: #666666;
            font-size: 14px;
            margin-bottom: 5px;
        }

        .credentials-box .credential-value {
            color: #333333;
            font-size: 16px;
            font-weight: 600;
            font-family: 'Courier New', monospace;
        }

        .password-warning {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
            font-size: 13px;
            color: #856404;
        }
    </style>
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">Welcome to {{ $settings['business_name'] ?? 'Speedy Move' }}!</h2>
            
            <p><b>Dear {{ $name }},</b></p>
            
            <p>We're thrilled to have you join our community! We've created an account for you so you can easily access all our features and services.</p>

            @if(!empty($settings['tagline']))
                <div class="info-box">
                    <strong style="color: #01A7EF;">{{ $settings['tagline'] }}</strong>
                </div>
            @endif

            <div class="info-box">
                <b>Your Account Has Been Created</b>
                <br><br>
                <span>You can now log in to your account using the credentials below. We recommend changing your password after your first login for security purposes.</span>
            </div>

            <div class="credentials-box">
                <b style="display: block; margin-bottom: 20px;">Your Login Credentials:</b>
                
                <div class="credential-item">
                    <div class="credential-label">Full Name:</div>
                    <div class="credential-value">{{ $name }}</div>
                </div>

                <div class="credential-item">
                    <div class="credential-label">Email Address:</div>
                    <div class="credential-value">{{ $email }}</div>
                </div>

                <div class="credential-item">
                    <div class="credential-label">Password:</div>
                    <div class="credential-value">{{ $password }}</div>
                </div>
            </div>

            <div class="password-warning">
                <b>⚠️ Important Security Notice:</b>
                <ul style="margin: 10px 0; padding-left: 20px;">
                    <li>Please keep these credentials safe and secure</li>
                    <li>We recommend changing your password after your first login</li>
                    <li>Do not share your password with anyone</li>
                    <li>If you did not create this account, please contact us immediately</li>
                </ul>
            </div>

            <div class="info-box">
                <b>What's Next?</b>
                <br><br>
                <span>• Log in to your account and start exploring</span><br>
                <span>• Discover all the features and benefits we offer</span><br>
                <span>• Begin your journey with {{ $settings['business_name'] ?? 'Speedy Move' }} and make the most out of your experience</span>
            </div>

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="info-box">
                    <b>Need Help?</b>
                    <br><br>
                    <span>If you have any questions or need assistance, our support team is here to help:</span>
                    <br><br>
                    @if(!empty($settings['business_email']))
                        <b>Email:</b> <a href="mailto:{{ $settings['business_email'] }}" style="color: #01A7EF; text-decoration: none; font-weight: 600;">{{ $settings['business_email'] }}</a>
                        @if(!empty($settings['business_phone']))
                            <br>
                        @endif
                    @endif
                    @if(!empty($settings['business_phone']))
                        <b>Phone:</b> <a href="tel:{{ $settings['business_phone'] }}" style="color: #01A7EF; text-decoration: none; font-weight: 600;">{{ $settings['business_phone'] }}</a>
                    @endif
                </div>
            @endif

            <p style="margin-top: 25px;">Thank you for joining us. We're excited to see what you'll achieve with {{ $settings['business_name'] ?? 'Speedy Move' }}!</p>

            <p><b>Best regards,</b><br>
            <b>The {{ $settings['business_name'] ?? 'Speedy Move' }} Team</b></p>
        </div>
        
        <!-- Footer -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>
