<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Contact Us Form Query | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
<main>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>
        
        <!-- Email Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">New Contact Us Form Query</h2>
            
            <p><b>You have received a new message.</b></p>
            
            <div style="background-color: #f8f9fa; padding: 20px; border-radius: 5px; margin: 20px 0;">
                <table style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            <strong style="color: #01A7EF;">Name:</strong>
                        </td>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            {{ $data->f_name }} {{ $data->l_name }}
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            <strong style="color: #01A7EF;">Email:</strong>
                        </td>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            <a href="mailto:{{ $data->email }}" style="color: #01A7EF; text-decoration: none;">
                                {{ $data->email }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            <strong style="color: #01A7EF;">Phone:</strong>
                        </td>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            {{ $data->phone }}
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            <strong style="color: #01A7EF;">Subject:</strong>
                        </td>
                        <td style="padding: 10px 0; border-bottom: 1px solid #e9ecef;">
                            {{ $data->subject }}
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 10px 0; vertical-align: top; padding-top: 15px;">
                            <strong style="color: #01A7EF;">Message:</strong>
                        </td>
                        <td style="padding: 10px 0; padding-top: 15px;">
                            {{ $data->message }}
                        </td>
                    </tr>
                </table>
            </div>
            <p style="margin-top: 30px; color: #6c757d; font-size: 14px;">
                <strong>Submitted on:</strong> {{ $data->created_at->format('F d, Y \a\t g:i A') }}
            </p>
            
            <p style="margin-top: 20px;">
                Please respond to this inquiry as soon as possible to maintain excellent customer service.
            </p>
        </div>
        
        <!-- Footer -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</main>
</body>
</html>