<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        @if(isset($isRemainingPayment) && $isRemainingPayment)
            Remaining Amount Payment Received
        @else
            New Order Received
        @endif | {{ $settings['business_name'] ?? 'Speedy Move' }}
    </title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">
                @if(isset($isRemainingPayment) && $isRemainingPayment)
                    Remaining Amount Payment Received
                @else
                    New Order Received
                @endif
            </h2>
            
            <p><b>Dear Admin,</b></p>
            
            @if(isset($isRemainingPayment) && $isRemainingPayment)
                <p>The remaining amount payment has been received and successfully processed. The order is now fully paid. Please review the updated order details below.</p>
            @else
                <p>A new order has been received and payment has been successfully processed. Please review the order details below.</p>
            @endif

            <div class="info-box" style="background-color: #e3f2fd; border-left-color: #01A7EF;">
                <b>Order Number:</b> {{ $quote->order_number ?? $quote->quote_number }}<br>
                <b>Order Date:</b> {{ $quote->created_at->format('F d, Y h:i A') }}<br>
                <b>Payment Type:</b> {{ ucfirst($paymentType) }} Payment<br>
                <b>Payment Status:</b> 
                <span style="color: #28a745; font-weight: 600;">
                    @if($paymentStatus === 'succeeded')
                        ✓ Succeeded
                    @else
                        {{ ucfirst($paymentStatus) }}
                    @endif
                </span>
            </div>

            <h3 style="color: #01A7EF; margin-top: 25px;">Customer Information</h3>
            
            <div class="order-details-box">
                <table>
                    <tr>
                        <td>Customer Name:</td>
                        <td>{{ $user->name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td>Email:</td>
                        <td><a href="mailto:{{ $user->email }}">{{ $user->email }}</a></td>
                    </tr>
                    @if($user->phone)
                        <tr>
                            <td>Phone:</td>
                            <td><a href="tel:{{ $user->phone }}">{{ $user->phone }}</a></td>
                        </tr>
                    @endif
                </table>
            </div>

            <h3 style="color: #01A7EF; margin-top: 25px;">Order Details</h3>
            
            <div class="order-details-box">
                <table>
                    <tr>
                        <td>Total Amount:</td>
                        <td>${{ number_format($quote->total_cost, 2) }}</td>
                    </tr>
                    @if($paymentType === 'deposit')
                        @php
                            $jobType = $depositSettings['job_type'] ?? ($quote->job_type ?? ($quote->raw_data['job_type'] ?? 'local_job'));
                            
                            if ($jobType === 'interstate_job') {
                                $depositPercentage = $depositSettings['interstate_job_deposit_percentage'] ?? 20;
                                $depositLabel = "Deposit Paid ({$depositPercentage}%):";
                            } else {
                                $depositAmount = $depositSettings['local_job_deposit_amount'] ?? 100;
                                $depositLabel = "Deposit Paid (\${$depositAmount}):";
                            }
                        @endphp
                        <tr>
                            <td>{{ $depositLabel }}</td>
                            <td>${{ number_format($quote->deposit_amount ?? 0, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Remaining Amount:</td>
                            <td>${{ number_format($quote->remaining_amount ?? 0, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Remaining Payment Status:</td>
                            <td>
                                <span style="color: #ffc107; font-weight: 600;">
                                    {{ ucfirst($quote->remaining_payment_status ?? 'pending') }}
                                </span>
                            </td>
                        </tr>
                    @else
                        <tr>
                            <td>Full Payment:</td>
                            <td>${{ number_format($quote->deposit_amount ?? $quote->total_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Remaining Amount:</td>
                            <td>$0.00</td>
                        </tr>
                        <tr>
                            <td>Remaining Payment Status:</td>
                            <td>
                                <span style="color: #28a745; font-weight: 600;">Succeeded</span>
                            </td>
                        </tr>
                    @endif
                   
                  
                    @if($quote->total_cubic_meters)
                        <tr>
                            <td>Total Cubic Meters:</td>
                            <td>{{ number_format($quote->total_cubic_meters, 2) }} m³</td>
                        </tr>
                    @endif
                    @if($quote->number_of_movers)
                        <tr>
                            <td>Number of Movers:</td>
                            <td>{{ $quote->number_of_movers }}</td>
                        </tr>
                    @endif
                </table>
            </div>

            @if($paymentType === 'deposit' && !empty($quote->remaining_payment_url))
                <div class="info-box" style="background-color: #fff3cd; border-left-color: #ffc107;">
                    <b>Remaining Payment Link:</b><br>
                    <a href="{{ $quote->remaining_payment_url }}" style="color: #01A7EF; word-break: break-all; font-size: 13px;">
                        {{ $quote->remaining_payment_url }}
                    </a>
                    <p style="margin: 10px 0 0 0; font-size: 13px; color: #666666;">
                        This link has been sent to the customer. They can use it to complete the remaining payment.
                    </p>
                </div>
            @endif

            <div class="info-box" style="margin-top: 25px;">
                <b>Action Required:</b>
                <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                    <li>Review the order details</li>
                    <li>Contact the customer to confirm move date and time</li>
                    <li>Prepare for the move</li>
                    @if($paymentType === 'deposit')
                        <li>Monitor remaining payment status</li>
                    @endif
                </ul>
            </div>

            <p style="margin-top: 25px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} System
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

