<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        @if(isset($isRemainingPayment) && $isRemainingPayment)
            Remaining Amount Payment Completed
        @else
            Order Confirmation
        @endif | {{ $settings['business_name'] ?? 'Speedy Move' }}
    </title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">
                @if(isset($isRemainingPayment) && $isRemainingPayment)
                    Remaining Amount Payment Completed
                @else
                    Order Confirmation
                @endif
            </h2>
            
            <p><b>Dear {{ $user->name ?? 'Customer' }},</b></p>
            
            @if(isset($isRemainingPayment) && $isRemainingPayment)
                <p>Thank you for completing your remaining payment! Your full payment has been successfully processed and your order is now fully paid.</p>
            @else
                <p>Thank you for your order! We're excited to help you with your move. Your order has been confirmed and payment has been successfully processed.</p>
            @endif

            <div class="info-box">
                <b>Order Number:</b> {{ $quote->order_number ?? $quote->quote_number }}<br>
                <b>Order Date:</b> {{ $quote->created_at->format('F d, Y') }}<br>
                @if($quote->order_number)
                    <b>Order Type:</b> Order
                @else
                    <b>Quote Type:</b> Quote
                @endif
            </div>

            <h3 style="color: #01A7EF; margin-top: 25px;">Order Details</h3>
            
            <div class="order-details-box">
                <table>
                    <tr>
                        <td>Total Amount:</td>
                        <td>${{ number_format($quote->total_cost, 2) }}</td>
                    </tr>
                    @if($paymentType === 'deposit')
                        @php
                            $jobType = $depositSettings['job_type'] ?? ($quote->job_type ?? ($quote->raw_data['job_type'] ?? 'local_job'));
                            
                            if ($jobType === 'interstate_job') {
                                $depositPercentage = $depositSettings['interstate_job_deposit_percentage'] ?? 20;
                                $depositLabel = "Deposit Paid ({$depositPercentage}%):";
                            } else {
                                $depositAmount = $depositSettings['local_job_deposit_amount'] ?? 100;
                                $depositLabel = "Deposit Paid (\${$depositAmount}):";
                            }
                        @endphp
                        <tr>
                            <td>{{ $depositLabel }}</td>
                            <td>${{ number_format($quote->deposit_amount ?? 0, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Remaining Amount:</td>
                            <td>${{ number_format($quote->remaining_amount ?? 0, 2) }}</td>
                        </tr>
                    @else
                        <tr>
                            <td>Full Payment:</td>
                            <td>${{ number_format($quote->deposit_amount ?? $quote->total_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td>Remaining Amount:</td>
                            <td>$0.00</td>
                        </tr>
                    @endif
                    <tr>
                        <td>Payment Status:</td>
                        <td>
                            <span style="color: #28a745; font-weight: 600;">
                                @if($paymentStatus === 'succeeded')
                                    ✓ Paid
                                @else
                                    {{ ucfirst($paymentStatus) }}
                                @endif
                            </span>
                        </td>
                    </tr>
                    
                  
                </table>
            </div>

            @if($paymentType === 'deposit' && !empty($quote->remaining_payment_url))
                <div class="payment-link-box">
                    <h3 style="color: #01A7EF; margin-top: 0;">Complete Your Payment</h3>
                    <p style="margin: 10px 0;">To complete your order, please pay the remaining amount using the link below:</p>
                    <p style="margin: 15px 0;">
                        <a href="{{ $quote->remaining_payment_url }}" class="btn-primary" style="display: inline-block; padding: 12px 30px; background-color: #01A7EF; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: 600;">
                            Pay Remaining Amount (${{ number_format($quote->remaining_amount ?? 0, 2) }})
                        </a>
                    </p>
                    <p style="margin: 10px 0; font-size: 13px; color: #666666;">
                        Or copy and paste this link into your browser:<br>
                        <a href="{{ $quote->remaining_payment_url }}" style="color: #01A7EF; word-break: break-all;">{{ $quote->remaining_payment_url }}</a>
                    </p>
                </div>
            @endif

            <div class="info-box" style="margin-top: 25px;">
                <b>What's Next?</b>
                <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                    <li>Our team will review your order and contact you shortly</li>
                    <li>We'll confirm the move date and time with you</li>
                    @if($paymentType === 'deposit')
                        <li>Please complete the remaining payment before the move date</li>
                    @endif
                    <li>If you have any questions, feel free to contact us</li>
                </ul>
            </div>

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="info-box">
                    <b>Need Help?</b>
                    <p style="margin: 10px 0 0 0;">If you have any questions or need assistance, our support team is here to help:</p>
                    @if(!empty($settings['business_email']))
                        <p style="margin: 5px 0;"><b>Email:</b> <a href="mailto:{{ $settings['business_email'] }}">{{ $settings['business_email'] }}</a></p>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <p style="margin: 5px 0;"><b>Phone:</b> <a href="tel:{{ $settings['business_phone'] }}">{{ $settings['business_phone'] }}</a></p>
                    @endif
                </div>
            @endif

            <p style="margin-top: 25px;">Thank you for choosing {{ $settings['business_name'] ?? 'Speedy Move' }}. We look forward to serving you!</p>

            <p style="margin-top: 20px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} Team
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

