<style>
    /* Email Container Styles */
    .email-container {
        width: 600px;
        margin: 0 auto;
        font-family: Arial, sans-serif;
        background-color: #ffffff;
    }

    /* Header Styles - Simple White Background */
    .email-header {
        width: 100%;
        padding: 30px 20px;
        text-align: center;
        background-color: #ffffff;
    }

    .email-header img {
        max-width: 200px;
        height: auto;
    }

    /* Body Styles */
    .email-body {
        padding: 30px;
        background-color: #ffffff;
        color: #333333;
        line-height: 1.6;
    }

    .email-body h1,
    .email-body h2,
    .email-body h3 {
        color: #01A7EF;
        margin-top: 0;
    }

    .email-body b,
    .email-body strong {
        color: #333333;
    }

    .email-body a {
        color: #01A7EF;
        text-decoration: none;
        font-weight: 600;
    }

    .email-body a:hover {
        text-decoration: underline;
    }

    /* Button Styles */
    .btn-primary {
        display: inline-block;
        padding: 12px 30px;
        background-color: #01A7EF;
        color: #ffffff !important;
        text-decoration: none;
        border-radius: 5px;
        font-weight: 600;
        margin: 15px 0;
    }

    .btn-primary:hover {
        background-color: #0190d4;
        text-decoration: none;
    }

    /* Info Box Styles */
    .info-box {
        background-color: #f8f9fa;
        border-left: 4px solid #01A7EF;
        padding: 15px 20px;
        margin: 20px 0;
        border-radius: 4px;
    }

    .info-box b {
        color: #01A7EF;
    }

    /* Order Details Box */
    .order-details-box {
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 20px;
        margin: 20px 0;
    }

    .order-details-box table {
        width: 100%;
        border-collapse: collapse;
    }

    .order-details-box table td {
        padding: 8px 0;
        border-bottom: 1px solid #e9ecef;
    }

    .order-details-box table td:first-child {
        font-weight: 600;
        color: #333333;
        width: 40%;
    }

    .order-details-box table td:last-child {
        color: #666666;
    }

    .order-details-box table tr:last-child td {
        border-bottom: none;
    }

    /* Payment Link Box */
    .payment-link-box {
        background-color: #e3f2fd;
        border: 2px solid #01A7EF;
        border-radius: 8px;
        padding: 20px;
        margin: 20px 0;
        text-align: center;
    }

    .payment-link-box h3 {
        color: #01A7EF;
        margin-top: 0;
    }

    /* Footer Styles - Light Gray */
    .email-footer {
        padding: 30px 20px;
        background-color: #f5f5f5;
        text-align: center;
        color: #666666;
        font-size: 14px;
    }

    .email-footer a {
        color: #01A7EF;
        text-decoration: none;
    }

    .email-footer a:hover {
        text-decoration: underline;
    }

    .footer-divider {
        border-top: 1px solid #dee2e6;
        margin: 20px 0;
        padding-top: 20px;
    }

    .social-links {
        margin: 15px 0;
    }

    .social-links a {
        display: inline-block;
        margin: 0 8px;
        color: #01A7EF;
        text-decoration: none;
        font-size: 16px;
    }

    .business-info {
        margin: 15px 0;
        line-height: 1.8;
    }

    .business-info b {
        color: #333333;
    }

    /* OTP Box Styles */
    .otp-box {
        background-color: #f8f9fa;
        border: 2px solid #01A7EF;
        border-radius: 8px;
        padding: 25px;
        margin: 25px 0;
        text-align: center;
    }

    .otp-code {
        font-size: 36px;
        font-weight: 700;
        color: #01A7EF;
        letter-spacing: 8px;
        background-color: #e3f2fd;
        padding: 20px;
        border-radius: 8px;
        margin: 15px 0;
        display: inline-block;
        min-width: 200px;
        text-align: center;
        font-family: 'Courier New', monospace;
    }

    /* Warning Box Styles */
    .warning-box {
        background-color: #fff3cd;
        border-left: 4px solid #ffc107;
        padding: 20px;
        margin: 25px 0;
        border-radius: 4px;
    }

    .warning-box ul {
        margin: 10px 0;
        padding-left: 20px;
    }

    .warning-box li {
        margin: 8px 0;
        line-height: 1.6;
    }

    /* Discount Confirmation Box */
    .discount-confirmation-box {
        background-color: #e8f5e9;
        border-left: 4px solid #198754;
        border-radius: 8px;
        padding: 20px;
        margin: 20px 0;
    }

    .discount-confirmation-box h3 {
        color: #198754;
        margin-top: 0;
    }

    /* Discount Details Box */
    .discount-details-box {
        background-color: #e3f2fd;
        border-left: 4px solid #01A7EF;
        border-radius: 8px;
        padding: 20px;
        margin: 20px 0;
    }

    .discount-details-box h3 {
        color: #01A7EF;
        margin-top: 0;
    }

    /* Responsive */
    @media only screen and (max-width: 600px) {
        .email-container {
            width: 100% !important;
        }
        
        .otp-code {
            font-size: 28px;
            letter-spacing: 4px;
            padding: 15px;
            min-width: 150px;
        }
    }
</style>

