<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
    </script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/feather-icons@4.28.0/dist/feather.min.css">
    <title>Approved Email</title>
    <style>
        .email {
            width: 600px;
            margin: 50px auto;
            font-family: Arial, sans-serif;
        }

        .email-header {
            width: 100%;
            /* background-color: #ed1c24; */
            padding: 20px 0;
            text-align: center;
        }

        .email-header img {
            width: 114px;
            height: auto;
        }

        .email-body {
            padding: 30px;
            background-color: #ffffff;
            color: #000000;
        }

        .email-body b {
            color: #000000;
        }

        .email-body a {
            color: #000000;
            text-decoration: none;
            font-weight: 600;
        }

        .email-footer {
            padding: 20px;
            background-color: #ed1c24;
            text-align: center;
            color: #ffffff;
        }

        .email-footer a {
            color: #ffffff;
            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="email" style="margin: 10px auto;border:2px solid #ebebeb;">
        <div class="email-header">
            <img src="{{ $image_url . '/' . $logo }}" alt="Speedy Move" style="width: 35%;">
        </div>
        
        <h2 style="margin-top: 10px; font-weight: 700; font-size: 24px; color:#000; text-align:center;">Your Account Detail</h2>    

        <div class="email-body">
            <b> Dear @if (isset($user) && !empty($user))
                    {{ $user->name }}
                @endif</b>
            <br><br>

            <span style="color:#000";> Welcome to Speedy Move! We’re thrilled to have you join our community.
            </span>
            <br><br>
            <b style="color: #000">What’s Next?</b>
            <br><br>
            <b style="color: #000">Log In:</b> <span style="color: #000">Use your credentials to log in and start
                exploring.</span> <br>
            <b style="color: #000">Explore:</b> <span style="color: #000"> Discover all the features and benefits we
                offer. </span><br>
            <b style="color: #000">Get Started:</b> <span style="color:#000"></span> Begin your journey with Speedy Move
            Station and make the most out of your experience. </span>
            <br><br>
            <b style="color: #000">Your Account Details:</b>
            <br><br>
            <b style="color: #000">Username:</b>
            @if (isset($user->name) && !empty($user->name))
                {{ $user->name }}
            @endif
            <br>
            <b style="color:#000">Email:</b>
            @if (isset($user->email) && !empty($user->email))
                {{ $user->email }}
            @endif
            <br>
            <b style="color:#000">Phone:</b>
            @if (isset($user->phone) && !empty($user->phone))
                {{ $user->phone }}
            @endif
            <br>
            @php
                // Prepare business data from $userMeta array
                $businessData = [];
                if ($userMeta) {
                    foreach ($userMeta as $meta) {
                        $businessData[$meta['option']] = $meta['value'];
                    }
                }
            @endphp

            <b style="color:#000">Business Name:</b>
            {{ $businessData['_b_name'] ?? '' }}
            <br>

            <b style="color:#000">Business Email:</b>
            {{ $businessData['_b_email'] ?? '' }}
            <br>

            <b style="color:#000">Business Phone:</b>
            {{ $businessData['_b_number'] ?? '' }}
            <br>

            <b style="color:#000">Business Street Address:</b>
            {{ $businessData['_b_street_address'] ?? '' }}
            <br>

            <b style="color:#000">Business Area Address:</b>
            {{ $businessData['_b_area_address'] ?? '' }}
            <br>

            <br><br>
            <span style="color: #000">If you need any assistance or have any questions, our support team is here to
                help. You can reach us at
                <a href="mailto:sales@speedy-move.com.au"
                    style="color: #000;text-decoration: none;font-weight: 600;">sales@speedy-move.com.au</a>.</span>
            <br><br>
            <span style="color: #000"> Thank you for joining us. We’re excited to see what you’ll achieve with Speedy Move
                ! </span>
        </div>
        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>
