@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">
        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Edit FAQ') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('faqs.index') }}" class="link-primary text-decoration-none">
                                        FAQs
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Edit FAQ
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('faqs.index') }}" class="btn btn-primary global-list-btn">
                            <i class="bi bi-list me-1"></i> FAQ List
                        </a>
                        <a href="{{ route('faqs.show', $faq) }}" class="btn btn-warning global-list-btn">
                            <i class="bi bi-eye me-1"></i> View FAQ
                        </a>
                    </div>
                </div>
            </div>
        </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <form action="{{ route('faqs.update', $faq) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <!-- Main Content Column -->
                            <div class="col-lg-8">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">
                                            <i class="bi bi-info-circle me-2"></i>Basic Information
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label class="form-label">Title <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="title" 
                                                   value="{{ old('title', $faq->title) }}" 
                                                   placeholder="Enter FAQ page title" required>
                                            @error('title')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Permalink <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="permalink" name="permalink" 
                                                   value="{{ old('permalink', $faq->permalink) }}" 
                                                   placeholder="faq-page-url" required>
                                            <div class="permalink_status mt-1"></div>
                                            <div class="permalink_error"></div>
                                            @error('permalink')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Page URL</label>
                                            <input type="url" class="form-control" name="page_url" 
                                                   value="{{ old('page_url', $faq->page_url) }}" 
                                                   placeholder="https://example.com/faq-page">
                                            @error('page_url')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Description</label>
                                            <textarea name="description" class="form-control" rows="3" 
                                                      placeholder="Brief description of this FAQ page">{{ old('description', $faq->description) }}</textarea>
                                            @error('description')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <!-- Questions & Answers -->
                                <div class="card mb-4">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h6 class="card-title mb-0">
                                            <i class="bi bi-question-circle me-2"></i>Questions & Answers
                                        </h6>
                                       
                                    </div>
                                    <div class="card-body">
                                        <div id="qa-container">
                                        @if($faq->questions && count($faq->questions) > 0)
                                            @foreach($faq->questions as $index => $question)
                                                <div class="qa-item border rounded p-3 mb-3" data-index="{{ $index + 1 }}">
                                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                                        <h6 class="mb-0">Q&A #{{ $index + 1 }}</h6>
                                                        <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeQA({{ $index + 1 }})">
                                                            <i class="bi bi-trash"></i>
                                                        </button>
                                                    </div>
                                                    
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label">Question <span class="text-danger">*</span></label>
                                                                <textarea name="questions[{{ $index + 1 }}][question]" class="form-control" rows="2" 
                                                                          placeholder="Enter question" required>{{ old('questions.'.$index.'.question', $question->question) }}</textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label">Sort Order</label>
                                                                <input type="number" name="questions[{{ $index + 1 }}][sort_order]" 
                                                                       class="form-control" value="{{ old('questions.'.$index.'.sort_order', $question->sort_order) }}" min="0">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="mb-3">
                                                        <label class="form-label">Answer <span class="text-danger">*</span></label>
                                                        <textarea name="questions[{{ $index + 1 }}][answer]" class="form-control" rows="4" 
                                                                  placeholder="Enter detailed answer" required>{{ old('questions.'.$index.'.answer', $question->answer) }}</textarea>
                                                    </div>
                                                    
                                                    <div class="mb-3">
                                                        <div class="form-check form-switch">
                                                            <input type="hidden" name="questions[{{ $index + 1 }}][status]" value="0">
                                                            <input class="form-check-input" type="checkbox" 
                                                                   name="questions[{{ $index + 1 }}][status]" value="1" 
                                                                   {{ old('questions.'.$index.'.status', $question->status) == '1' ? 'checked' : '' }}>
                                                            <label class="form-check-label">Active</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                            @else
                                                <!-- Add initial Q&A if none exist -->
                                                <script>
                                                    $(document).ready(function() {
                                                        addNewQA();
                                                    });
                                                </script>
                                            @endif
                                        </div>
                                        <div class="text-center mt-3">
                                            <button type="button" class="btn btn-success" onclick="addNewQA()">
                                                <i class="bi bi-plus-circle me-1"></i>Add Another Q&A
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Sidebar Column -->
                            <div class="col-lg-4">
                                <!-- Status & Settings -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">
                                            <i class="bi bi-gear me-2"></i>Settings
                                        </h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label class="form-label">Status <span class="text-danger">*</span></label>
                                            <select name="status" class="form-select" required>
                                                <option value="1" {{ old('status', $faq->status) == '1' ? 'selected' : '' }}>Active</option>
                                                <option value="0" {{ old('status', $faq->status) == '0' ? 'selected' : '' }}>Inactive</option>
                                            </select>
                                            @error('status')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Sort Order</label>
                                            <input type="number" class="form-control" name="sort_order" 
                                                   value="{{ old('sort_order', $faq->sort_order) }}" 
                                                   min="0" placeholder="0">
                                            @error('sort_order')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-grid gap-2">
                                            <button type="submit" class="btn btn-success">
                                                <i class="bi bi-check-lg me-1"></i>Update FAQ
                                            </button>
                                            <a href="{{ route('faqs.index') }}" class="btn btn-secondary">
                                                <i class="bi bi-x-lg me-1"></i>Cancel
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<script>
    let qaCounter = {{ count($faq->questions ?? []) }};

    $(document).ready(function() {
        // Auto-generate permalink from title with debounce
        $('input[name="title"]').on('input', function() {
            clearTimeout(this.permalinkTimeout);
            const self = this;
            this.permalinkTimeout = setTimeout(function() {
                const title = $(self).val();
                if (title) {
                    const permalink = generatePermalinkFromTitle(title);
                    $('#permalink').val(permalink);
                    checkPermalink();
                }
            }, 300); // 300ms delay
        });
    });

    function addNewQA() {
        qaCounter++;
        const qaHtml = `
            <div class="qa-item border rounded p-3 mb-3" data-index="${qaCounter}">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h6 class="mb-0">Q&A #${qaCounter}</h6>
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeQA(${qaCounter})">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Question <span class="text-danger">*</span></label>
                                                    <textarea name="questions[${qaCounter}][question]" class="form-control" rows="2" 
                                                              placeholder="Enter question" required></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Sort Order</label>
                                                    <input type="number" name="questions[${qaCounter}][sort_order]" 
                                                           class="form-control" value="${qaCounter}" min="0">
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label class="form-label">Answer <span class="text-danger">*</span></label>
                                            <textarea name="questions[${qaCounter}][answer]" class="form-control" rows="4" 
                                                      placeholder="Enter detailed answer" required></textarea>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <div class="form-check form-switch">
                                                <input type="hidden" name="questions[${qaCounter}][status]" value="0">
                                                <input class="form-check-input" type="checkbox" 
                                                       name="questions[${qaCounter}][status]" value="1" checked>
                                                <label class="form-check-label">Active</label>
                                            </div>
                                        </div>
            </div>
        `;
        
        $('#qa-container').append(qaHtml);
    }

    function removeQA(index) {
        $(`.qa-item[data-index="${index}"]`).remove();
        updateQANumbers();
    }

    function updateQANumbers() {
        $('.qa-item').each(function(index) {
            $(this).find('h6').text(`Q&A #${index + 1}`);
            $(this).attr('data-index', index + 1);
            
            // Update input names
            $(this).find('textarea[name*="[question]"]').attr('name', `questions[${index + 1}][question]`);
            $(this).find('textarea[name*="[answer]"]').attr('name', `questions[${index + 1}][answer]`);
            $(this).find('input[name*="[sort_order]"]').attr('name', `questions[${index + 1}][sort_order]`);
            $(this).find('input[name*="[status]"]').each(function() {
                $(this).attr('name', `questions[${index + 1}][status]`);
            });
        });
    }

    function generatePermalinkFromTitle(title) {
        // Remove special characters and convert to lowercase
        let permalink = title.toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '') // Remove special characters except spaces and hyphens
            .replace(/\s+/g, '-') // Replace spaces with hyphens
            .replace(/-+/g, '-') // Replace multiple hyphens with single hyphen
            .replace(/^-|-$/g, ''); // Remove leading/trailing hyphens
        
        return permalink;
    }

    function generatePermalink() {
        const title = $('input[name="title"]').val();
        if (!title) {
            $('#permalink').val('');
            return;
        }

        $.ajax({
            url: '{{ route("faqs.generate.permalink") }}',
            type: 'POST',
            data: {
                title: title,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                $('#permalink').val(response.permalink);
                checkPermalink();
            }
        });
    }

    function checkPermalink() {
        const permalink = $('#permalink').val();

        if (!permalink) {
            $('.permalink_status').val('');
            $('.permalink_error').html('<small class="text-danger">Permalink is required.</small>');
            return;
        }

        $.ajax({
            url: '{{ route("faqs.check.permalink") }}',
            type: 'POST',
            data: {
                permalink: permalink,
                exclude_id: {{ $faq->id }},
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.available) {
                    $('.permalink_error').html('<small class="text-success">✓ Permalink is available.</small>');
                } else {
                    $('.permalink_error').html('<small class="text-danger">✗ ' + response.message + '</small>');
                }
            }
        });
    }

    // Check permalink on input
    $('#permalink').on('input', function() {
        clearTimeout(this.checkTimeout);
        this.checkTimeout = setTimeout(checkPermalink, 500);
    });
</script>
