@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Job Listings') }}</h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Job Listings
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ url('/admin/jobs/create') }}'"
                    class="btn btn-success global-create-btn">
                    <i class="fa-solid fa-circle-plus me-1"></i>Create Job</button>
                <button type="button" onclick="window.location = '{{ url('/admin/job-applications') }}'"
                    class="btn btn-primary global-list-btn">
                    <i class="fas fa-list me-1"></i> Job Applications
                </button>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-primary-subtle text-primary rounded fs-3">
                                <i class="bi bi-briefcase"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">TOTAL JOBS</p>
                            <h4 class="mb-0">{{ $jobs->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-success-subtle text-success rounded fs-3">
                                <i class="bi bi-check-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">ACTIVE</p>
                            <h4 class="mb-0">{{ $jobs->where('is_active', true)->where('valid_from', '<=', now())->where('valid_until', '>=', now())->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-warning-subtle text-warning rounded fs-3">
                                <i class="bi bi-clock"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">UPCOMING</p>
                            <h4 class="mb-0">{{ $jobs->where('is_active', true)->where('valid_from', '>', now())->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-danger-subtle text-danger rounded fs-3">
                                <i class="bi bi-x-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">EXPIRED</p>
                            <h4 class="mb-0">{{ $jobs->where('valid_until', '<', now())->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="bi bi-funnel me-2"></i>Advanced Filters
            </h5>
            <button class="btn btn-primary btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse">
                <i class="bi bi-chevron-down"></i>
            </button>
        </div>
        <div class="collapse" id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.jobs.index') }}" id="filterForm">
                    <div class="row g-3">
                        <div class="col-xl-3 col-md-4">
                            <label class="form-label">Keyword</label>
                            <input type="text" class="form-control" name="keyword" value="{{ request('keyword') }}" placeholder="Search title, description, location...">
                        </div>
                        <div class="col-xl-2 col-md-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="">All Status</option>
                                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                <option value="expired" {{ request('status') == 'expired' ? 'selected' : '' }}>Expired</option>
                                <option value="upcoming" {{ request('status') == 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-md-4">
                            <label class="form-label">User Type</label>
                            <select class="form-select" name="user_type">
                                <option value="">All Types</option>
                                <option value="driver" {{ request('user_type') == 'driver' ? 'selected' : '' }}>Driver</option>
                                <option value="mover" {{ request('user_type') == 'mover' ? 'selected' : '' }}>Mover</option>
                                <option value="supervisor" {{ request('user_type') == 'supervisor' ? 'selected' : '' }}>Supervisor</option>
                                <option value="manager" {{ request('user_type') == 'manager' ? 'selected' : '' }}>Manager</option>
                                <option value="admin" {{ request('user_type') == 'admin' ? 'selected' : '' }}>Admin</option>
                                <option value="other" {{ request('user_type') == 'other' ? 'selected' : '' }}>Other</option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <label class="form-label">Employment Type</label>
                            <select class="form-select" name="employment_type">
                                <option value="">All Types</option>
                                <option value="full_time" {{ request('employment_type') == 'full_time' ? 'selected' : '' }}>Full Time</option>
                                <option value="part_time" {{ request('employment_type') == 'part_time' ? 'selected' : '' }}>Part Time</option>
                                <option value="contract" {{ request('employment_type') == 'contract' ? 'selected' : '' }}>Contract</option>
                                <option value="temporary" {{ request('employment_type') == 'temporary' ? 'selected' : '' }}>Temporary</option>
                                <option value="internship" {{ request('employment_type') == 'internship' ? 'selected' : '' }}>Internship</option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <label class="form-label">Date Filter</label>
                            <select class="form-select" name="date_filter">
                                <option value="">All Time</option>
                                <option value="today" {{ request('date_filter') == 'today' ? 'selected' : '' }}>Today</option>
                                <option value="yesterday" {{ request('date_filter') == 'yesterday' ? 'selected' : '' }}>Yesterday</option>
                                <option value="7days" {{ request('date_filter') == '7days' ? 'selected' : '' }}>Last 7 Days</option>
                                <option value="30days" {{ request('date_filter') == '30days' ? 'selected' : '' }}>Last 30 Days</option>
                                <option value="this_month" {{ request('date_filter') == 'this_month' ? 'selected' : '' }}>This Month</option>
                                <option value="last_month" {{ request('date_filter') == 'last_month' ? 'selected' : '' }}>Last Month</option>
                            </select>
                        </div>
                        <div class="col-lg-1 col-md-12">
                            
                            <div class="d-flex gap-1 mt-xl-4 pt-xl-1">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i>
                                </button>
                                <button type="button" class="btn btn-secondary" onclick="clearFilters()">
                                    <i class="fa-solid fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <h5 class="card-title mb-0">
                <i class="bi bi-briefcase me-2"></i>Jobs Table
            </h5>
            <div class="d-flex align-items-center flex-wrap gap-3 mt-lg-0 mt-3">
                <div class="d-flex align-items-center">
                    <label class="form-label me-2 mb-0">Show:</label>
                    <select class="form-select form-select-sm" style="width: auto;" id="entriesPerPage">
                        <option value="10">10</option>
                        <option value="25" selected>25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                    <span class="ms-1">entries</span>
                </div>
                <div class="d-flex align-items-center">
                    <label class="form-label me-2 mb-0">Search:</label>
                    <input type="text" class="form-control form-control-sm" placeholder="Search jobs..." id="searchInput" style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>User Type</th>
                            <th>Employment Type</th>
                            <th>Location</th>
                            <th>Salary Range</th>
                            <th>Status</th>
                            <th>Applications</th>
                            <th>Valid Period</th>
                            <th>Created At</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($jobs as $job)
                            <tr class="align-middle">
                                <td>
                                    <div class="fw-semibold">{{ $job->title }}</div>
                                    <small class="text-muted">{{ Str::limit($job->description, 50) }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-info-subtle text-info px-2 py-1">
                                        {{ ucfirst($job->user_type) }}
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-secondary-subtle text-secondary px-2 py-1">
                                        {{ ucfirst(str_replace('_', ' ', $job->employment_type)) }}
                                    </span>
                                </td>
                                <td>{{ $job->location }}</td>
                                <td>
                                    @if($job->salary_min || $job->salary_max)
                                        ${{ number_format($job->salary_min ?? 0) }} - ${{ number_format($job->salary_max ?? 0) }}
                                    @else
                                        <span class="text-muted">Not specified</span>
                                    @endif
                                </td>
                                <td class="status-cell" data-job-id="{{ $job->id }}">
                                    @if($job->is_active)
                                        @if($job->valid_from <= now() && $job->valid_until >= now())
                                            <span class="badge bg-success-subtle text-success px-3 py-2">Active</span>
                                        @elseif($job->valid_from > now())
                                            <span class="badge bg-warning-subtle text-warning px-3 py-2">Upcoming</span>
                                        @else
                                            <span class="badge bg-danger-subtle text-danger px-3 py-2">Expired</span>
                                        @endif
                                    @else
                                        <span class="badge bg-danger-subtle text-danger px-3 py-2">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-primary-subtle text-primary px-2 py-1">
                                        {{ $job->applications_count ?? 0 }}
                                    </span>
                                </td>
                                <td>
                                    <small>
                                        <div>{{ $job->valid_from->format('M d, Y') }}</div>
                                        <div class="text-muted">to {{ $job->valid_until->format('M d, Y') }}</div>
                                    </small>
                                </td>
                                <td>{{ $job->created_at->format('M d, Y H:i') }}</td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm"
                                            type="button" data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <button class="dropdown-item" onclick="viewJob({{ $job->id }})">
                                                    <i class="bi bi-eye me-2"></i> View
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="editJob({{ $job->id }})">
                                                    <i class="bi bi-pencil-square me-2"></i> Edit
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="viewApplications({{ $job->id }})">
                                                    <i class="bi bi-people me-2"></i> Applications ({{ $job->applications_count ?? 0 }})
                                                </button>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="toggleJobStatus({{ $job->id }}, {{ $job->is_active ? 'false' : 'true' }}, this)">
                                                    <i class="bi bi-{{ $job->is_active ? 'pause' : 'play' }} me-2"></i> 
                                                    {{ $job->is_active ? 'Deactivate' : 'Activate' }}
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-danger"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#deleteConfirmModal{{ $job->id }}">
                                                    <i class="bi bi-trash me-2"></i> Delete
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <!-- Delete Confirmation Modal -->
                            <div class="modal fade zoomIn" id="deleteConfirmModal{{ $job->id }}" tabindex="-1"
                                aria-labelledby="deleteConfirmModalLabel{{ $job->id }}" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body p-md-5">
                                            <div class="text-center">
                                                <div class="text-danger">
                                                    <i class="bi bi-trash display-4"></i>
                                                </div>
                                                <div class="mt-4 fs-15">
                                                    <h4 class="mb-1">Are you sure?</h4>
                                                    <p class="text-muted mx-3 fs-16 mb-0">
                                                        Are you sure you want to delete
                                                        <strong>{{ $job->title }}</strong>?<br>
                                                        This action cannot be undone and will also delete all related applications.
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="d-flex gap-2 justify-content-center mt-4 mb-2">
                                                <button type="button" class="btn w-sm btn-light btn-hover"
                                                    data-bs-dismiss="modal">Cancel</button>
                                                <form action="{{ route('admin.jobs.delete') }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $job->id }}">
                                                    <button type="submit" class="btn w-sm btn-danger btn-hover">Yes, Delete It!</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Title</th>
                            <th>User Type</th>
                            <th>Employment Type</th>
                            <th>Location</th>
                            <th>Salary Range</th>
                            <th>Status</th>
                            <th>Applications</th>
                            <th>Valid Period</th>
                            <th>Created At</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Job View Modal -->
<div class="modal fade" id="jobViewModal" tabindex="-1" aria-labelledby="jobViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jobViewModalLabel">Job Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="jobViewContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Job Edit Modal -->
<div class="modal fade" id="jobEditModal" tabindex="-1" aria-labelledby="jobEditModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="jobEditModalLabel">Edit Job</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="jobEditContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        // Check if DataTable is already initialized and destroy it first
        if ($.fn.DataTable.isDataTable('#data_Table')) {
            $('#data_Table').DataTable().destroy();
        }

        // Initialize DataTable
        var table = $('#data_Table').DataTable({
            "processing": true,
            "serverSide": false,
            "responsive": true,
            "pageLength": 25,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "order": [[8, "desc"]], // Sort by Created At column descending
            "columnDefs": [
                {
                    "targets": [9], // Actions column
                    "orderable": false,
                    "searchable": false
                }
            ],
            "language": {
                "search": "",
                "lengthMenu": "",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "Showing 0 to 0 of 0 entries",
                "infoFiltered": "(filtered from _MAX_ total entries)",
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Next",
                    "previous": "Previous"
                },
                "emptyTable": "No jobs found"
            },
            "dom": '<"row"<"col-sm-12"tr>>' +
                   '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        });

        // Custom search functionality
        $('#searchInput').on('keyup', function() {
            table.search(this.value).draw();
        });

        // Custom entries per page functionality
        $('#entriesPerPage').on('change', function() {
            table.page.len(parseInt(this.value)).draw();
        });
    });

    // Clear filters function
    function clearFilters() {
        document.getElementById('filterForm').reset();
        window.location.href = "{{ route('admin.jobs.index') }}";
    }

    // View job function
    function viewJob(jobId) {
        $.ajax({
            url: "{{ route('admin.jobs.show') }}",
            type: "GET",
            data: { id: jobId },
            success: function(response) {
                const job = response;
                const html = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Job Information</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Title:</strong></td><td>${job.title}</td></tr>
                                <tr><td><strong>User Type:</strong></td><td>${job.user_type}</td></tr>
                                <tr><td><strong>Employment Type:</strong></td><td>${job.employment_type.replace('_', ' ')}</td></tr>
                                <tr><td><strong>Location:</strong></td><td>${job.location}</td></tr>
                                <tr><td><strong>Salary Range:</strong></td><td>$${job.salary_min || 0} - $${job.salary_max || 0}</td></tr>
                                <tr><td><strong>Status:</strong></td><td><span class="badge bg-${job.is_active ? 'success' : 'danger'}">${job.is_active ? 'Active' : 'Inactive'}</span></td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Additional Information</h6>
                            <table class="table table-sm">
                                <tr><td><strong>Valid From:</strong></td><td>${job.valid_from}</td></tr>
                                <tr><td><strong>Valid Until:</strong></td><td>${job.valid_until}</td></tr>
                                <tr><td><strong>Applications:</strong></td><td>${job.applications_count}</td></tr>
                                <tr><td><strong>Sort Order:</strong></td><td>${job.sort_order || 0}</td></tr>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Description</h6>
                            <div class="border p-3 rounded" style="max-height: 200px; overflow-y: auto;">
                                ${job.description.replace(/\n/g, '<br>')}
                            </div>
                        </div>
                    </div>
                `;
                $('#jobViewContent').html(html);
                $('#jobViewModal').modal('show');
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to load job details'
                });
            }
        });
    }

    // Edit job function
    function editJob(jobId) {
        window.location.href = `{{ url('/admin/jobs') }}/${jobId}/edit`;
    }

    // View applications function
    function viewApplications(jobId) {
        window.location.href = `{{ url('/admin/jobs') }}/${jobId}/applications`;
    }

    // Toggle job status function
    function toggleJobStatus(jobId, newStatus, element) {
        const statusText = newStatus === 'true' ? 'activate' : 'deactivate';
        
        Swal.fire({
            title: 'Are you sure?',
            text: `Do you want to ${statusText} this job?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: `Yes, ${statusText} it!`
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: "{{ route('admin.jobs.changeStatus') }}",
                    type: "POST",
                    data: { id: jobId },
                    beforeSend: function() {
                        $(element).prop('disabled', true);
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Status Updated',
                                text: response.message,
                                timer: 1500,
                                showConfirmButton: false
                            });

                            // Reload the page to update the status
                            location.reload();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message || 'Failed to update status'
                            });
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = 'Something went wrong';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage
                        });
                    },
                    complete: function() {
                        $(element).prop('disabled', false);
                    }
                });
            }
        });
    }
</script>

