@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<style>
    .form-check-label {
        font-weight: 500;
        color: #6c757d;
    }

    .form-check-input:checked+.form-check-label {
        color: #198754;
    }
</style>
<div class="page-content">
    <div class="container-fluid">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">

                    <div>
                        <h4 class="mb-1">{{ __('Service Edit') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('services.index') }}" class="link-primary text-decoration-none">
                                        Services
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Service Edit
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('services.index') }}" class="btn btn-primary mt-md-3 global-list-btn">
                            <i class="bi bi-list me-1"></i> Service List
                        </a>
                        <a href="{{ route('services.show', $service) }}" class="btn btn-warning mt-md-3 global-list-btn">
                            <i class="bi bi-eye me-1"></i> View Service
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <form id="service-edit-form" method="POST" action="{{ route('services.update', $service) }}" enctype="multipart/form-data"
            autocomplete="off" class="needs-validation" novalidate>
            @csrf
            @method('PUT')
            <input type="hidden" name="updated_by" value="{{ $logged_in_user->id }}">
            <div class="row">
                <div class="col-xl-9 col-lg-8">
                    <!-- Service Details -->
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex">
                                <div class="avatar-sm me-3">
                                    <div class="avatar-title rounded-circle bg-light text-primary fs-20">
                                        <i class="bi bi-gear"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <h5 class="card-title mb-1">Service Details</h5>
                                    <p class="text-muted mb-0">Enter essential service information below.</p>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Title -->
                            <div class="mb-3">
                                <label class="form-label" for="service-title-input">Service Title <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control addTitle" name="title" id="service-title-input"
                                    placeholder="e.g. Professional Moving Services" value="{{ old('title', $service->title) }}"
                                    required>
                                <div class="invalid-feedback">Please enter a service title.</div>
                            </div>

                            <!-- Permalink -->
                            <div class="form-group mb-3">
                                <label class="form-control-label active">Permalink: <span
                                        class="tx-danger">*</span></label>
                                <div class="input-group">
                                    <div class="input-group-prepend custom-permalink">
                                        <span class="input-group-text">{{ url('/') }}/service/</span>
                                    </div>
                                    <input class="form-control restrict-input-alphabets permalink" id="permalink"
                                        type="text" name="permalink" value="{{ old('permalink', $service->permalink) }}"
                                        placeholder="professional-moving-services" required>
                                </div>
                                <div class="text-danger permalink_error"></div>
                                <input type="hidden" class="permalink_status" name="permalink_status"
                                    value="{{ old('permalink_status', '1') }}" required>
                            </div>

                            <!-- Description -->
                            <div class="mb-3">
                                <label class="form-label">Short Description</label>
                                <textarea name="description" class="form-control" rows="4" placeholder="Short description of the service...">{{ old('description', $service->description) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Service Content Section -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Service Content</h5>
                            <small class="text-muted">Add detailed content for your service including formatting and
                                media.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Service Content</label>
                                <textarea name="content" class="form-control rich-editor" rows="15">{{ old('content', $service->content) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- SEO Section -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">SEO Settings</h5>
                            <small class="text-muted">Optimize your service for search engines.</small>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">SEO Title</label>
                                <input type="text" class="form-control" name="_seo_title" 
                                    placeholder="SEO optimized title" value="{{ old('_seo_title', $service->_seo_title) }}">
                                <small class="text-muted">Recommended: 50-60 characters</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">SEO Description</label>
                                <textarea name="_seo_description" class="form-control" rows="3" 
                                    placeholder="SEO meta description">{{ old('_seo_description', $service->_seo_description) }}</textarea>
                                <small class="text-muted">Recommended: 150-160 characters</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">SEO Tags</label>
                                <input type="text" class="form-control" name="_seo_tags" 
                                    placeholder="tag1, tag2, tag3" value="{{ old('_seo_tags', $service->_seo_tags) }}">
                                <small class="text-muted">Separate tags with commas</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Canonical URL</label>
                                <input type="url" class="form-control" name="_canonical_url" 
                                    placeholder="https://example.com/canonical-url" value="{{ old('_canonical_url', $service->_canonical_url) }}">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Schema Markup</label>
                                <textarea name="_schema_markup" class="form-control" rows="4" 
                                    placeholder="JSON-LD structured data">{{ old('_schema_markup', $service->_schema_markup) }}</textarea>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Page Index</label>
                                <div class="form-check form-switch">
                                    <!-- Hidden input comes BEFORE checkbox to be overridden when checked -->
                                    <input type="hidden" name="_page_index" value="0">
                                    <input class="form-check-input" type="checkbox" id="pageIndexToggle"
                                        name="_page_index" value="1"
                                        {{ old('_page_index', $service->_page_index) == '1' ? 'checked' : '' }}>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar Column -->
                <div class="col-xl-3 col-lg-4">
                    <!-- Status -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Status</h5>
                        </div>
                        <div class="card-body">
                            <label for="service-status" class="form-label">Active Status</label>
                            <select name="active" class="form-select" id="service-status">
                                <option value="0" @if (old('active', $service->active) == 0) selected @endif>Draft</option>
                                <option value="1" @if (old('active', $service->active) == 1) selected @endif>Published</option>
                                <option value="2" @if (old('active', $service->active) == 2) selected @endif>Private</option>
                            </select>
                        </div>
                    </div>

                    <!-- Media -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Service Images</h5>
                        </div>
                        <div class="card-body">
                            <!-- Current Cover Image -->
                            @if($service->cover_image)
                                <div class="mb-3">
                                    <label class="form-label">Current Cover Image</label>
                                    <div class="mb-2">
                                        <img src="{{ asset($service->cover_image) }}" alt="Current cover" class="img-thumbnail" style="max-width: 200px;">
                                    </div>
                                </div>
                            @endif

                            <!-- Cover Image -->
                            <div class="mb-3">
                                <label class="form-label">{{ $service->cover_image ? 'Update Cover Image' : 'Cover Image' }}</label>
                                <input class="form-control" type="file" name="cover_image" accept="image/*"
                                    id="coverImageInput">
                                <small class="text-muted">Recommended: 1200x630px</small>
                                <div id="coverImagePreview" class="mt-2"></div>
                            </div>

                            <!-- Current Featured Images -->
                            @if($service->featured_images)
                                <div class="mb-3">
                                    <label class="form-label">Current Featured Images</label>
                                    <div class="mb-2">
                                        @foreach($service->featured_images_array as $image)
                                            <img src="{{ asset($image) }}" alt="Featured image" class="img-thumbnail me-2 mb-2" style="max-width: 100px;">
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            <!-- Featured Images -->
                            <div class="mb-3">
                                <label class="form-label">{{ $service->featured_images ? 'Update Featured Images' : 'Featured Images' }}</label>
                                <input class="form-control" type="file" name="featured_images[]" accept="image/*"
                                    id="featuredImagesInput" multiple>
                                <div id="featuredImagesPreview" class="mt-2"></div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" for="fimage_alt_text">Feature Image Alt Text</label>
                                <input type="text" class="form-control" name="fimage_alt_text"
                                    id="fimage_alt_text" placeholder="Please enter a Feature Image alt Text"
                                    value="{{ old('fimage_alt_text', $service->fimage_alt_text) }}">
                                <div class="invalid-feedback">Please enter a Feature Image alt Text.</div>
                            </div>
                        </div>
                    </div>

                    <div class="text-end mb-3">
                        <button type="submit" class="btn btn-success w-100">
                            <i class="bi bi-check-circle me-1"></i>Update Service
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    // Wait for document ready
    $(document).ready(function() {
        // Title to permalink conversion
        $('.addTitle').on('input', function() {
            var title = $(this).val();
            var permalink = title.toLowerCase()
                .replace(/[^a-z0-9\s-]/g, '') // Remove special characters
                .replace(/\s+/g, '-') // Replace spaces with hyphens
                .replace(/-+/g, '-') // Replace multiple hyphens with single
                .trim('-'); // Remove leading/trailing hyphens
            
            $('#permalink').val(permalink);
            checkPermalink();
        });

        // Permalink validation
        $('#permalink').on('input', function() {
            checkPermalink();
        });

        // Image preview functionality
        $('#coverImageInput').on('change', function(e) {
            var file = e.target.files[0];
            if (file) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#coverImagePreview').html('<img src="' + e.target.result + '" class="img-thumbnail" style="max-width: 200px;">');
                };
                reader.readAsDataURL(file);
            }
        });

        $('#featuredImagesInput').on('change', function(e) {
            var files = e.target.files;
            var preview = $('#featuredImagesPreview');
            preview.empty();
            
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                var reader = new FileReader();
                reader.onload = function(e) {
                    preview.append('<img src="' + e.target.result + '" class="img-thumbnail me-2 mb-2" style="max-width: 100px;">');
                };
                reader.readAsDataURL(file);
            }
        });

    });

    function checkPermalink() {
        var permalink = $('#permalink').val();

        if (!permalink) {
            $('.permalink_status').val('');
            $('.permalink_error').html('<small class="text-danger">Permalink is required.</small>');
            return;
        }

        $.ajax({
            url: '{{ route('services.check.permalink') }}',
            method: 'POST',
            data: {
                permalink: permalink,
                exclude_id: {{ $service->id }},
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            dataType: 'json',
            success: function(response) {
                $('.permalink_status').val('1');
                $('.permalink_error').html('<small class="text-success">Permalink is available.</small>');
            },
            error: function(xhr, status, error) {
                $('.permalink_status').val('');
                $('.permalink_error').html(
                    '<small class="text-danger">This permalink already exists or is invalid. Please change it.</small>'
                );
            }
        });
    }
</script>

<script>
    $(document).ready(function() {
        // Check if Summernote is loaded
        if (typeof $.fn.summernote === 'undefined') {
            return;
        }
        
        // Ensure Summernote is initialized for service content
        if ($('textarea[name="content"]').length && !$('textarea[name="content"]').hasClass('note-editable')) {
            $('textarea[name="content"]').summernote({
                height: 400,
                minHeight: 300,
                maxHeight: 600,
                focus: false,
                disableDragAndDrop: true,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                followingToolbar: false,
                dialogsInBody: true,
                fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
                fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                shortcuts: false,
                popover: {
                    image: [
                        ['image', ['resizeFull', 'resizeHalf', 'resizeQuarter', 'resizeNone']],
                        ['float', ['floatLeft', 'floatRight', 'floatNone']],
                        ['remove', ['removeMedia']]
                    ],
                    link: [
                        ['link', ['linkDialogShow', 'unlink']]
                    ],
                    table: [
                        ['add', ['addRowDown', 'addRowUp', 'addColLeft', 'addColRight']],
                        ['delete', ['deleteRow', 'deleteCol', 'deleteTable']],
                    ],
                    air: [
                        ['color', ['color']],
                        ['font', ['bold', 'underline', 'clear']]
                    ]
                },
                callbacks: {
                    onPaste: function(e) {
                        setTimeout(() => {
                            var content = $(this).summernote('code');
                            // Clean Google Docs content
                            content = content.replace(/<meta[^>]*>/gi, '');
                            content = content.replace(/<link[^>]*>/gi, '');
                            content = content.replace(/<!\[if[^>]*>.*?<!\[endif\]>/gsi, '');
                            content = content.replace(/<!--.*?-->/gs, '');
                            content = content.replace(/\s*style\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/\s*class\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/\s*data-[a-zA-Z0-9\-]*\s*=\s*["'][^"']*["']/gi, '');
                            content = content.replace(/<o:p[^>]*>.*?<\/o:p>/gsi, '');
                            content = content.replace(/<w:[^>]*>.*?<\/w:[^>]*>/gsi, '');
                            content = content.replace(/<m:[^>]*>.*?<\/m:[^>]*>/gsi, '');
                            content = content.replace(/<v:[^>]*>.*?<\/v:[^>]*>/gsi, '');
                            content = content.replace(/<font[^>]*>(.*?)<\/font>/gsi, '$1');
                            content = content.replace(/<p[^>]*><\/p>/gi, '');
                            content = content.replace(/<p[^>]*>/gi, '<p>');
                            content = content.replace(/<span[^>]*font-weight:\s*bold[^>]*>(.*?)<\/span>/gsi, '<strong>$1</strong>');
                            content = content.replace(/<span[^>]*font-style:\s*italic[^>]*>(.*?)<\/span>/gsi, '<em>$1</em>');
                            content = content.replace(/<span[^>]*>/gi, '');
                            content = content.replace(/<\/span>/gi, '');
                            content = content.replace(/<div[^>]*>/gi, '');
                            content = content.replace(/<\/div>/gi, '');
                            content = content.replace(/\s+/g, ' ');
                            content = content.replace(/\u00A0/g, ' ');
                            content = content.replace(/&nbsp;/g, ' ');
                            if (content.length > 50000) {
                                content = content.substring(0, 50000) + '...';
                            }
                            $(this).summernote('code', content);
                        }, 100);
                    },
                    onChange: function(contents, $editable) {
                        $(this).val(contents);
                    },
                    onInit: function() {
                        // Fix dropdown menus after initialization
                        setTimeout(function() {
                            $('.note-editor .dropdown-menu').css('z-index', '9999');
                        }, 100);
                    }
                }
            });
        }
    });
</script>

