@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">
        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('Service Details') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('services.index') }}" class="link-primary text-decoration-none">
                                        Services
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    Service Details
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('services.index') }}" class="btn btn-primary">
                            <i class="bi bi-list me-1"></i> Service List
                        </a>
                        <a href="{{ route('services.edit', $service) }}" class="btn btn-success">
                            <i class="bi bi-pencil me-1"></i> Edit Service
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-8 col-lg-7">
                <!-- Service Details -->
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex">
                            <div class="avatar-sm me-3">
                                <div class="avatar-title rounded-circle bg-light text-primary fs-20">
                                    <i class="bi bi-gear"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h5 class="card-title mb-1">{{ $service->title }}</h5>
                                <p class="text-muted mb-0">{{ $service->permalink }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($service->description)
                            <div class="mb-4">
                                <h6>Description</h6>
                                <p class="text-muted">{{ $service->description }}</p>
                            </div>
                        @endif

                        @if($service->content)
                            <div class="mb-4">
                                <h6>Content</h6>
                                <div class="border rounded p-3">
                                    {!! $service->content !!}
                                </div>
                            </div>
                        @endif

                        @if($service->cover_image)
                            <div class="mb-4">
                                <h6>Cover Image</h6>
                                <img src="{{ asset($service->cover_image) }}" alt="{{ $service->title }}" class="img-fluid rounded">
                            </div>
                        @endif

                        @if($service->featured_images)
                            <div class="mb-4">
                                <h6>Featured Images</h6>
                                <div class="row">
                                    @foreach($service->featured_images_array as $image)
                                        <div class="col-md-3 mb-3">
                                            <img src="{{ asset($image) }}" alt="Featured image" class="img-fluid rounded">
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- SEO Information -->
                @if($service->_seo_title || $service->_seo_description || $service->_seo_tags)
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">SEO Information</h5>
                        </div>
                        <div class="card-body">
                            @if($service->_seo_title)
                                <div class="mb-3">
                                    <h6>SEO Title</h6>
                                    <p class="text-muted">{{ $service->_seo_title }}</p>
                                </div>
                            @endif

                            @if($service->_seo_description)
                                <div class="mb-3">
                                    <h6>SEO Description</h6>
                                    <p class="text-muted">{{ $service->_seo_description }}</p>
                                </div>
                            @endif

                            @if($service->_seo_tags)
                                <div class="mb-3">
                                    <h6>SEO Tags</h6>
                                    <p class="text-muted">{{ $service->_seo_tags }}</p>
                                </div>
                            @endif

                            @if($service->_canonical_url)
                                <div class="mb-3">
                                    <h6>Canonical URL</h6>
                                    <p class="text-muted">{{ $service->_canonical_url }}</p>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <div class="col-xl-4 col-lg-5">
                <!-- Service Status -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Service Status</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h6>Status</h6>
                            {!! $service->getStatusBadge() !!}
                        </div>

                        <div class="mb-3">
                            <h6>Created</h6>
                            <p class="text-muted mb-1">{{ $service->created_at->format('M d, Y') }}</p>
                            <small class="text-muted">{{ $service->created_at->format('h:i A') }}</small>
                        </div>

                        @if($service->updated_at != $service->created_at)
                            <div class="mb-3">
                                <h6>Last Updated</h6>
                                <p class="text-muted mb-1">{{ $service->updated_at->format('M d, Y') }}</p>
                                <small class="text-muted">{{ $service->updated_at->format('h:i A') }}</small>
                            </div>
                        @endif

                        @if($service->creator)
                            <div class="mb-3">
                                <h6>Created By</h6>
                                <p class="text-muted">{{ $service->creator->name }}</p>
                            </div>
                        @endif

                        @if($service->updater)
                            <div class="mb-3">
                                <h6>Updated By</h6>
                                <p class="text-muted">{{ $service->updater->name }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('services.edit', $service) }}" class="btn btn-success">
                                <i class="bi bi-pencil me-1"></i> Edit Service
                            </a>
                            
                            <button type="button" class="btn btn-danger" onclick="deleteService({{ $service->id }})">
                                <i class="bi bi-trash me-1"></i> Delete Service
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this service? This action will move it to trash.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

@include('Admin.Includes.footer')

<script>
function deleteService(serviceId) {
    document.getElementById('deleteForm').action = `/admin/services/${serviceId}`;
    new bootstrap.Modal(document.getElementById('deleteModal')).show();
}
</script>
