@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Testimonials Management') }}</h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Testimonials
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ route('admin.testimonials.create') }}'"
                    class="btn btn-success global-create-btn">
                    <i class="fa-solid fa-plus me-1"></i>Add New Testimonial</button>
            </div>
        </div>
    </div>

    <!-- Advanced Filters Card -->
    <div class="card shadow-sm mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="bi bi-funnel me-2"></i>Advanced Filters
                </h6>
                <button class="btn btn-sm btn-outline-primary" type="button" data-bs-toggle="collapse"
                    data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse">
                    <i class="bi bi-chevron-down"></i>
                </button>
            </div>
        </div>
        <div class="collapse {{ request()->hasAny(['keyword', 'status', 'rating']) ? 'show' : '' }}" id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.testimonials.index') }}" class="row g-3">
                    <div class="col-lg-3 col-md-4">
                        <label for="keyword_filter" class="form-label">Search</label>
                        <div class="input-group">
                            <span class="input-group-text"><i class="bi bi-search"></i></span>
                            <input type="text" class="form-control" id="keyword_filter" name="keyword"
                                value="{{ request('keyword') }}" placeholder="Search customer name, company...">
                        </div>
                    </div>

                    <div class="col-lg-2 col-md-4">
                        <label for="status_filter" class="form-label">Status</label>
                        <select class="form-select" id="status_filter" name="status">
                            <option value="">All Status</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>

                    <div class="col-lg-2 col-md-4">
                        <label for="rating_filter" class="form-label">Minimum Rating</label>
                        <select class="form-select" id="rating_filter" name="rating">
                            <option value="">All Ratings</option>
                            <option value="5" {{ request('rating') == '5' ? 'selected' : '' }}>5 Stars</option>
                            <option value="4" {{ request('rating') == '4' ? 'selected' : '' }}>4+ Stars</option>
                            <option value="3" {{ request('rating') == '3' ? 'selected' : '' }}>3+ Stars</option>
                            <option value="2" {{ request('rating') == '2' ? 'selected' : '' }}>2+ Stars</option>
                            <option value="1" {{ request('rating') == '1' ? 'selected' : '' }}>1+ Stars</option>
                        </select>
                    </div>

                    <div class="col-lg-3 col-md-12 d-flex align-items-end">
                        <div class="btn-group w-100" role="group">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-funnel me-1"></i>Apply Filters
                            </button>
                            <a href="{{ route('admin.testimonials.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-clockwise me-1"></i>Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <h5 class="card-title mb-0">Testimonials Table</h5>
            <div class="text-muted">
                @if(request()->hasAny(['keyword', 'status', 'rating']))
                    Filtered Results: {{ $testimonials->count() }}
                    <a href="{{ route('admin.testimonials.index') }}" class="btn btn-sm btn-outline-secondary ms-2">
                        <i class="fa-solid fa-times me-1"></i>Clear Filters
                    </a>
                @else
                    Total Testimonials: {{ $testimonials->count() }}
                @endif
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless">
                    <thead>
                        <tr>
                            <th>Customer Info</th>
                            <th>Short Description</th>
                            <th>Rating</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($testimonials as $testimonial)
                            <tr class="align-middle">
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($testimonial->customer_image)
                                            <img src="{{ asset($testimonial->customer_image) }}" alt="Customer" class="img-thumbnail me-3" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;">
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center me-3 rounded-circle" style="width: 50px; height: 50px;">
                                                <i class="fas fa-user text-muted"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <div class="fw-semibold">{{ $testimonial->customer_name }}</div>
                                            @if($testimonial->customer_position)
                                                <small class="text-muted">{{ $testimonial->customer_position }}</small>
                                            @endif
                                            @if($testimonial->company_name)
                                                <div><small class="text-muted"><i class="fa-solid fa-building me-1"></i>{{ $testimonial->company_name }}</small></div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($testimonial->short_description)
                                        <div>{{ Str::limit($testimonial->short_description, 100) }}</div>
                                    @else
                                        <span class="text-muted">No description</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="text-warning me-2">
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= floor($testimonial->rating))
                                                    <i class="fas fa-star"></i>
                                                @elseif($i - 0.5 <= $testimonial->rating)
                                                    <i class="fas fa-star-half-alt"></i>
                                                @else
                                                    <i class="far fa-star"></i>
                                                @endif
                                            @endfor
                                        </div>
                                        <span class="fw-bold">{{ number_format($testimonial->rating, 1) }}</span>
                                    </div>
                                </td>
                                <td>
                                    @if($testimonial->is_active)
                                        <span class="badge bg-success px-2 py-1">
                                            <i class="fa-solid fa-check-circle me-1"></i>Active
                                        </span>
                                    @else
                                        <span class="badge bg-danger px-2 py-1">
                                            <i class="fa-solid fa-times-circle me-1"></i>Inactive
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    <small>{{ $testimonial->created_at->format('M d, Y') }}</small>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm"
                                            type="button" data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <button class="dropdown-item" onclick="viewTestimonial({{ $testimonial->id }})">
                                                    <i class="bi bi-eye me-2"></i> View Details
                                                </button>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('admin.testimonials.edit', $testimonial->id) }}">
                                                    <i class="bi bi-pencil me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="changeTestimonialStatus({{ $testimonial->id }}, this)">
                                                    <i class="bi bi-toggle-{{ $testimonial->is_active ? 'on' : 'off' }} me-2"></i> 
                                                    {{ $testimonial->is_active ? 'Deactivate' : 'Activate' }}
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-danger" onclick="deleteTestimonial({{ $testimonial->id }})">
                                                    <i class="bi bi-trash me-2"></i> Delete
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                        <tr class="no-data-row">
                            <td colspan="6" class="text-center text-muted py-4">No testimonials found</td>
                        </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Customer Info</th>
                            <th>Short Description</th>
                            <th>Rating</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Testimonial View Modal -->
<div class="modal fade" id="testimonialViewModal" tabindex="-1" aria-labelledby="testimonialViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="testimonialViewModalLabel">Testimonial Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0">
                <div class="testimonial-details-container" style="max-height: 70vh; overflow-y: auto; padding: 1rem;">
                    <div id="testimonialViewContent">
                        <!-- Content will be loaded here -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .testimonial-details-container::-webkit-scrollbar {
        width: 8px;
    }
    
    .testimonial-details-container::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 4px;
    }
    
    .testimonial-details-container::-webkit-scrollbar-thumb {
        background: #c1c1c1;
        border-radius: 4px;
    }
    
    .testimonial-details-container::-webkit-scrollbar-thumb:hover {
        background: #a8a8a8;
    }

    .badge {
        font-size: 0.75rem;
        font-weight: 500;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        if ($.fn.DataTable.isDataTable('#data_Table')) {
            $('#data_Table').DataTable().destroy();
        }
        
        $('#data_Table').DataTable({
            responsive: true,
            autoWidth: false,
            columnDefs: [
                { orderable: false, targets: -1 }
            ],
            language: {
                searchPlaceholder: 'Search testimonials...',
                sSearch: ''
            },
            "order": [[0, "desc"]],
            "pageLength": 10,
            "lengthMenu": [[10, 25, 50, 100], [10, 25, 50, 100]],
            "dom": '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6"f>>rtip',
        });
    });

    function viewTestimonial(testimonialId) {
        const viewUrl = "{{ route('admin.testimonials.show', ':id') }}".replace(':id', testimonialId);
        
        $.ajax({
            url: viewUrl,
            type: "GET",
            success: function(response) {
                $('#testimonialViewContent').html(response);
                $('#testimonialViewModal').modal('show');
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to load testimonial details'
                });
            }
        });
    }

    function changeTestimonialStatus(testimonialId, element) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You want to change the testimonial status?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, change it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                const changeStatusUrl = "{{ route('admin.testimonials.changeStatus', ':id') }}".replace(':id', testimonialId);
                
                $.ajax({
                    url: changeStatusUrl,
                    type: "POST",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Status Updated',
                                text: response.message,
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message || 'Failed to update status'
                            });
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = 'Something went wrong';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage
                        });
                    }
                });
            }
        });
    }

    function deleteTestimonial(testimonialId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                const deleteUrl = "{{ route('admin.testimonials.destroy', ':id') }}".replace(':id', testimonialId);
                
                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        if (response.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.message || 'Testimonial has been deleted.',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.message || 'Failed to delete testimonial'
                            });
                        }
                    },
                    error: function(xhr) {
                        let errorMessage = 'Something went wrong';
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: errorMessage
                        });
                    }
                });
            }
        });
    }
</script>

@include('Admin.Includes.footer')

