<div class="testimonial-details-content p-4">
    <div class="row mb-4 border-bottom pb-3">
        <div class="col-md-4 text-center">
            @if($testimonial->customer_image)
                <img src="{{ asset($testimonial->customer_image) }}" alt="Customer image" 
                    class="img-thumbnail rounded-circle mb-3" style="max-width: 150px; max-height: 150px; object-fit: cover;">
            @else
                <div class="bg-light d-flex align-items-center justify-content-center rounded-circle mx-auto mb-3" 
                    style="width: 150px; height: 150px;">
                    <i class="fas fa-user fa-3x text-muted"></i>
                </div>
            @endif
        </div>
        <div class="col-md-8">
            <h4 class="mb-2">{{ $testimonial->customer_name }}</h4>
            @if($testimonial->customer_position)
                <p class="text-muted mb-1"><i class="fa-solid fa-briefcase me-2"></i>{{ $testimonial->customer_position }}</p>
            @endif
            @if($testimonial->company_name)
                <p class="text-muted mb-3"><i class="fa-solid fa-building me-2"></i>{{ $testimonial->company_name }}</p>
            @endif
            
            <div class="mb-3">
                <label class="form-label fw-bold">Rating:</label>
                <div class="d-flex align-items-center">
                    <div class="text-warning me-2">
                        @for($i = 1; $i <= 5; $i++)
                            @if($i <= floor($testimonial->rating))
                                <i class="fas fa-star fa-lg"></i>
                            @elseif($i - 0.5 <= $testimonial->rating)
                                <i class="fas fa-star-half-alt fa-lg"></i>
                            @else
                                <i class="far fa-star fa-lg"></i>
                            @endif
                        @endfor
                    </div>
                    <span class="fw-bold fs-5">{{ number_format($testimonial->rating, 1) }} / 5.0</span>
                </div>
            </div>

            <div class="mb-2">
                <span class="badge {{ $testimonial->is_active ? 'bg-success' : 'bg-danger' }}">
                    {{ $testimonial->is_active ? 'Active' : 'Inactive' }}
                </span>
            </div>
        </div>
    </div>

    @if($testimonial->short_description)
        <div class="mb-4">
            <h6 class="text-primary mb-2">Short Description</h6>
            <p class="text-muted">{{ $testimonial->short_description }}</p>
        </div>
    @endif

    @if($testimonial->long_description)
        <div class="mb-4">
            <h6 class="text-primary mb-2">Long Description</h6>
            <div class="text-muted">{!! nl2br(e($testimonial->long_description)) !!}</div>
        </div>
    @endif

    <div class="row mt-4 border-top pt-3">
        <div class="col-md-6">
            <table class="table table-sm table-borderless">
                <tr><td class="fw-bold">Created:</td><td>{{ $testimonial->created_at->format('M d, Y H:i:s') }}</td></tr>
                <tr><td class="fw-bold">Updated:</td><td>{{ $testimonial->updated_at->format('M d, Y H:i:s') }}</td></tr>
            </table>
        </div>
        <div class="col-md-6">
            <table class="table table-sm table-borderless">
                @if($testimonial->creator)
                    <tr><td class="fw-bold">Created By:</td><td>{{ $testimonial->creator->name }}</td></tr>
                @endif
            </table>
        </div>
    </div>
</div>

<style>
    .testimonial-details-content .table-borderless td {
        padding: 0.5rem;
        vertical-align: middle;
    }
    
    .testimonial-details-content h6 {
        font-size: 1.1rem;
        font-weight: 600;
    }
</style>

