@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
    $isEdit = true;
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">
                        Edit Truck
                    </h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.trucks.index') }}" class="link-primary text-decoration-none">
                                Truck Management
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Edit
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ route('admin.trucks.index') }}'"
                    class="btn btn-primary global-list-btn">
                    <i class="bi bi-list me-1"></i>Trucks List</button>
            </div>
        </div>
    </div>

    <!-- Alerts Section -->
    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Main Form -->
    <form method="POST" action="{{ route('admin.trucks.update', $truck->id) }}" id="truckForm" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="row">
            <div class="col-12">
                <!-- Basic Information -->
                <div class="card shadow-sm mb-3">
                    <div class="card-header py-2">
                        <h6 class="card-title fw-bold mb-0">
                            <i class="fas fa-truck me-2"></i>Basic Information
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Truck Name <span class="text-danger">*</span></label>
                                    <input class="form-control" type="text" name="truck_name" 
                                        value="{{ old('truck_name', $truck->truck_name ?? '') }}" 
                                        placeholder="Enter truck name" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Truck Type <span class="text-danger">*</span></label>
                                    <select class="form-select" name="truck_type" required>
                                        <option value="">Select truck type</option>
                                        <option value="light_rigid" {{ old('truck_type', $truck->truck_type ?? '') == 'light_rigid' ? 'selected' : '' }}>Light</option>
                                        <option value="medium_rigid" {{ old('truck_type', $truck->truck_type ?? '') == 'medium_rigid' ? 'selected' : '' }}>Medium</option>
                                        <option value="heavy_rigid" {{ old('truck_type', $truck->truck_type ?? '') == 'heavy_rigid' ? 'selected' : '' }}>Heavy</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Cubic Capacity (m³) <span class="text-danger">*</span></label>
                                    <input class="form-control" type="number" step="0.01" name="cubic_capacity" 
                                        value="{{ old('cubic_capacity', $truck->cubic_capacity ?? '') }}" 
                                        placeholder="0.00" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Truck Image</label>
                                    <input class="form-control" type="file" name="truck_image" id="truck_image_input" accept="image/*">
                                    @if(isset($truck) && $truck->truck_image)
                                        <div class="mt-2">
                                            <img src="{{ asset($truck->truck_image) }}" alt="Current truck image" class="img-thumbnail" style="max-width: 150px; max-height: 100px;">
                                            <small class="text-muted d-block">Current image</small>
                                        </div>
                                    @endif
                                    <div id="image_preview" class="mt-2" style="display: none;">
                                        <img id="preview_img" src="" class="img-thumbnail" style="max-width: 150px; max-height: 100px;">
                                        <small class="text-muted d-block">Preview</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Sort Order</label>
                                    <input class="form-control" type="number" name="sort_order" 
                                        value="{{ old('sort_order', $truck->sort_order ?? '') }}" 
                                        placeholder="0">
                                    <small class="text-muted">Lower numbers appear first</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pricing Configuration -->
                <div class="card shadow-sm mb-3">
                    <div class="card-header py-2">
                        <h6 class="card-title fw-bold mb-0">
                            <i class="fas fa-dollar-sign me-2"></i>Pricing Configuration
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label class="form-label fw-medium">Pricing Type <span class="text-danger">*</span></label>
                                    <select class="form-select" name="pricing_type" id="pricingType" required onchange="toggleCustomPricing()">
                                        <option value="">Select pricing type</option>
                                        <option value="global" {{ old('pricing_type', $truck->pricing_type ?? '') == 'global' ? 'selected' : '' }}>Use Global Pricing</option>
                                        <option value="custom" {{ old('pricing_type', $truck->pricing_type ?? '') == 'custom' ? 'selected' : '' }}>Custom Pricing</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <div class="form-check mt-4">
                                        <input class="form-check-input" type="checkbox" name="is_active" value="1" 
                                            {{ old('is_active', $truck->is_active ?? true) ? 'checked' : '' }}>
                                        <label class="form-check-label fw-medium">
                                            Active Status
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Custom Pricing Fields -->
                        <div id="customPricingFields" style="display: none;">
                            <div class="alert alert-info py-2 mb-3">
                                <i class="fas fa-info-circle me-2"></i>
                                <strong>Custom Pricing:</strong> Set specific pricing for this truck.
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group mb-3">
                                        <label class="form-label fw-medium">Per m³ Price ($)</label>
                                        <input class="form-control" type="number" step="0.01" name="custom_per_cubic_meter_price" 
                                            value="{{ old('custom_per_cubic_meter_price', $truck->custom_per_cubic_meter_price ?? '') }}" 
                                            placeholder="0.00">
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-end gap-2">
                            <button type="button" class="btn btn-secondary" onclick="window.location = '{{ route('admin.trucks.index') }}'">
                                <i class="fas fa-times me-2"></i>Cancel
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Update Truck
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
    function toggleCustomPricing() {
        const pricingType = document.getElementById('pricingType').value;
        const customFields = document.getElementById('customPricingFields');
        
        if (pricingType === 'custom') {
            customFields.style.display = 'block';
        } else {
            customFields.style.display = 'none';
        }
    }

    // Image preview functionality
    function readImageURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('preview_img').src = e.target.result;
                document.getElementById('image_preview').style.display = 'block';
            };
            reader.readAsDataURL(input.files[0]);
        }
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleCustomPricing();
        
        // Add image preview event listener
        const imageInput = document.getElementById('truck_image_input');
        if (imageInput) {
            imageInput.addEventListener('change', function() {
                readImageURL(this);
            });
        }
    });
</script>

@include('Admin.Includes.footer')
