@if(!request()->ajax())
@include('Admin.Includes.header')
<div class="page-content">
@endif

<div class="truck-details-content">
    @if(!request()->ajax())
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">
                        <i class="fa-solid fa-truck me-2"></i>Truck Details
                    </h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.trucks.index') }}" class="link-primary text-decoration-none">
                                Truck Management
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Details
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="d-flex align-items-center gap-2">
                <a href="{{ route('admin.trucks.index') }}" class="btn btn-primary">
                    <i class="bi bi-list me-1"></i>Back to List
                </a>
                <a href="{{ route('admin.trucks.edit', $truck->id) }}" class="btn btn-success">
                    <i class="bi bi-pencil me-1"></i>Edit Truck
                </a>
            </div>
        </div>
    </div>
    @endif

    <div class="row">
        <!-- Left Column -->
        <div class="col-md-8">
            <!-- Basic Information -->
            <div class="card shadow-sm mb-3">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-truck me-2"></i>Basic Information
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 150px;">Truck Name:</td>
                                    <td>{{ $truck->truck_name }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Truck Type:</td>
                                    <td>
                                        <span class="badge bg-primary">{{ ucfirst(str_replace('_', ' ', $truck->truck_type)) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Cubic Capacity:</td>
                                    <td>{{ number_format($truck->cubic_capacity, 2) }} m³</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-sm table-borderless mb-0">
                                <tr>
                                    <td class="fw-bold" style="width: 150px;">Status:</td>
                                    <td>
                                        @if($truck->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Pricing Type:</td>
                                    <td>
                                        @if($truck->pricing_type === 'custom')
                                            <span class="badge bg-primary">Custom Pricing</span>
                                        @else
                                            <span class="badge bg-info">Global Pricing</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Sort Order:</td>
                                    <td>{{ $truck->sort_order ?? 0 }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    @if($truck->truck_image)
                        <div class="mt-3 text-center">
                            <img src="{{ asset($truck->truck_image) }}" alt="Truck image" class="img-thumbnail" style="max-width: 300px; max-height: 200px;">
                        </div>
                    @endif
                </div>
            </div>

          
        </div>

        <!-- Right Column -->
        <div class="col-md-4">
            <!-- Quick Actions -->
            <div class="card shadow-sm mb-3">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-bolt me-2"></i>Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.trucks.edit', $truck->id) }}" class="btn btn-success">
                            <i class="bi bi-pencil me-2"></i>Edit Truck
                        </a>
                        @if(!request()->ajax())
                        <button type="button" class="btn btn-warning" onclick="changeTruckStatus({{ $truck->id }}, this)">
                            <i class="bi bi-toggle-{{ $truck->is_active ? 'on' : 'off' }} me-2"></i>
                            {{ $truck->is_active ? 'Deactivate' : 'Activate' }}
                        </button>
                        <button type="button" class="btn btn-danger" onclick="deleteTruck({{ $truck->id }})">
                            <i class="bi bi-trash me-2"></i>Delete Truck
                        </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if(!request()->ajax())
</div>
<script>
    function changeTruckStatus(truckId, button) {
        if (!confirm('Are you sure you want to change the truck status?')) {
            return;
        }
        
        fetch(`/admin/trucks/change-status`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ truck_id: truckId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                location.reload();
            } else {
                alert('Error: ' + (data.message || 'Failed to change status'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while changing the status');
        });
    }

    function deleteTruck(truckId) {
        if (!confirm('Are you sure you want to delete this truck? This action cannot be undone.')) {
            return;
        }
        
        fetch(`/admin/trucks/${truckId}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                window.location.href = '{{ route('admin.trucks.index') }}';
            } else {
                alert('Error: ' + (data.message || 'Failed to delete truck'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while deleting the truck');
        });
    }
</script>
@include('Admin.Includes.footer')
@endif
