<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\BlogController;
use App\Http\Controllers\API\PropertyController;
use App\Http\Controllers\API\PropertyDetailController;
use App\Http\Controllers\API\BookingController;
use App\Http\Controllers\API\BookingItemController;
use App\Http\Controllers\API\GeneralSettingController;
use App\Http\Controllers\API\QuoteController;
use App\Http\Controllers\API\StripeWebhookController;
use App\Http\Controllers\API\TrcukController;
use App\Http\Controllers\API\UserController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/










Route::prefix('categories')->group(function () {
    Route::get('/', [\App\Http\Controllers\API\CategoryController::class, 'index']);
    Route::get('/{sku}/products', [\App\Http\Controllers\API\CategoryController::class, 'getProductsByCategory']);
    Route::get('/child_categories/{sku}/products', [\App\Http\Controllers\API\CategoryController::class, 'childCategoryProducts']);
});

Route::get('/category-sliders', [\App\Http\Controllers\API\CategoryController::class, 'getcategorySliders']);

//Route::post('/update-prices', [\App\Http\Controllers\API\ProductController::class, 'updateProductPrices']);


// Auth routes
Route::post('/subscribe', [\App\Http\Controllers\API\NewLetterSubscriptionController::class, 'store']);
Route::post('/contact-us', [\App\Http\Controllers\API\NewLetterSubscriptionController::class, 'contactUs']);
Route::post('/job-application/{jobId}', [\App\Http\Controllers\API\JobApplicationController::class, 'apply']);
Route::get('/job', [\App\Http\Controllers\API\JobApplicationController::class, 'index']);
Route::get('/job/{permalink}', [\App\Http\Controllers\API\JobApplicationController::class, 'getJobByPermalink']);

Route::get('/{permalink}/faq', [\App\Http\Controllers\API\FAQController::class, 'getFAQbyPermalink']);

Route::get('/services', [\App\Http\Controllers\API\ServiceController::class, 'index']);
Route::get('/{permalink}/service', [\App\Http\Controllers\API\ServiceController::class, 'getServicebyPermalink']);

// In routes/api.php (or routes/web.php for web routes)
Route::post('/password-update', [\App\Http\Controllers\API\AuthController::class, 'updatePassword']);
Route::post('/login', [\App\Http\Controllers\API\AuthController::class, 'login']);
Route::post('/register', [\App\Http\Controllers\API\AuthController::class, 'register']);
Route::post('/check-email', [\App\Http\Controllers\API\AuthController::class, 'checkUserEmail']);
Route::post('/confirm-otp', [\App\Http\Controllers\API\AuthController::class, 'confirmOtp']);
Route::post('/update-password', [\App\Http\Controllers\API\AuthController::class, 'updatePassword']);
Route::post('/password-reset-email', [\App\Http\Controllers\Admin\AuthController::class, 'sendResetLinkEmail']);

Route::get('/user', [AuthController::class, 'getUser']);

// Protected routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [\App\Http\Controllers\API\AuthController::class, 'logout']);
    Route::get('/profile', [\App\Http\Controllers\API\ProfileController::class, 'index']);
    Route::post('/profile/update', [\App\Http\Controllers\API\ProfileController::class, 'update']);
    Route::get('user-quote', [QuoteController::class, 'getUserQuotes']);
    Route::get('user-quote-uuid/{uuid}', [QuoteController::class, 'getUserQuotesUuid']);
    Route::get('/job-applications', [\App\Http\Controllers\API\JobApplicationController::class, 'getUserJobApplications']);
});

////////////////////// Blogs  /////////////
Route::get('/blogs', [BlogController::class, 'index']);
Route::get('/{permalink}/blog', [BlogController::class, 'getBlogbyPermalink']);

////////////////////// Properties  /////////////
Route::post('properties', [PropertyController::class, 'store']);
Route::get('properties/uuid/{uuid}', [PropertyController::class, 'getByUuid']);

////////////////////// Property Details  /////////////
Route::post('property-details', [PropertyDetailController::class, 'store']);
Route::get('property-details/uuid/{uuid}', [PropertyDetailController::class, 'getByUuid']);


////////////////////// Bookings  /////////////
Route::post('booking', [BookingController::class, 'store']);
Route::get('booking/uuid/{uuid}', [BookingController::class, 'getByUuid']);

////////////////////// Booking Items  /////////////
Route::post('booking-item', [BookingItemController::class, 'store']);
Route::get('booking-item/uuid/{uuid}', [BookingItemController::class, 'getByUuid']);
Route::get('items-list', [BookingItemController::class, 'getAllItems']);
Route::post('booking-item/add', [BookingItemController::class, 'addItem']);
Route::post('booking-item/{id}/update', [BookingItemController::class, 'updateItem']);
Route::delete('booking-item/{id}', [BookingItemController::class, 'removeItem']);

////////////////////// Quotes  /////////////
Route::post('quote', [QuoteController::class, 'store']);
Route::get('quote/uuid/{uuid}', [QuoteController::class, 'getByUuid']);
Route::post('quote/update', [QuoteController::class, 'update']);
Route::post('quote/create-remaining-payment-link', [QuoteController::class, 'createRemainingPaymentLinkEndpoint']);
Route::get('quote/payment-intent-status', [QuoteController::class, 'getPaymentIntentStatus']);

////////////////////// Trucks  /////////////
Route::get('trucks', [TrcukController::class, 'index']);

////////////////////// Users  /////////////
Route::post('user/create-or-update', [UserController::class, 'createOrUpdate']);

////////////////////// General Settings  /////////////
Route::get('general-settings', [GeneralSettingController::class, 'index']);

////////////////////// Stripe Webhooks  /////////////
// Note: No CSRF protection needed for webhooks, and we need raw body for signature verification
Route::post('stripe/webhook', [StripeWebhookController::class, 'handleWebhook']);

////////////////////// Testimonials  /////////////
Route::get('testimonials', [\App\Http\Controllers\API\TestimonialController::class, 'index']);






// Step 2: Handle eBay callback and exchange code for token
Route::fallback(function () {
    return response()->json(['message' => 'Route Not Found'], 404);
});
