<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\GeneralSettings;
use Illuminate\Http\Request;
use App\Http\Controllers\API\Traits\JsonResponseTrait;

class GeneralSettingController extends Controller
{
    use JsonResponseTrait;
    
    public function index()
    {
        // Get only the specific settings: _b_name, _b_email, _b_number
        $settings = GeneralSettings::whereIn('option', ['_b_name', '_b_email', '_b_number','_b_area_address','_b_street_address'
        ,'_facebook_link','_instagram_link','_youtube_link','_twitter_link','_linke_din','_hours_mon_fri_open','_hours_mon_fri_close',
        '_hours_sat_open','_hours_sat_close','_hours_sun_closed',
        '_local_job_minimum_order','_interstate_job_minimum_order','_local_job_deposit_amount',
        '_interstate_job_deposit_percentage', '_local_job_number_of_movers', '_bases' ,'_b_landline_number',
        '_whats_app_number','_bank_name','_bank_details','_bsb','_acc'])->get();
        $result = [];
        foreach ($settings as $setting) {
            // Decode JSON for bases to return as array
            if ($setting->option === '_bases') {
                $decoded = json_decode($setting->value, true);
                $result[$setting->option] = (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) ? $decoded : [];
            } else {
                $result[$setting->option] = $setting->value;
            }
        }
        return $this->success($result);
    }
}