<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index()
    {
        $services = Service::where('active', 1)->get();
        return $this->success($services, 'Services fetched successfully');
    }

    public function getServicebyPermalink(Service $service, $permalink)
    {
        $service = $service->getServiceWithPermalink($permalink);
        if (!$service) {
            return $this->error('Service not found', 404);
        }
        if ($service->active != 1) {
            return $this->error('Service is not active', 404);
        }
        return $this->success($service, 'Service fetched successfully');
    }
}